/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.internal.OS;
import com.teamdev.jxbrowser.chromium.swing.internal.AWTHelper;
import com.teamdev.jxbrowser.chromium.swing.internal.NativeLinux;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.SwingUtilities;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Native {
    private static Native instance = null;

    Native() {
    }

    public static Native getInstance() {
        if (instance == null) {
            if (OS.isWindows() || OS.isMac()) {
                instance = new Native();
            } else if (OS.isLinux()) {
                instance = new NativeLinux();
            } else {
                throw new IllegalStateException("Unsupported operating system.");
            }
        }
        return instance;
    }

    public long getWindowHandle(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null) {
            return AWTHelper.getInstance().getWindowHandle(window);
        }
        return 0L;
    }

    public int getNativeKeyCode(KeyEvent event) {
        String paramString = event.paramString();
        String rawCodeParamStr = "rawCode=";
        int indexOfRawCode = paramString.indexOf(rawCodeParamStr);
        int indexOfRawCodeValue = indexOfRawCode + rawCodeParamStr.length();
        paramString = paramString.substring(indexOfRawCodeValue);
        int indexOfComma = paramString.indexOf(44);
        String rawCodeString = paramString.substring(0, indexOfComma);
        long rawCode = Long.parseLong(rawCodeString);
        return (int)rawCode;
    }

    public boolean isDpiAware() {
        return OS.isMac() || OS.isWindows();
    }
}

