/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java.jna;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import org.hid4java.jna.HidApiLibrary;
import org.hid4java.jna.HidDeviceInfoStructure;
import org.hid4java.jna.HidDeviceStructure;
import org.hid4java.jna.WideStringBuffer;

public class HidApi {
    private static int a = 512;
    private static final HidApiLibrary b = HidApiLibrary.INSTANCE;

    /*
     * WARNING - void declaration
     */
    public static HidDeviceStructure open(int vendor, int product, String serialNumber) {
        void var2_3;
        void var1_2;
        int n;
        Pointer pointer = b.hid_open((short)n, (short)var1_2, serialNumber == null ? null : new WString((String)var2_3));
        if (pointer != null) {
            return new HidDeviceStructure(pointer);
        }
        return null;
    }

    public static void init() {
        b.hid_init();
    }

    public static void exit() {
        b.hid_exit();
    }

    public static HidDeviceStructure open(String path) {
        String string;
        if ((string = b.hid_open_path(string)) == null) {
            return null;
        }
        return new HidDeviceStructure((Pointer)string);
    }

    public static void close(HidDeviceStructure device) {
        if (device != null) {
            HidDeviceStructure hidDeviceStructure;
            b.hid_close(hidDeviceStructure.ptr());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static HidDeviceInfoStructure enumerateDevices(int vendor, int product) {
        void var1_1;
        int n;
        return b.hid_enumerate((short)n, (short)var1_1);
    }

    public static void freeEnumeration(HidDeviceInfoStructure list) {
        HidDeviceInfoStructure hidDeviceInfoStructure;
        b.hid_free_enumeration(hidDeviceInfoStructure.getPointer());
    }

    public static String getLastErrorMessage(HidDeviceStructure device) {
        HidDeviceStructure hidDeviceStructure;
        if (device == null) {
            return "Device not initialised";
        }
        if ((hidDeviceStructure = b.hid_error(hidDeviceStructure.ptr())) == null) {
            return null;
        }
        return new WideStringBuffer(hidDeviceStructure.getByteArray(0L, a)).toString();
    }

    public static String getManufacturer(HidDeviceStructure device) {
        HidDeviceStructure hidDeviceStructure;
        if (device == null) {
            return "Device not initialised";
        }
        WideStringBuffer wideStringBuffer = new WideStringBuffer(a);
        b.hid_get_manufacturer_string(hidDeviceStructure.ptr(), wideStringBuffer, a);
        return wideStringBuffer.toString();
    }

    public static String getProductId(HidDeviceStructure device) {
        HidDeviceStructure hidDeviceStructure;
        if (device == null) {
            return "Device not initialised";
        }
        WideStringBuffer wideStringBuffer = new WideStringBuffer(a);
        b.hid_get_product_string(hidDeviceStructure.ptr(), wideStringBuffer, a);
        return wideStringBuffer.toString();
    }

    public static String getSerialNumber(HidDeviceStructure device) {
        HidDeviceStructure hidDeviceStructure;
        if (device == null) {
            return "Device not initialised";
        }
        WideStringBuffer wideStringBuffer = new WideStringBuffer(a);
        b.hid_get_serial_number_string(hidDeviceStructure.ptr(), wideStringBuffer, a);
        return wideStringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean setNonBlocking(HidDeviceStructure device, boolean nonBlocking) {
        void var1_1;
        HidDeviceStructure hidDeviceStructure;
        return device != null && 0 == b.hid_set_nonblocking(hidDeviceStructure.ptr(), var1_1 != false ? 1 : 0);
    }

    public static int read(HidDeviceStructure device, byte[] buffer) {
        HidDeviceStructure hidDeviceStructure;
        WideStringBuffer wideStringBuffer;
        if (device == null || buffer == null) {
            return -2;
        }
        WideStringBuffer wideStringBuffer2 = wideStringBuffer = new WideStringBuffer((byte[])wideStringBuffer);
        return b.hid_read(hidDeviceStructure.ptr(), wideStringBuffer2, wideStringBuffer2.buffer.length);
    }

    /*
     * WARNING - void declaration
     */
    public static int read(HidDeviceStructure device, byte[] buffer, int timeoutMillis) {
        void var2_2;
        void var1_1;
        HidDeviceStructure hidDeviceStructure;
        if (device == null || buffer == null) {
            return -2;
        }
        WideStringBuffer wideStringBuffer = new WideStringBuffer(buffer);
        return b.hid_read_timeout(hidDeviceStructure.ptr(), wideStringBuffer, ((void)var1_1).length, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int getFeatureReport(HidDeviceStructure device, byte[] data, byte reportId) {
        void var1_2;
        HidDeviceStructure hidDeviceStructure;
        void var2_3;
        if (device == null || data == null) {
            return -2;
        }
        WideStringBuffer wideStringBuffer = new WideStringBuffer(a);
        wideStringBuffer.buffer[0] = var2_3;
        int n = b.hid_get_feature_report(hidDeviceStructure.ptr(), wideStringBuffer, data.length + 1);
        if (n == -1) {
            return n;
        }
        System.arraycopy(wideStringBuffer.buffer, 1, var1_2, 0, n);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int sendFeatureReport(HidDeviceStructure device, byte[] data, byte reportId) {
        HidDeviceStructure hidDeviceStructure;
        void var1_1;
        void var2_2;
        if (device == null || data == null) {
            return -2;
        }
        WideStringBuffer wideStringBuffer = new WideStringBuffer(data.length + 1);
        wideStringBuffer.buffer[0] = var2_2;
        System.arraycopy(data, 0, wideStringBuffer.buffer, 1, ((void)var1_1).length);
        WideStringBuffer wideStringBuffer2 = wideStringBuffer;
        return b.hid_send_feature_report(hidDeviceStructure.ptr(), wideStringBuffer2, wideStringBuffer2.buffer.length);
    }

    /*
     * WARNING - void declaration
     */
    public static int write(HidDeviceStructure device, byte[] data, int len, byte reportId) {
        HidDeviceStructure hidDeviceStructure;
        WideStringBuffer wideStringBuffer;
        if (device == null || data == null) {
            return -2;
        }
        if (data.length < len) {
            len = data.length;
        }
        if (Platform.isWindows() && reportId == 0) {
            wideStringBuffer = new WideStringBuffer(len);
            if (len > 1) {
                System.arraycopy(data, 0, wideStringBuffer.buffer, 0, len);
            }
        } else {
            void var3_3;
            wideStringBuffer = new WideStringBuffer(len + 1);
            wideStringBuffer.buffer[0] = var3_3;
            if (len > 1) {
                void var2_2;
                void var1_1;
                System.arraycopy(var1_1, 0, wideStringBuffer.buffer, 1, (int)var2_2);
            }
        }
        WideStringBuffer wideStringBuffer2 = wideStringBuffer;
        return b.hid_write(hidDeviceStructure.ptr(), wideStringBuffer2, wideStringBuffer2.buffer.length);
    }

    /*
     * WARNING - void declaration
     */
    public static String getIndexedString(HidDeviceStructure device, int idx) {
        void var1_2;
        HidDeviceStructure hidDeviceStructure;
        if (device == null) {
            return "Device not initialised";
        }
        WideStringBuffer wideStringBuffer = new WideStringBuffer(a);
        int n = b.hid_get_indexed_string(hidDeviceStructure.ptr(), (int)var1_2, wideStringBuffer, a);
        if (n == -1) {
            return null;
        }
        return wideStringBuffer.toString();
    }
}

