/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.swing.internal.Native;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SwingUtil {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static int getNativeKeyCode(KeyEvent event) {
        int n2 = 0;
        try {
            KeyEvent keyEvent;
            Field field = event.getClass().getDeclaredField("rawCode");
            field.setAccessible(true);
            n2 = (int)field.getLong(keyEvent);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            a.log(Level.SEVERE, "Failed to get native key code.", noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            a.log(Level.SEVERE, "Failed to get native key code.", illegalAccessException);
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static void setNativeKeyCode(KeyEvent event, long keyCode) {
        try {
            void var1_1;
            KeyEvent keyEvent;
            Field field = event.getClass().getDeclaredField("rawCode");
            field.setAccessible(true);
            field.setLong(keyEvent, (long)var1_1);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            a.log(Level.SEVERE, "Failed to set native key code.", illegalAccessException);
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            a.log(Level.SEVERE, "Failed to set native key code.", noSuchFieldException);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isSystemKey(int keyCode, int eventID) {
        void var1_1;
        return keyCode == (Environment.isWindows() && var1_1 == 400 ? 13 : 10);
    }

    public static boolean isDpiAware() {
        return Native.getInstance().isDpiAware();
    }

    public static Point getDpiAwareCoordinatesForComponent(Point location, Component component) {
        Point point;
        point = new Point(point);
        if (!SwingUtil.isDpiAware()) {
            String string;
            long l2 = Native.getInstance().getWindowHandle((Component)((Object)string));
            string = SharedMemoryLibrary.getInstance().getDisplayIdForWindow(l2);
            double d2 = SharedMemoryLibrary.getInstance().getScaleFactorForDisplay(string);
            point.x = (int)Math.round((double)point.x * d2);
            point.y = (int)Math.round((double)point.y * d2);
        }
        return point;
    }

    public static void setMostRecentFocusOwner(Component focusOwner) {
        Object object;
        for (object = focusOwner; object != null && !(object instanceof Window); object = ((Component)object).getParent()) {
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Class<?> clazz = keyboardFocusManager.getClass();
        while (!clazz.getName().equals(KeyboardFocusManager.class.getName())) {
            clazz = clazz.getSuperclass();
        }
        try {
            Component component;
            Method method = clazz.getDeclaredMethod("getMostRecentFocusOwner", Window.class);
            method.setAccessible(true);
            object = method.invoke((Object)keyboardFocusManager, object);
            if (object != null && object.equals(focusOwner)) {
                return;
            }
            object = clazz.getDeclaredMethod("setMostRecentFocusOwner", Component.class);
            ((Method)object).setAccessible(true);
            ((Method)object).invoke((Object)keyboardFocusManager, component);
            return;
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Failed to updated the most recent focus owner.", exception);
            return;
        }
    }
}

