/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.EditorCommand;
import com.teamdev.jxbrowser.chromium.InputEventsHandler;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.events.GestureEvent;
import com.teamdev.jxbrowser.chromium.internal.Display;
import com.teamdev.jxbrowser.chromium.internal.DragAndDropData;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.ImeFunctions;
import com.teamdev.jxbrowser.chromium.internal.LightWeightWidgetListener;
import com.teamdev.jxbrowser.chromium.internal.MacShortcutSupport;
import com.teamdev.jxbrowser.chromium.internal.MouseDragEventConverter;
import com.teamdev.jxbrowser.chromium.internal.NativeKeyModifiers;
import com.teamdev.jxbrowser.chromium.internal.ReflectionUtil;
import com.teamdev.jxbrowser.chromium.internal.SharedMemory;
import com.teamdev.jxbrowser.chromium.internal.SharedMemoryLibrary;
import com.teamdev.jxbrowser.chromium.internal.TaskExecutorService;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragEndedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.DragTargetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardInputMethodEventMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardKeyboardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseWheelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.NotifyDisplayChangedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCursorChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetParentForWindowlessPluginMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnImeCompositionRangeChangedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPaintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShowPopupWidgetMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnStartDraggingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTakeFocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTooltipChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UnfocusMessage;
import com.teamdev.jxbrowser.chromium.swing.internal.CursorType;
import com.teamdev.jxbrowser.chromium.swing.internal.DisplayWatcher;
import com.teamdev.jxbrowser.chromium.swing.internal.DragAndDropSupport;
import com.teamdev.jxbrowser.chromium.swing.internal.DragEndPoint;
import com.teamdev.jxbrowser.chromium.swing.internal.LightWeightPopup;
import com.teamdev.jxbrowser.chromium.swing.internal.MacShortcutsCommandFactory;
import com.teamdev.jxbrowser.chromium.swing.internal.MemoryImage;
import com.teamdev.jxbrowser.chromium.swing.internal.Native;
import com.teamdev.jxbrowser.chromium.swing.internal.NativeKeyCodes;
import com.teamdev.jxbrowser.chromium.swing.internal.SwingUtil;
import com.teamdev.jxbrowser.chromium.swing.internal.TransferableWrapper;
import com.teamdev.jxbrowser.chromium.swing.internal.Widget;
import com.teamdev.jxbrowser.chromium.swing.internal.s;
import com.teamdev.jxbrowser.chromium.swing.internal.t;
import com.teamdev.jxbrowser.chromium.swing.internal.u;
import com.teamdev.jxbrowser.chromium.swing.internal.v;
import com.teamdev.jxbrowser.chromium.swing.internal.w;
import com.teamdev.jxbrowser.chromium.swing.internal.x;
import com.teamdev.jxbrowser.chromium.swing.internal.y;
import com.teamdev.jxbrowser.chromium.swing.internal.z;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class LightWeightWidget
extends Widget {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private static LightWeightWidget b;
    private final NativeKeyCodes c;
    private final MemoryImage d = new MemoryImage();
    private final KeyListener e;
    private final FocusListener f;
    private final i g = new i(this, 0);
    private final ChannelListener h;
    private final TaskExecutorService.TaskExecutor i;
    private final ComponentListener j;
    private final ComponentListener k;
    private final IPCChannelListener l;
    private final DragAndDropSupport m;
    private final MouseDragEventConverter n;
    private final com.teamdev.jxbrowser.chromium.swing.internal.f o;
    private final List<LightWeightWidgetListener> p;
    private final TaskExecutorService q;
    private final DisplayWatcher r;
    private ScheduledExecutorService s;
    private int t;
    private boolean u;
    private InputEventsHandler<KeyEvent> v;
    private InputEventsHandler<MouseEvent> w;
    private MacShortcutSupport<KeyEvent> x;
    private long[] y;
    private int z;
    private long A;
    private long B;
    private Display C;

    LightWeightWidget(Browser browser) {
        this((IPC)ReflectionUtil.invokeMethod(browser, "getIPC"), (Channel)ReflectionUtil.invokeMethod(browser, "getChannel"));
        LightWeightWidget lightWeightWidget;
        if (Environment.isMac()) {
            this.x = new c((Browser)((Object)lightWeightWidget));
        }
        if (System.getProperties().containsKey("jxbrowser.print.fps")) {
            lightWeightWidget = this;
            new Timer().schedule((TimerTask)new v(lightWeightWidget), 1000L, 1000L);
        }
    }

    /*
     * WARNING - void declaration
     */
    public LightWeightWidget(IPC ipc, Channel channel) {
        super((IPC)object, (Channel)var2_2);
        void var2_2;
        Object object;
        this.e = new h(this, 0);
        this.j = new j(this, 0);
        this.f = new g(this, 0);
        this.k = new f(this, 0);
        this.h = new e(this, 0);
        object = new k(this, 0);
        this.m = new DragAndDropSupport((DropTargetListener)object, (DragSourceListener)object);
        this.n = new MouseDragEventConverter();
        this.l = new b(this, 0);
        this.p = new ArrayList<LightWeightWidgetListener>();
        this.o = Environment.isMac() ? new d(this, 0) : new com.teamdev.jxbrowser.chromium.swing.internal.f(this, 0);
        this.c = new NativeKeyCodes();
        this.q = new TaskExecutorService();
        this.i = this.q.create();
        this.i.start();
        this.C = Display.getPrimaryDisplay();
        this.r = new DisplayWatcher(new a(this, 0));
        this.setFocusable(true);
        this.setOpaque(false);
        this.setIgnoreRepaint(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setTransferHandler(new s(this));
        object = this;
        ((Widget)object).getIPC().addIPCChannelListener(((LightWeightWidget)object).l);
        object = this;
        ((Widget)object).getChannel().addChannelListener(((LightWeightWidget)object).h);
        this.enableEvents(2056L);
    }

    public static LightWeightWidget getFocusedWidget() {
        return b;
    }

    /*
     * WARNING - void declaration
     */
    public void imeCommitText(String text) {
        void var1_1;
        ForwardInputMethodEventMessage forwardInputMethodEventMessage = new ForwardInputMethodEventMessage();
        new ForwardInputMethodEventMessage().text = var1_1;
        forwardInputMethodEventMessage.flags = 0;
        this.getChannel().send(forwardInputMethodEventMessage);
    }

    /*
     * WARNING - void declaration
     */
    public void imeSetComposition(String text, String underlines, int rangeStart, int rangeEnd) {
        void var3_3;
        void var2_2;
        void var1_1;
        ForwardInputMethodEventMessage forwardInputMethodEventMessage = new ForwardInputMethodEventMessage();
        new ForwardInputMethodEventMessage().text = var1_1;
        forwardInputMethodEventMessage.undelines = var2_2;
        forwardInputMethodEventMessage.position = var3_3;
        forwardInputMethodEventMessage.endPos = rangeEnd;
        forwardInputMethodEventMessage.flags = 1;
        this.getChannel().send(forwardInputMethodEventMessage);
    }

    public void imeCancelComposition() {
        ForwardInputMethodEventMessage forwardInputMethodEventMessage = new ForwardInputMethodEventMessage();
        new ForwardInputMethodEventMessage().flags = 2;
        this.getChannel().send(forwardInputMethodEventMessage);
    }

    final void a(boolean bl) {
        this.u = bl;
    }

    private void b() {
        Point point;
        if (this.y == null) {
            return;
        }
        long[] lArray = new long[this.y.length];
        System.arraycopy(this.y, 0, lArray, 0, this.y.length);
        Serializable serializable = this;
        Container container = SwingUtilities.getWindowAncestor((Component)serializable);
        if (container instanceof RootPaneContainer) {
            container = ((RootPaneContainer)((Object)container)).getContentPane();
        }
        if (container != null) {
            double d2 = ((Component)serializable).getLocationOnScreen().getX() - container.getLocationOnScreen().getX();
            double d3 = ((Component)serializable).getLocationOnScreen().getY() - container.getLocationOnScreen().getY();
            point = new Point((int)d2, (int)d3);
        } else {
            point = new Point(0, 0);
        }
        serializable = point;
        long l2 = lArray[0];
        int n2 = 0;
        while ((long)n2 < l2) {
            int n3 = (n2 << 2) + 1;
            lArray[n3] = (long)((double)lArray[n3] + ((Point)serializable).getX());
            int n4 = (n2 << 2) + 2;
            lArray[n4] = (long)((double)lArray[n4] + ((Point)serializable).getY());
            ++n2;
        }
        ImeFunctions.compositionChanged(Native.getInstance().getWindowHandle(this), this.A, this.B, lArray);
    }

    /*
     * WARNING - void declaration
     */
    public void addLightWeightWidgetListener(LightWeightWidgetListener listener) {
        if (!this.p.contains(listener)) {
            void var1_1;
            this.p.add((LightWeightWidgetListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeLightWeightWidgetListener(LightWeightWidgetListener listener) {
        void var1_1;
        this.p.remove(var1_1);
    }

    public List<LightWeightWidgetListener> getLightWeightWidgetListeners() {
        return new ArrayList<LightWeightWidgetListener>(this.p);
    }

    public Image getImage() {
        return this.d.getImage();
    }

    @Override
    public boolean isDragAndDropEnabled() {
        return this.m.isDragAndDropEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDragAndDropEnabled(boolean enabled) {
        void var1_1;
        this.m.setDragAndDropEnabled((boolean)var1_1);
    }

    public double getDeviceScaleFactor() {
        return this.d.getDeviceScaleFactor();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVisible(boolean aFlag) {
        void var1_1;
        super.setVisible(aFlag);
        if (var1_1 != false) {
            this.d();
            return;
        }
        this.c();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processMouseMotionEvent(MouseEvent e2) {
        if (e2.getID() == 503) {
            super.processMouseMotionEvent(e2);
            if (this.a(e2)) {
                this.forwardMouseEvent(e2);
            }
            return;
        }
        if (e2.getID() == 506 && this.m.isDragStarted()) {
            super.processMouseMotionEvent(e2);
            if (this.m.isDragGestureRecognized()) {
                this.m.setDragStarted(false);
                this.m.setDragGestureRecognized(false);
                return;
            }
        } else if (this.a(e2)) {
            void var1_1;
            this.forwardMouseEvent((MouseEvent)var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D graphics2D;
        super.paintComponent(g2);
        graphics2D = graphics2D;
        if (SwingUtil.isDpiAware()) {
            double d2 = 1.0 / this.d.getDeviceScaleFactor();
            graphics2D.scale(d2, d2);
        }
        MemoryImage memoryImage = this.d;
        synchronized (memoryImage) {
            graphics2D.drawImage(this.d.getImage(), 0, 0, this);
            return;
        }
    }

    private void c() {
        this.d.setVisible(false);
        this.removeFocusListener(this.f);
        this.removeComponentListener(this.j);
        this.removeKeyListener(this.e);
        this.removeMouseListener(this.g);
        this.removeMouseMotionListener(this.g);
        this.removeMouseWheelListener(this.g);
        this.m.unregisterDragGestureHandler();
        this.repaint();
    }

    private void d() {
        if (!this.d.isVisible()) {
            this.sendBounds(this.getSize());
            this.addFocusListener(this.f);
            this.addMouseListener(this.g);
            this.addMouseMotionListener(this.g);
            this.addMouseWheelListener(this.g);
            this.addKeyListener(this.e);
            this.addComponentListener(this.j);
            this.d.setVisible(true);
            this.m.registerDragGestureHandler(this);
            this.repaint();
        }
    }

    protected void enableDisplayWatcher() {
        this.r.attach(this);
    }

    protected void disableDisplayWatcher() {
        this.r.detach(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.d();
        LightWeightWidget lightWeightWidget = this;
        Window window = SwingUtilities.getWindowAncestor(lightWeightWidget);
        if (window != null) {
            window.addComponentListener(lightWeightWidget.k);
        }
        this.enableDisplayWatcher();
        if (Boolean.getBoolean("jxbrowser.java.ime")) {
            ImeFunctions.registerBrowserWindow(Native.getInstance().getWindowHandle(this));
        }
    }

    @Override
    public void removeNotify() {
        this.sendBounds(new Dimension());
        this.c();
        LightWeightWidget lightWeightWidget = this;
        Window window = SwingUtilities.getWindowAncestor(lightWeightWidget);
        if (window != null) {
            window.removeComponentListener(lightWeightWidget.k);
        }
        this.disableDisplayWatcher();
        if (Boolean.getBoolean("jxbrowser.java.ime")) {
            ImeFunctions.unregisterBrowserWindow(Native.getInstance().getWindowHandle(this));
        }
        super.removeNotify();
    }

    @Override
    public void dispose() {
        Object object = this;
        ((Widget)object).getIPC().removeIPCChannelListener(((LightWeightWidget)object).l);
        object = this;
        ((Widget)object).getChannel().removeChannelListener(((LightWeightWidget)object).h);
        this.i.stop();
        this.q.stop();
        if (this.s != null && (object = this.s.shutdownNow()).size() > 0) {
            a.info("Failed to cancel MouseWheelEventsForwarderMac schedule task.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setKeyEventsHandler(InputEventsHandler<KeyEvent> handler) {
        void var1_1;
        this.v = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMouseEventsHandler(InputEventsHandler<MouseEvent> handler) {
        void var1_1;
        this.w = var1_1;
    }

    @Override
    public void setGestureEventsHandler(InputEventsHandler<GestureEvent> handler) {
    }

    /*
     * WARNING - void declaration
     */
    public void forwardMouseWheelEvent(MouseWheelEvent event) {
        void var1_1;
        this.o.a((MouseWheelEvent)var1_1);
    }

    public void forwardTouchMoveEvent(MouseEvent mouseDragEvent) {
        Object object;
        object = this.n.getMouseWheelEvents((MouseEvent)object);
        object = object.iterator();
        while (object.hasNext()) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)object.next();
            this.o.a(mouseWheelEvent, 1);
        }
    }

    private boolean a(MouseEvent mouseEvent) {
        if (this.w != null) {
            try {
                return !this.w.handle(mouseEvent);
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "The MouseEventsHandler.handle() method has thrown exception: ", exception);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void forwardMouseEvent(MouseEvent event) {
        boolean bl;
        if (event.getID() == 506 && Environment.isWindows() && !(bl = SharedMemoryLibrary.getInstance().isCursorVisible())) {
            this.forwardTouchMoveEvent(event);
            return;
        }
        this.n.reset();
        Point point = LightWeightWidget.a(event.getComponent());
        int n2 = event.getX();
        int n3 = event.getY();
        int n4 = point.x + n2;
        int n5 = point.y + n3;
        if (!SwingUtil.isDpiAware()) {
            double d2 = this.d.getDeviceScaleFactor();
            n2 = (int)((double)n2 / d2);
            n3 = (int)((double)n3 / d2);
            n4 = (int)((double)n4 / d2);
            n5 = (int)((double)n5 / d2);
        }
        if (!this.getChannel().isClosed()) {
            int n6;
            void var1_1;
            ForwardMouseMessage forwardMouseMessage = new ForwardMouseMessage();
            new ForwardMouseMessage().eventType = event.getID();
            forwardMouseMessage.x = n2;
            forwardMouseMessage.y = n3;
            forwardMouseMessage.globalX = n4;
            forwardMouseMessage.globalY = n5;
            forwardMouseMessage.windowX = n2;
            forwardMouseMessage.windowY = n3;
            MouseEvent mouseEvent = event;
            forwardMouseMessage.button = SwingUtilities.isLeftMouseButton(mouseEvent) ? 1 : (SwingUtilities.isMiddleMouseButton(mouseEvent) ? 2 : (SwingUtilities.isRightMouseButton(mouseEvent) ? 3 : 0));
            forwardMouseMessage.clickCount = event.getClickCount();
            int n7 = event.getModifiersEx();
            if (var1_1.getButton() == 3) {
                n7 &= 0xFFFFFEFF;
            }
            int n8 = n6 = n7;
            n8 = n6 & 0xFFFFE3FF;
            if ((n6 & 0x400) == 1024) {
                n8 |= NativeKeyModifiers.LEFT_BUTTON_MASK.getValue();
            }
            if ((n6 & 0x800) == 2048) {
                n8 |= NativeKeyModifiers.MIDDLE_BUTTON_MASK.getValue();
            }
            if ((n6 & 0x1000) == 4096) {
                n8 |= NativeKeyModifiers.RIGHT_BUTTON_MASK.getValue();
            }
            forwardMouseMessage.modifiers = n8;
            this.getChannel().send(forwardMouseMessage);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forwardKeyPressedEvent(KeyEvent event) {
        void var1_1;
        this.t = Environment.isWindows() ? SwingUtil.getNativeKeyCode(event) : event.getKeyCode();
        var1_1.getWhen();
        this.a(event, 401);
    }

    /*
     * WARNING - void declaration
     */
    public void forwardKeyTypedEvent(KeyEvent event) {
        void var1_1;
        KeyEvent keyEvent;
        if (Environment.isWindows()) {
            int n2 = this.t != 0 ? this.t : SwingUtil.getNativeKeyCode(event);
            keyEvent = new KeyEvent(event.getComponent(), 401, event.getWhen(), event.getModifiers(), n2, event.getKeyChar(), event.getKeyLocation());
            SwingUtil.setNativeKeyCode(keyEvent, n2);
        } else {
            int n3 = this.t != 0 ? this.t : event.getKeyCode();
            keyEvent = new KeyEvent(event.getComponent(), 401, event.getWhen(), event.getModifiers(), n3, event.getKeyChar(), event.getKeyLocation());
        }
        var1_1.getWhen();
        this.a(keyEvent, 400);
    }

    /*
     * WARNING - void declaration
     */
    public void forwardKeyReleasedEvent(KeyEvent event) {
        void var1_1;
        this.t = 0;
        var1_1.getWhen();
        this.a(event, 402);
    }

    private void a(KeyEvent keyEvent, int n2) {
        int n3 = keyEvent.getModifiersEx();
        int n4 = keyEvent.getKeyCode();
        char c2 = keyEvent.getKeyChar();
        int n5 = keyEvent.getKeyLocation();
        n4 = this.c.toBrowserKeyCode(n4, n5).getCode();
        if (Environment.isWindows() && (n5 = SwingUtil.getNativeKeyCode(keyEvent)) != 0) {
            n4 = n5;
        }
        ForwardKeyboardMessage forwardKeyboardMessage = new ForwardKeyboardMessage();
        new ForwardKeyboardMessage().eventType = n2;
        forwardKeyboardMessage.systemKey = SwingUtil.isSystemKey(keyEvent.getKeyCode(), n2);
        forwardKeyboardMessage.keyChar = !forwardKeyboardMessage.systemKey && c2 != '\uffff' ? c2 : (char)'\u0000';
        forwardKeyboardMessage.windowsKeyCode = n4;
        forwardKeyboardMessage.modifiers = n3;
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(forwardKeyboardMessage);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void sendBounds(Dimension size) {
        void var1_1;
        Rectangle rectangle = new Rectangle();
        this.i.invoke(new y(this, rectangle, (Dimension)var1_1));
    }

    public void focus() {
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(new FocusMessage());
        }
    }

    public void unfocus() {
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(new UnfocusMessage());
        }
    }

    private static Point a(Component component) {
        if (component.isShowing()) {
            return component.getLocationOnScreen();
        }
        return new Point();
    }

    private void e() {
        this.m.setDragStarted(false);
        DragEndedMessage dragEndedMessage = new DragEndedMessage();
        Point point = this.m.getDragStartLocation();
        Point point2 = this.getLocationOnScreen();
        if (!SwingUtil.isDpiAware()) {
            double d2 = this.d.getDeviceScaleFactor();
            point2.x = (int)((double)point2.x / d2);
            point2.y = (int)((double)point2.y / d2);
        }
        int n2 = point.x - point2.x;
        int n3 = point.y - point2.y;
        dragEndedMessage.clientX = n2;
        dragEndedMessage.clientY = n3;
        dragEndedMessage.screenX = point.x;
        dragEndedMessage.screenY = point.y;
        if (!this.getChannel().isClosed()) {
            this.getChannel().send(dragEndedMessage);
        }
    }

    static /* synthetic */ int b(LightWeightWidget lightWeightWidget) {
        return lightWeightWidget.z;
    }

    static /* synthetic */ int a(LightWeightWidget lightWeightWidget, int n2) {
        lightWeightWidget.z = 0;
        return 0;
    }

    static /* synthetic */ void c(LightWeightWidget lightWeightWidget) {
        if (lightWeightWidget.getParent() != null) {
            lightWeightWidget.getParent().requestFocus();
            return;
        }
        lightWeightWidget.requestFocus();
    }

    static /* synthetic */ Display e(LightWeightWidget lightWeightWidget) {
        return lightWeightWidget.C;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void a(LightWeightWidget object, OnPaintMessage object22) {
        Object object2 = object22;
        ++((LightWeightWidget)((Object)object)).z;
        long l2 = ((OnPaintMessage)object2).pid;
        long l3 = ((OnPaintMessage)object2).sharedMemoryHandle;
        int n2 = ((OnPaintMessage)object2).sharedMemoryCapacity;
        int n3 = ((OnPaintMessage)object2).clientWidth;
        int n4 = ((OnPaintMessage)object2).clientHeight;
        int n5 = ((OnPaintMessage)object2).rectX;
        int n6 = ((OnPaintMessage)object2).rectY;
        int n7 = ((OnPaintMessage)object2).rectWidth;
        int n8 = ((OnPaintMessage)object2).rectHeight;
        Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
        Dimension dimension = new Dimension(n3, n4);
        String string = ((OnPaintMessage)object2).memoryFilePath;
        double d2 = ((OnPaintMessage)object2).deviceScaleFactor;
        SharedMemory sharedMemory = new SharedMemory(l2, l3, n2, dimension, string, d2);
        Object object3 = ((LightWeightWidget)((Object)object)).d;
        synchronized (object3) {
            ((LightWeightWidget)((Object)object)).d.updatePixels(sharedMemory, rectangle);
        }
        object3 = new Rectangle(rectangle);
        if (SwingUtil.isDpiAware()) {
            ((Rectangle)object3).x = (int)((double)((Rectangle)object3).x / d2);
            ((Rectangle)object3).y = (int)((double)((Rectangle)object3).y / d2);
            ((Rectangle)object3).width = (int)((double)((Rectangle)object3).width / d2);
            ((Rectangle)object3).height = (int)((double)((Rectangle)object3).height / d2);
        }
        ((Component)((Object)object)).repaint(((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height);
        for (LightWeightWidgetListener lightWeightWidgetListener : ((LightWeightWidget)((Object)object)).getLightWeightWidgetListeners()) {
            lightWeightWidgetListener.onRepaint(rectangle, dimension);
        }
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnCursorChangeMessage onCursorChangeMessage) {
        int n2 = onCursorChangeMessage.cursorType;
        byte[] byArray = onCursorChangeMessage.pixels;
        int n3 = onCursorChangeMessage.width;
        int n4 = onCursorChangeMessage.height;
        int n5 = onCursorChangeMessage.hotspotX;
        int n6 = onCursorChangeMessage.hotspotY;
        Cursor cursor = CursorType.toJavaCursor(n2, byArray, n3, n4, n5, n6);
        if (cursor != null) {
            SwingUtilities.invokeLater(new x(lightWeightWidget, cursor));
        }
    }

    static /* synthetic */ void a(OnTakeFocusMessage onTakeFocusMessage) {
        if (onTakeFocusMessage.reverse) {
            SwingUtilities.invokeLater(new t());
            return;
        }
        SwingUtilities.invokeLater(new u());
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnStartDraggingMessage object) {
        lightWeightWidget.m.setDragStartLocation(new Point(((OnStartDraggingMessage)object).x, ((OnStartDraggingMessage)object).y));
        if (!lightWeightWidget.m.isDragAndDropEnabled()) {
            lightWeightWidget.e();
            return;
        }
        object = new DragAndDropData(((OnStartDraggingMessage)object).url, ((OnStartDraggingMessage)object).urlTitle, ((OnStartDraggingMessage)object).text, ((OnStartDraggingMessage)object).html, ((OnStartDraggingMessage)object).customData, ((OnStartDraggingMessage)object).htmlBaseURL);
        lightWeightWidget.m.setDragStarted(true);
        lightWeightWidget.m.setData((DragAndDropData)object);
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnTooltipChangeMessage object) {
        object = ((OnTooltipChangeMessage)object).tooltipText;
        SwingUtilities.invokeLater(new w(lightWeightWidget, (String)object));
    }

    static /* synthetic */ void a(LightWeightWidget object, OnShowPopupWidgetMessage onShowPopupWidgetMessage) {
        int n2 = onShowPopupWidgetMessage.channelId;
        Rectangle rectangle = onShowPopupWidgetMessage.popupBounds;
        double d2 = onShowPopupWidgetMessage.deviceScaleFactor;
        object = new LightWeightPopup((LightWeightWidget)object, n2, rectangle, d2);
        ((LightWeightPopup)object).show();
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnGetParentForWindowlessPluginMessage onGetParentForWindowlessPluginMessage) {
        if (Environment.isWindows()) {
            onGetParentForWindowlessPluginMessage.handle = Native.getInstance().getWindowHandle(lightWeightWidget);
        }
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, OnImeCompositionRangeChangedMessage onImeCompositionRangeChangedMessage) {
        if (Boolean.getBoolean("jxbrowser.java.ime")) {
            if (onImeCompositionRangeChangedMessage.getFlags() == 2) {
                String[] stringArray = onImeCompositionRangeChangedMessage.getCharactersInfo().split(",");
                lightWeightWidget.y = new long[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    lightWeightWidget.y[i2] = Long.parseLong(stringArray[i2]);
                }
                lightWeightWidget.A = onImeCompositionRangeChangedMessage.getStart();
                lightWeightWidget.B = onImeCompositionRangeChangedMessage.getEnd();
                lightWeightWidget.b();
                return;
            }
            if (onImeCompositionRangeChangedMessage.getFlags() == 1) {
                ImeFunctions.compositionCancelled(Native.getInstance().getWindowHandle(lightWeightWidget));
                return;
            }
            if (onImeCompositionRangeChangedMessage.getFlags() == 3) {
                ImeFunctions.closeImeWindow(Native.getInstance().getWindowHandle(lightWeightWidget));
            }
        }
    }

    static /* synthetic */ Point a(LightWeightWidget lightWeightWidget, Component component) {
        return LightWeightWidget.a(component);
    }

    static /* synthetic */ void a(LightWeightWidget lightWeightWidget, Display display) {
        v0.C = display;
        if (!lightWeightWidget.getChannel().isClosed()) {
            NotifyDisplayChangedMessage notifyDisplayChangedMessage = new NotifyDisplayChangedMessage();
            new NotifyDisplayChangedMessage().displayId = display.getId();
            lightWeightWidget.getChannel().send(notifyDisplayChangedMessage);
        }
        lightWeightWidget.b();
    }

    final class a
    implements DisplayWatcher.Observer {
        private /* synthetic */ LightWeightWidget a;

        private a(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onDisplayChanged(Display display) {
            void var1_1;
            LightWeightWidget.a(this.a, (Display)var1_1);
        }

        /* synthetic */ a(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class d
    extends com.teamdev.jxbrowser.chromium.swing.internal.f {
        private ForwardMouseWheelMessage b;
        private ForwardMouseWheelMessage c;

        private d(LightWeightWidget lightWeightWidget) {
            super(lightWeightWidget, (byte)0);
            lightWeightWidget.s = Executors.newScheduledThreadPool(1);
            lightWeightWidget.s.scheduleWithFixedDelay(new z(this, lightWeightWidget), 0L, 32L, TimeUnit.MILLISECONDS);
        }

        @Override
        public final synchronized void a(MouseWheelEvent object) {
            object = this.b((MouseWheelEvent)object, 10);
            if (((ForwardMouseWheelMessage)object).horizontalScroll) {
                if (this.b != null) {
                    double d2 = ((ForwardMouseWheelMessage)object).unitsToScroll;
                    double d3 = this.b.unitsToScroll;
                    ((ForwardMouseWheelMessage)object).unitsToScroll = d2 + d3;
                }
                this.b = object;
                return;
            }
            if (this.c != null) {
                double d4 = ((ForwardMouseWheelMessage)object).unitsToScroll;
                double d5 = this.c.unitsToScroll;
                ((ForwardMouseWheelMessage)object).unitsToScroll = d4 + d5;
            }
            this.c = object;
        }

        /* synthetic */ d(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }

        static /* synthetic */ ForwardMouseWheelMessage a(d d2) {
            return d2.b;
        }

        static /* synthetic */ ForwardMouseWheelMessage a(d d2, ForwardMouseWheelMessage forwardMouseWheelMessage) {
            d2.b = null;
            return null;
        }

        static /* synthetic */ ForwardMouseWheelMessage b(d d2) {
            return d2.c;
        }

        static /* synthetic */ ForwardMouseWheelMessage b(d d2, ForwardMouseWheelMessage forwardMouseWheelMessage) {
            d2.c = null;
            return null;
        }
    }

    final class k
    extends DragSourceAdapter
    implements DropTargetListener {
        private boolean a;
        private boolean b;
        private /* synthetic */ LightWeightWidget c;

        private k(LightWeightWidget lightWeightWidget) {
            this.c = lightWeightWidget;
        }

        @Override
        public final void dragEnter(DropTargetDragEvent dtde) {
            Point point;
            if (!this.c.m.isDragAndDropEnabled()) {
                dtde.rejectDrag();
                return;
            }
            this.a(dtde.getTransferable());
            if (this.c.m.getData() == null) {
                dtde.rejectDrag();
                return;
            }
            this.a = true;
            this.b = false;
            Point point2 = LightWeightWidget.a((Component)this.c);
            point = ((DropTargetDragEvent)((Object)point)).getLocation();
            point = new Point(point2.x + point.x, point2.y + point.y);
            this.a(point, this.c.m.getData());
        }

        @Override
        public final void dragExit(DropTargetEvent dte) {
            DragAndDropData dragAndDropData = this.c.m.getData();
            boolean bl = this.a;
            k k2 = this;
            if (bl && !k2.c.getChannel().isClosed()) {
                DragTargetMessage dragTargetMessage = new DragTargetMessage();
                new DragTargetMessage().flag = 1;
                dragTargetMessage.operations = DragTargetMessage.WebDragOperation.WebDragOperationNone.getValue();
                dragTargetMessage.keyModifiers = 0;
                dragTargetMessage.url = dragAndDropData.getURL();
                dragTargetMessage.urlTitle = dragAndDropData.getURLTitle();
                dragTargetMessage.text = dragAndDropData.getText();
                dragTargetMessage.html = dragAndDropData.getHTML();
                dragTargetMessage.customData = dragAndDropData.getCustomData();
                dragTargetMessage.htmlBaseURL = dragAndDropData.getHTMLBaseURL();
                k2.c.getChannel().send(dragTargetMessage);
            }
            this.a = false;
            this.b = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void drop(DropTargetDropEvent dtde) {
            void var1_1;
            Point point = LightWeightWidget.a((Component)this.c);
            Point point2 = dtde.getLocation();
            point = new Point(point.x + point2.x, point.y + point2.y);
            if (Environment.isMac()) {
                dtde.acceptDrop(dtde.getDropAction());
                this.a(dtde.getTransferable());
                this.a(point, this.c.m.getData());
            }
            this.a(point, this.a, this.c.m.getData());
            var1_1.dropComplete(true);
            this.a = false;
        }

        @Override
        public final void dragOver(DropTargetDragEvent dtde) {
            Object object;
            Point point = LightWeightWidget.a((Component)this.c);
            object = ((DropTargetDragEvent)object).getLocation();
            object = new Point(point.x + ((Point)object).x, point.y + ((Point)object).y);
            DragAndDropData dragAndDropData = this.c.m.getData();
            boolean bl = this.a;
            point = object;
            object = this;
            if (bl) {
                Point point2 = LightWeightWidget.a((Component)((k)object).c);
                int n2 = point.x - point2.x;
                int n3 = point.y - point2.y;
                int n4 = point.x;
                int n5 = point.y;
                if (!SwingUtil.isDpiAware()) {
                    double d2 = ((k)object).c.d.getDeviceScaleFactor();
                    n2 = (int)((double)n2 / d2);
                    n3 = (int)((double)n3 / d2);
                    n4 = (int)((double)n4 / d2);
                    n5 = (int)((double)n5 / d2);
                }
                DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
                if (!((k)object).c.getChannel().isClosed()) {
                    DragTargetMessage dragTargetMessage = new DragTargetMessage();
                    new DragTargetMessage().flag = 2;
                    dragTargetMessage.clientX = n2;
                    dragTargetMessage.clientY = n3;
                    dragTargetMessage.screenX = n4;
                    dragTargetMessage.screenY = n5;
                    dragTargetMessage.operations = webDragOperation.getValue();
                    dragTargetMessage.keyModifiers = 0;
                    dragTargetMessage.url = dragAndDropData.getURL();
                    dragTargetMessage.urlTitle = dragAndDropData.getURLTitle();
                    dragTargetMessage.text = dragAndDropData.getText();
                    dragTargetMessage.html = dragAndDropData.getHTML();
                    dragTargetMessage.customData = dragAndDropData.getCustomData();
                    dragTargetMessage.htmlBaseURL = dragAndDropData.getHTMLBaseURL();
                    ((k)object).c.getChannel().send(dragTargetMessage);
                }
            }
        }

        private void a(Transferable object) {
            object = new TransferableWrapper((Transferable)object);
            this.c.m.setData(new DragAndDropData(((TransferableWrapper)object).getURL(), "", ((TransferableWrapper)object).getText(), ((TransferableWrapper)object).getHTML(), ((TransferableWrapper)object).getCustomData(), ""));
        }

        private void a(Point point, DragAndDropData dragAndDropData) {
            Point point2 = LightWeightWidget.a((Component)this.c);
            int n2 = point.x - point2.x;
            int n3 = point.y - point2.y;
            int n4 = point.x;
            int n5 = point.y;
            if (!SwingUtil.isDpiAware()) {
                double d2 = this.c.d.getDeviceScaleFactor();
                n2 = (int)((double)n2 / d2);
                n3 = (int)((double)n3 / d2);
                n4 = (int)((double)n4 / d2);
                n5 = (int)((double)n5 / d2);
            }
            DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
            if (!this.c.getChannel().isClosed()) {
                DragTargetMessage dragTargetMessage = new DragTargetMessage();
                new DragTargetMessage().flag = 0;
                dragTargetMessage.clientX = n2;
                dragTargetMessage.clientY = n3;
                dragTargetMessage.screenX = n4;
                dragTargetMessage.screenY = n5;
                dragTargetMessage.operations = webDragOperation.getValue();
                dragTargetMessage.keyModifiers = 0;
                dragTargetMessage.url = dragAndDropData.getURL();
                dragTargetMessage.urlTitle = dragAndDropData.getURLTitle();
                dragTargetMessage.text = dragAndDropData.getText();
                dragTargetMessage.html = dragAndDropData.getHTML();
                dragTargetMessage.customData = dragAndDropData.getCustomData();
                dragTargetMessage.htmlBaseURL = dragAndDropData.getHTMLBaseURL();
                this.c.getChannel().send(dragTargetMessage);
            }
        }

        private DragEndPoint a(Point point, boolean bl) {
            int n2 = 0;
            int n3 = 0;
            int n4 = point.x;
            int n5 = point.y;
            if (!SwingUtil.isDpiAware()) {
                double d2 = this.c.d.getDeviceScaleFactor();
                n3 = n2 = (int)(0.0 / d2);
                n4 = (int)((double)n4 / d2);
                n5 = (int)((double)n5 / d2);
            }
            if (bl) {
                Point point2 = LightWeightWidget.a((Component)this.c);
                n2 = point.x - point2.x;
                n3 = point.y - point2.y;
                if (!SwingUtil.isDpiAware()) {
                    double d3 = this.c.d.getDeviceScaleFactor();
                    n2 = (int)((double)n2 / d3);
                    n3 = (int)((double)n3 / d3);
                }
            }
            DragEndPoint dragEndPoint = new DragEndPoint();
            new DragEndPoint().a = n2;
            dragEndPoint.b = n3;
            dragEndPoint.c = n4;
            dragEndPoint.d = n5;
            return dragEndPoint;
        }

        private void a(Point object, boolean bl, DragAndDropData dragAndDropData) {
            object = this.a((Point)object, bl);
            DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
            if (bl && !this.c.getChannel().isClosed()) {
                DragTargetMessage dragTargetMessage = new DragTargetMessage();
                new DragTargetMessage().flag = 3;
                dragTargetMessage.clientX = ((DragEndPoint)object).a;
                dragTargetMessage.clientY = ((DragEndPoint)object).b;
                dragTargetMessage.screenX = ((DragEndPoint)object).c;
                dragTargetMessage.screenY = ((DragEndPoint)object).d;
                dragTargetMessage.operations = webDragOperation.getValue();
                dragTargetMessage.keyModifiers = 0;
                dragTargetMessage.url = dragAndDropData.getURL();
                dragTargetMessage.urlTitle = dragAndDropData.getURLTitle();
                dragTargetMessage.text = dragAndDropData.getText();
                dragTargetMessage.html = dragAndDropData.getHTML();
                dragTargetMessage.customData = dragAndDropData.getCustomData();
                dragTargetMessage.htmlBaseURL = dragAndDropData.getHTMLBaseURL();
                this.c.getChannel().send(dragTargetMessage);
            }
            if (!this.c.getChannel().isClosed()) {
                DragEndedMessage dragEndedMessage = new DragEndedMessage();
                new DragEndedMessage().clientX = ((DragEndPoint)object).a;
                dragEndedMessage.clientY = ((DragEndPoint)object).b;
                dragEndedMessage.screenX = ((DragEndPoint)object).c;
                dragEndedMessage.screenY = ((DragEndPoint)object).d;
                dragEndedMessage.operations = webDragOperation.getValue();
                this.c.getChannel().send(dragEndedMessage);
            }
            this.c.m.setData(null);
        }

        @Override
        public final void dragDropEnd(DragSourceDropEvent dsde) {
            DragEndPoint dragEndPoint;
            if (this.b) {
                this.a(dsde.getLocation(), this.a, this.c.m.getData());
                return;
            }
            dragEndPoint = this.a(((DragSourceEvent)((Object)dragEndPoint)).getLocation(), this.a);
            DragTargetMessage.WebDragOperation webDragOperation = DragTargetMessage.WebDragOperation.WebDragOperationEvery;
            if (!this.c.getChannel().isClosed()) {
                DragEndedMessage dragEndedMessage = new DragEndedMessage();
                new DragEndedMessage().clientX = dragEndPoint.a;
                dragEndedMessage.clientY = dragEndPoint.b;
                dragEndedMessage.screenX = dragEndPoint.c;
                dragEndedMessage.screenY = dragEndPoint.d;
                dragEndedMessage.operations = webDragOperation.getValue();
                this.c.getChannel().send(dragEndedMessage);
            }
        }

        @Override
        public final void dropActionChanged(DropTargetDragEvent dtde) {
        }

        /* synthetic */ k(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class e
    implements ChannelListener {
        private /* synthetic */ LightWeightWidget a;

        private e(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onMessageReceived(Message message) {
            MessageType messageType = message.getType();
            if (messageType == MessageType.OnPaint) {
                LightWeightWidget.a(this.a, (OnPaintMessage)message);
                return;
            }
            if (messageType == MessageType.OnCursorChange) {
                LightWeightWidget.a(this.a, (OnCursorChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnRenderViewGone) {
                this.a.c();
                return;
            }
            if (messageType == MessageType.OnRenderViewCreated) {
                this.a.d();
                return;
            }
            if (messageType == MessageType.OnTakeFocus) {
                LightWeightWidget.a((OnTakeFocusMessage)message);
                return;
            }
            if (messageType == MessageType.OnStartDragging) {
                LightWeightWidget.a(this.a, (OnStartDraggingMessage)message);
                return;
            }
            if (messageType == MessageType.OnTooltipChange) {
                LightWeightWidget.a(this.a, (OnTooltipChangeMessage)message);
                return;
            }
            if (messageType == MessageType.OnShowPopupWidget) {
                LightWeightWidget.a(this.a, (OnShowPopupWidgetMessage)message);
                return;
            }
            if (messageType == MessageType.OnGetParentForWindowlessPlugin) {
                LightWeightWidget.a(this.a, (OnGetParentForWindowlessPluginMessage)message);
                return;
            }
            if (messageType == MessageType.OnImeCompositionRangeChanged) {
                void var1_1;
                LightWeightWidget.a(this.a, (OnImeCompositionRangeChangedMessage)var1_1);
            }
        }

        /* synthetic */ e(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class b
    extends IPCChannelAdapter {
        private /* synthetic */ LightWeightWidget a;

        private b(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onChannelRemoved(Channel channel) {
            void var1_1;
            boolean bl;
            Channel channel2 = this.a.getChannel();
            boolean bl2 = channel.getChannelId() == channel2.getChannelId();
            boolean bl3 = bl = var1_1.getType() == channel2.getType();
            if (bl2 && bl) {
                this.a.c();
            }
        }

        /* synthetic */ b(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class g
    extends FocusAdapter {
        private /* synthetic */ LightWeightWidget a;

        private g(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void focusGained(FocusEvent e2) {
            b = this.a;
            this.a.focus();
        }

        @Override
        public final void focusLost(FocusEvent e2) {
            b = null;
            this.a.unfocus();
        }

        /* synthetic */ g(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class j
    extends ComponentAdapter {
        private /* synthetic */ LightWeightWidget a;

        private j(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void componentResized(ComponentEvent e2) {
            Serializable serializable = e2.getComponent();
            if (serializable != null) {
                serializable = ((Component)serializable).getBounds();
                this.a.sendBounds(((Rectangle)serializable).getSize());
            }
        }

        /* synthetic */ j(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class h
    extends KeyAdapter {
        private /* synthetic */ LightWeightWidget a;

        private h(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void keyPressed(KeyEvent e2) {
            KeyEvent keyEvent = e2;
            if (keyEvent.getKeyChar() == '\t') {
                keyEvent.consume();
            }
            if (this.b(e2)) {
                this.a.forwardKeyPressedEvent(e2);
                this.a(e2);
            }
            if (this.a.x != null) {
                void var1_1;
                this.a.x.handleKeyPress(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void keyTyped(KeyEvent e2) {
            if (this.b(e2)) {
                void var1_1;
                this.a.forwardKeyTypedEvent(e2);
                this.a((KeyEvent)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void keyReleased(KeyEvent e2) {
            if (this.b(e2)) {
                void var1_1;
                this.a.forwardKeyReleasedEvent(e2);
                this.a((KeyEvent)var1_1);
            }
        }

        private void a(KeyEvent keyEvent) {
            KeyListener[] keyListenerArray = this.a.getParent();
            if (keyListenerArray != null) {
                int n2 = Boolean.parseBoolean(System.getProperty("jxbrowser.swing.lightweight.keyevent.redispatch.disabled", "false"));
                if (n2 != 0) {
                    for (KeyListener keyListener : keyListenerArray.getKeyListeners()) {
                        if (keyEvent.getID() == 401) {
                            keyListener.keyPressed(keyEvent);
                        }
                        if (keyEvent.getID() == 400) {
                            keyListener.keyTyped(keyEvent);
                        }
                        if (keyEvent.getID() != 402) continue;
                        keyListener.keyReleased(keyEvent);
                    }
                    return;
                }
                keyListenerArray.dispatchEvent(keyEvent);
            }
        }

        private boolean b(KeyEvent keyEvent) {
            boolean bl = keyEvent.getKeyChar() == '\n';
            boolean bl2 = keyEvent.getID() == 400;
            if (bl2 && bl && this.a.u) {
                return false;
            }
            if (this.a.v != null) {
                try {
                    return !this.a.v.handle(keyEvent);
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The KeyEventsHandler.handle() method has thrown exception: ", exception);
                }
            }
            return true;
        }

        /* synthetic */ h(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class i
    extends MouseAdapter {
        private /* synthetic */ LightWeightWidget a;

        private i(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mousePressed(MouseEvent e2) {
            if (this.a.a(e2)) {
                void var1_1;
                this.a(e2);
                this.a.forwardMouseEvent((MouseEvent)var1_1);
            }
            LightWeightWidget.c(this.a);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mouseReleased(MouseEvent e2) {
            if (this.a.a(e2)) {
                void var1_1;
                this.a(e2);
                this.a.forwardMouseEvent((MouseEvent)var1_1);
            }
            if (this.a.m.isDragStarted()) {
                this.a.e();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mouseEntered(MouseEvent e2) {
            if (this.a.a(e2)) {
                void var1_1;
                this.a(e2);
                this.a.forwardMouseEvent((MouseEvent)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mouseClicked(MouseEvent e2) {
            if (this.a.a(e2)) {
                void var1_1;
                this.a((MouseEvent)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mouseMoved(MouseEvent e2) {
            if (this.a.a(e2)) {
                void var1_1;
                this.a((MouseEvent)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mouseDragged(MouseEvent e2) {
            if (this.a.a(e2)) {
                void var1_1;
                this.a((MouseEvent)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mouseExited(MouseEvent e2) {
            if (this.a.a(e2)) {
                void var1_1;
                this.a(e2);
                this.a.forwardMouseEvent((MouseEvent)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void mouseWheelMoved(MouseWheelEvent e2) {
            void var1_1;
            if (this.a.a(e2)) {
                this.a(e2);
                this.a.forwardMouseWheelEvent(e2);
            }
            var1_1.consume();
        }

        private void a(MouseEvent mouseEvent) {
            Container container = this.a.getParent();
            if (container != null) {
                container.dispatchEvent(mouseEvent);
            }
        }

        /* synthetic */ i(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    final class f
    extends ComponentAdapter {
        private /* synthetic */ LightWeightWidget a;

        private f(LightWeightWidget lightWeightWidget) {
            this.a = lightWeightWidget;
        }

        @Override
        public final void componentMoved(ComponentEvent e2) {
            this.a.sendBounds(this.a.getSize());
            this.a.b();
            this.a.repaint();
        }

        /* synthetic */ f(LightWeightWidget lightWeightWidget, byte by) {
            this(lightWeightWidget);
        }
    }

    static final class c
    implements MacShortcutSupport<KeyEvent> {
        private final Browser a;

        c(Browser browser) {
            this.a = browser;
        }

        @Override
        public final /* synthetic */ void handleKeyPress(Object object) {
            Object object2 = (KeyEvent)object;
            object = this;
            if ((object2 = MacShortcutsCommandFactory.create(object2)) != null) {
                ((c)object).a.executeCommand(-2L, (EditorCommand)((Object)object2), null);
            }
        }
    }
}

