/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public enum CursorType {
    TypePointer,
    TypeCross,
    TypeHand,
    TypeIBeam,
    TypeWait,
    TypeHelp,
    TypeEastResize,
    TypeNorthResize,
    TypeNorthEastResize,
    TypeNorthWestResize,
    TypeSouthResize,
    TypeSouthEastResize,
    TypeSouthWestResize,
    TypeWestResize,
    TypeNorthSouthResize,
    TypeEastWestResize,
    TypeNorthEastSouthWestResize,
    TypeNorthWestSouthEastResize,
    TypeColumnResize,
    TypeRowResize,
    TypeMiddlePanning,
    TypeEastPanning,
    TypeNorthPanning,
    TypeNorthEastPanning,
    TypeNorthWestPanning,
    TypeSouthPanning,
    TypeSouthEastPanning,
    TypeSouthWestPanning,
    TypeWestPanning,
    TypeMove,
    TypeVerticalText,
    TypeCell,
    TypeContextMenu,
    TypeAlias,
    TypeProgress,
    TypeNoDrop,
    TypeCopy,
    TypeNone,
    TypeNotAllowed,
    TypeZoomIn,
    TypeZoomOut,
    TypeGrab,
    TypeGrabbing,
    TypeCustom;

    private static final Properties a;
    private static final Logger b;

    /*
     * WARNING - void declaration
     */
    public static Cursor toJavaCursor(int cursorType, byte[] pixels, int width, int height, int hotspotX, int hotspotY) {
        CursorType[] cursorTypeArray = CursorType.values();
        if (cursorType < cursorTypeArray.length) {
            int n2;
            Object object = cursorTypeArray[n2];
            if (object == TypeCustom) {
                BufferedImage bufferedImage;
                BufferedImage bufferedImage2;
                int n3;
                int n4;
                void var1_4;
                int n5;
                int n6;
                if (width == 0 || height == 0) {
                    return null;
                }
                object = Toolkit.getDefaultToolkit().getBestCursorSize(width, height);
                int n7 = ((Dimension)object).width;
                int n8 = ((Dimension)object).height;
                if (n7 == 0 && n8 == 0) {
                    return Cursor.getDefaultCursor();
                }
                void v0 = n6;
                void v1 = n5;
                int n9 = n7;
                n7 = n8;
                n5 = n9;
                n6 = v1;
                int n10 = v0;
                BufferedImage bufferedImage3 = var1_4;
                int[] nArray = new int[((void)bufferedImage3).length / 4];
                int n11 = 0;
                for (int i2 = 0; i2 < ((void)bufferedImage3).length; i2 += 4) {
                    n4 = bufferedImage3[i2 + 3] & 0xFF;
                    n3 = bufferedImage3[i2 + 2] & 0xFF;
                    int n12 = bufferedImage3[i2 + 1] & 0xFF;
                    int n13 = bufferedImage3[i2] & 0xFF;
                    nArray[n11++] = n4 << 24 | n3 << 16 | n12 << 8 | n13;
                }
                if (Environment.isWindows()) {
                    n4 = n10 >= n5 ? n10 : n5;
                    n3 = n6 >= n7 ? n6 : n7;
                    bufferedImage2 = new BufferedImage(n4, n3, 2);
                    if (n10 < n5 || n6 < n7) {
                        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                        graphics2D.setColor(new Color(0, 0, 0, 0));
                        graphics2D.setComposite(AlphaComposite.getInstance(4));
                        graphics2D.fillRect(0, 0, n5, n7);
                    }
                } else {
                    bufferedImage2 = new BufferedImage(n10, n6, 2);
                }
                for (n4 = 0; n4 < n6; ++n4) {
                    for (n3 = 0; n3 < n10; ++n3) {
                        bufferedImage2.setRGB(n3, n4, nArray[n3 + n4 * n10]);
                    }
                }
                if (n10 != n5 || n6 != n7) {
                    bufferedImage = new BufferedImage(n5, n7, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.drawImage(bufferedImage2, 0, 0, n5, n7, null);
                } else {
                    bufferedImage = bufferedImage2;
                }
                bufferedImage3 = bufferedImage;
                return Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage3, new Point(hotspotX, hotspotY), "customCursor");
            }
            return CursorType.a(object.name());
        }
        return Cursor.getDefaultCursor();
    }

    private static Cursor a(String string) {
        try {
            Object object = string + ".file";
            if (Environment.isMac()) {
                object = (String)object + ".mac";
            }
            if ((object = a.getProperty((String)object)) != null) {
                object = CursorType.class.getResource((String)object);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                object = toolkit.getImage((URL)object);
                Point point = new Point(0, 0);
                Object object2 = a.getProperty(string + ".hotspot");
                if (object2 != null && ((StringTokenizer)(object2 = new StringTokenizer((String)object2, ","))).countTokens() == 2) {
                    try {
                        point.x = Integer.parseInt(((StringTokenizer)object2).nextToken());
                        point.y = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        b.warning("Failed to parse hotspot property for cursor: " + string);
                    }
                }
                return toolkit.createCustomCursor((Image)object, point, string);
            }
            object = a.getProperty(string + ".swing");
            if (object != null) {
                int n2 = Cursor.class.getDeclaredField((String)object).getInt(null);
                return new Cursor(n2);
            }
        }
        catch (Exception exception) {
            b.warning("Unable to load cursor from resources: " + string);
        }
        return Cursor.getDefaultCursor();
    }

    static {
        a = new Properties();
        b = LoggerProvider.getBrowserLogger();
        URL uRL = CursorType.class.getResource("/com/teamdev/jxbrowser/chromium/internal/cursors.properties");
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                a.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                b.warning("Unable to load cursors properties from:" + uRL);
            }
        }
    }
}

