/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc.message;

import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageFactory;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import java.nio.ByteBuffer;

public class MessageSerializer {
    public static final int MSG_DATA_OFFSET = 13;
    public static final int MSG_TYPE_OFFSET = 0;
    public static final int MSG_UID_OFFSET = 4;
    public static final int MSG_DATA_SIZE_OFFSET = 8;
    public static final int MSG_PROTECTED_FLAG_OFFSET = 12;

    /*
     * WARNING - void declaration
     */
    public int getMessageSize(byte[] bytes) {
        void var1_1;
        if (bytes.length < 13) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int n2 = byteBuffer.getInt(8);
        if (((void)var1_1).length < (n2 += 13)) {
            return -1;
        }
        return n2;
    }

    public Message deserialize(byte[] bytes, int messageSize) {
        int n2;
        ByteBuffer byteBuffer;
        if (bytes.length < messageSize) {
            throw new IllegalStateException("Bytes length must be > messageSize.");
        }
        byteBuffer = ByteBuffer.wrap((byte[])byteBuffer, 0, n2);
        n2 = byteBuffer.getInt(0);
        int n3 = byteBuffer.getInt(4);
        MessageType messageType = MessageType.from(n2);
        Message message = MessageFactory.create(messageType, n3);
        try {
            message.deserialize(byteBuffer.array());
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to deserialize message: " + (Object)((Object)messageType), exception);
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serialize(Message message) {
        void var1_1;
        byte[] byArray = new byte[message.getSize()];
        var1_1.serialize(byArray);
        return byArray;
    }
}

