/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc.message;

import com.teamdev.jxbrowser.chromium.internal.ipc.message.CommonMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageField;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SensitiveInfo;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class DataMessage
extends CommonMessage {
    @Override
    protected int getDataSize() {
        return super.getDataSize() + this.getDataSizeInternal();
    }

    @Override
    public void serialize(byte[] data) {
        ByteBuffer byteBuffer;
        super.serialize(data);
        int n2 = this.getHeaderSize();
        byteBuffer = ByteBuffer.wrap(data, n2, ((void)byteBuffer).length - n2);
        this.serialize(byteBuffer);
    }

    @Override
    public void deserialize(byte[] data) {
        ByteBuffer byteBuffer;
        super.deserialize(data);
        int n2 = this.getHeaderSize();
        byteBuffer = ByteBuffer.wrap(data, n2, ((void)byteBuffer).length - n2);
        this.deserialize(byteBuffer);
    }

    private int getDataSizeInternal() {
        int n2 = 0;
        Field[] fieldArray = this.getClass().getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n3 = fieldArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = fieldArray2[i2];
            Class<?> clazz = ((Field)object).getAnnotation(MessageField.class);
            if (clazz == null) continue;
            clazz = ((Field)object).getType();
            if (clazz.equals(Long.TYPE)) {
                n2 += 8;
                continue;
            }
            if (clazz.equals(Integer.TYPE)) {
                n2 += 4;
                continue;
            }
            if (clazz.equals(Boolean.TYPE) || clazz.equals(Byte.TYPE)) {
                ++n2;
                continue;
            }
            if (clazz.equals(Character.TYPE)) {
                n2 += 2;
                continue;
            }
            if (clazz.equals(Double.TYPE)) {
                n2 += 8;
                continue;
            }
            if (clazz.equals(String.class)) {
                n2 += 4;
                try {
                    ((Field)object).setAccessible(true);
                    object = (String)((Field)object).get(this);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                if (object == null) continue;
                n2 += ((String)object).getBytes(Charset.forName("UTF-8")).length;
                continue;
            }
            if (clazz.equals(Rectangle.class)) {
                n2 += 16;
                continue;
            }
            if (!clazz.equals(byte[].class)) continue;
            n2 += 4;
            try {
                ((Field)object).setAccessible(true);
                object = (byte[])((Field)object).get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            if (object == null) continue;
            n2 += ((Object)object).length;
        }
        return n2;
    }

    private void serialize(ByteBuffer buffer) {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = fieldArray2[i2];
            Object object = field.getAnnotation(MessageField.class);
            if (object == null) continue;
            object = field.getType();
            try {
                field.setAccessible(true);
                if (object.equals(Long.TYPE)) {
                    this.put(buffer, (Long)field.get(this));
                    continue;
                }
                if (object.equals(Integer.TYPE)) {
                    this.put(buffer, (Integer)field.get(this));
                    continue;
                }
                if (object.equals(Boolean.TYPE)) {
                    this.put(buffer, (Boolean)field.get(this));
                    continue;
                }
                if (object.equals(Byte.TYPE)) {
                    this.put(buffer, (Byte)field.get(this));
                    continue;
                }
                if (object.equals(Character.TYPE)) {
                    this.put(buffer, ((Character)field.get(this)).charValue());
                    continue;
                }
                if (object.equals(Double.TYPE)) {
                    this.put(buffer, (Double)field.get(this));
                    continue;
                }
                if (object.equals(String.class)) {
                    this.put(buffer, (String)field.get(this));
                    continue;
                }
                if (object.equals(Rectangle.class)) {
                    this.put(buffer, (Rectangle)field.get(this));
                    continue;
                }
                if (!object.equals(byte[].class)) continue;
                this.put(buffer, (byte[])field.get(this));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }

    private void deserialize(ByteBuffer buffer) {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Field field = fieldArray2[i2];
            Object object = field.getAnnotation(MessageField.class);
            if (object == null) continue;
            object = field.getType();
            try {
                field.setAccessible(true);
                if (object.equals(Long.TYPE)) {
                    field.set(this, this.get(buffer, (Long)field.get(this)));
                    continue;
                }
                if (object.equals(Integer.TYPE)) {
                    field.set(this, this.get(buffer, (Integer)field.get(this)));
                    continue;
                }
                if (object.equals(Boolean.TYPE)) {
                    field.set(this, this.get(buffer, (Boolean)field.get(this)));
                    continue;
                }
                if (object.equals(Byte.TYPE)) {
                    field.set(this, this.get(buffer, (Byte)field.get(this)));
                    continue;
                }
                if (object.equals(Character.TYPE)) {
                    field.set(this, Character.valueOf(this.get(buffer, ((Character)field.get(this)).charValue())));
                    continue;
                }
                if (object.equals(Double.TYPE)) {
                    field.set(this, this.get(buffer, (Double)field.get(this)));
                    continue;
                }
                if (object.equals(String.class)) {
                    field.set(this, this.get(buffer, (String)field.get(this)));
                    continue;
                }
                if (object.equals(Rectangle.class)) {
                    field.set(this, this.get(buffer, (Rectangle)field.get(this)));
                    continue;
                }
                if (!object.equals(byte[].class)) continue;
                field.set(this, this.get(buffer, (byte[])field.get(this)));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }

    public static char[] createMaskFor(String sensitiveInfo) {
        String string;
        if (sensitiveInfo == null) {
            throw new IllegalArgumentException("String to mask should not be null.");
        }
        return DataMessage.createMaskingStars(string.length());
    }

    private static char[] createMaskingStars(int length) {
        char[] cArray = new char[length];
        for (int i2 = 0; i2 < length; ++i2) {
            cArray[i2] = 42;
        }
        return cArray;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(", ");
        Field[] fieldArray = this.getClass().getDeclaredFields();
        try {
            for (Field field : fieldArray) {
                field.setAccessible(true);
                Object object = field.getAnnotation(MessageField.class);
                if (object == null) continue;
                stringBuilder.append(field.getName());
                stringBuilder.append("=");
                object = field.get(this);
                if (field.getType().equals(byte[].class)) {
                    byte[] byArray = (byte[])object;
                    stringBuilder.append(byArray == null ? "null" : "[0..." + byArray.length + "]");
                } else if (field.getType().equals(String.class) && object != null) {
                    stringBuilder.append('\'');
                    if (field.getAnnotation(SensitiveInfo.class) != null) {
                        String string = (String)object;
                        stringBuilder.append(DataMessage.createMaskFor(string));
                    } else {
                        stringBuilder.append(object);
                    }
                    stringBuilder.append('\'');
                } else {
                    stringBuilder.append(object);
                }
                stringBuilder.append(", ");
            }
            int n2 = stringBuilder.lastIndexOf(", ");
            stringBuilder.delete(n2, n2 + 2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return stringBuilder.toString();
    }
}

