/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal.ipc;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumArchive;
import com.teamdev.jxbrowser.chromium.internal.ChromiumArchiveProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFile;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.ExternalChromiumProcess;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExternalChromiumProcessLinux
extends ExternalChromiumProcess {
    public static final String LINUX_VALIDATE_DEPS_PROPERTY = "jxbrowser.linux.check.deps";
    private static final Logger a = LoggerProvider.getChromiumProcessLogger();

    /*
     * WARNING - void declaration
     */
    protected ExternalChromiumProcessLinux(String chromiumDir, String processName) {
        super((String)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
    }

    private static void a(String string, ProcessBuilder object) {
        if ((object = ((ProcessBuilder)object).environment()).containsKey("LD_LIBRARY_PATH")) {
            string = string + ':' + (String)object.get("LD_LIBRARY_PATH");
        }
        object.put("LD_LIBRARY_PATH", string);
    }

    private static void a(String string, String string2, String string3) {
        String[] stringArray;
        string3 = string3 + File.separator;
        Object object = Environment.is64Bit() ? "/lib/x86_64-linux-gnu/" : "/lib/i386-linux-gnu/";
        object = new File((String)object + string);
        a.info("The '" + ((File)object).getAbsolutePath() + "' library exists: " + (((File)object).exists() ? "TRUE" : "FALSE"));
        if (((File)object).exists()) {
            return;
        }
        object = new File(string3 + string);
        a.info("The '" + ((File)object).getAbsolutePath() + "' library exists: " + (((File)object).exists() ? "TRUE" : "FALSE"));
        if (((File)object).exists()) {
            return;
        }
        object = null;
        boolean bl = Environment.is64Bit();
        if (bl) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "/lib/x86_64-linux-gnu/";
            stringArray2[1] = "/lib64/";
            stringArray = stringArray2;
            stringArray2[2] = "/usr/lib64/";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "/lib/i386-linux-gnu/";
            stringArray3[1] = "/lib/";
            stringArray = stringArray3;
            stringArray3[2] = "/usr/lib/";
        }
        String[] stringArray4 = stringArray;
        stringArray4 = stringArray;
        for (int i2 = 0; i2 < 3; ++i2) {
            object = stringArray4[i2];
            a.info("Looking for " + string2 + "x.x.x in '" + (String)object + "'...");
            object = FileUtil.findByTemplate((String)object, string2);
            if (object == null) continue;
            a.info("Found the '" + ((File)object).getAbsolutePath() + "' library");
            string = "/bin/ln -s " + ((File)object).getAbsolutePath() + ' ' + string3 + string;
            a.info("Creating symlink: " + string);
            try {
                int n2 = Runtime.getRuntime().exec(string).waitFor();
                a.info("The '" + string + "' symlink has been created. Exit code: " + n2);
            }
            catch (IOException iOException) {
                a.log(Level.SEVERE, "Failed to execute the '" + string + "' command.", iOException);
            }
            catch (InterruptedException interruptedException) {
                a.log(Level.SEVERE, "Failed to execute the '" + string + "' command.", interruptedException);
            }
            break;
        }
        if (object == null) {
            a.info("Failed to find " + string2 + "x.x.x");
        }
    }

    private static boolean a() {
        Object object = new ArrayList<String>();
        object.add("which");
        object.add("ldd");
        object = new ProcessBuilder((List<String>)object);
        InputStream inputStream = null;
        try {
            object = ((ProcessBuilder)object).start();
            int n2 = ((Process)object).waitFor();
            if (n2 == 0) {
                inputStream = ((Process)object).getInputStream();
                object = new BufferedReader(new InputStreamReader(inputStream));
                boolean bl = (object = ((BufferedReader)object).readLine()) != null;
                return bl;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    a.log(Level.WARNING, "Failed to close input stream", iOException);
                }
            }
        }
        return false;
    }

    private static String a(Map<String, List<String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("There are next missing dependencies: ");
        for (String string : map.keySet()) {
            stringBuilder.append("\n\t").append(string).append(" => ");
            string = ExternalChromiumProcessLinux.a(",", map.get(string));
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String a(String string, List<String> object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            stringBuilder.append(string2);
            if (!object.hasNext()) continue;
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString();
    }

    private static List<String> a(String object, String list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ldd");
        arrayList.add((String)object + "/" + (String)((Object)list));
        list = new ProcessBuilder(arrayList);
        ExternalChromiumProcessLinux.a((String)object, (ProcessBuilder)((Object)list));
        ((ProcessBuilder)((Object)list)).environment().put("LC_ALL", "C");
        object = null;
        try {
            list = ((ProcessBuilder)((Object)list)).start();
            int n2 = ((Process)((Object)list)).waitFor();
            if (n2 == 0) {
                String string;
                object = ((Process)((Object)list)).getInputStream();
                list = new BufferedReader(new InputStreamReader((InputStream)object));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while ((string = ((BufferedReader)((Object)list)).readLine()) != null) {
                    arrayList2.add(string);
                }
                list = ExternalChromiumProcessLinux.a(arrayList2);
                return list;
            }
            object = ((Process)((Object)list)).getErrorStream();
            a.info(((Scanner)((Object)(list = new Scanner((InputStream)object).useDelimiter("\\A")))).hasNext() ? ((Scanner)((Object)list)).next().trim() : "");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    a.log(Level.WARNING, "Failed to close input stream", iOException);
                }
            }
        }
        return Collections.emptyList();
    }

    private static List<String> a(List<String> object) {
        LinkedList<String> linkedList = new LinkedList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n2 = string.indexOf("not found");
            if (n2 == -1) continue;
            string = string.split("=>")[0];
            string = string.trim();
            linkedList.add(string);
        }
        return linkedList;
    }

    @Override
    protected void preProcessRun(ProcessBuilder processBuilder) {
        String string;
        super.preProcessRun(processBuilder);
        Object object = this.getWorkingDir();
        ExternalChromiumProcessLinux.a((String)object, (ProcessBuilder)((Object)string));
        string = object;
        ExternalChromiumProcessLinux.a("libudev.so.0", "libudev.so.", string);
        ExternalChromiumProcessLinux.a("libgcrypt.so.11", "libgcrypt.so.", string);
        ExternalChromiumProcessLinux.a("libcrypto.so.1.0.0", "libcrypto.so.", string);
        boolean bl = Boolean.parseBoolean(System.getProperty(LINUX_VALIDATE_DEPS_PROPERTY, "true"));
        if (bl) {
            String string2 = object;
            if (!ExternalChromiumProcessLinux.a()) {
                a.info("The 'ldd' command isn't supported. Skipping dependencies verification.");
                return;
            }
            object = ChromiumArchiveProvider.getChromiumArchives().iterator().next();
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
            for (ChromiumFile chromiumFile : ((ChromiumArchive)object).getChromiumFiles().getFiles()) {
                List<String> list;
                String object2 = chromiumFile.getFileName();
                if (object2.equals("libawt-helper.so")) continue;
                boolean list2 = new File(string2 + "/" + object2).canExecute();
                if (!object2.endsWith(".so") && !list2 || (list = ExternalChromiumProcessLinux.a(string2, object2)).isEmpty()) continue;
                treeMap.put(object2, list);
            }
            if (!treeMap.isEmpty()) {
                object = ExternalChromiumProcessLinux.a(treeMap);
                a.severe((String)object);
                throw new IllegalStateException("Missing dependendecies have been detected. Check the log for details.");
            }
        }
    }
}

