/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import java.util.Arrays;

public final class Version
implements Comparable<Version> {
    private final int[] a;

    /*
     * WARNING - void declaration
     */
    public Version(int ... numbers) {
        void var1_1;
        if (numbers == null) {
            throw new IllegalArgumentException("The numbers parameter cannot be null");
        }
        this.a = var1_1;
    }

    public static Version parse(String version) {
        String[] stringArray;
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("The version parameter cannot be null or empty");
        }
        if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        stringArray = stringArray.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringArray[i2]);
        }
        return new Version(nArray);
    }

    public final int[] getNumbers() {
        return this.a;
    }

    public final int getMajor() {
        if (this.a.length > 0) {
            return this.a[0];
        }
        return 0;
    }

    public final int getMinor() {
        if (this.a.length >= 2) {
            return this.a[1];
        }
        return 0;
    }

    @Override
    public final int compareTo(Version o2) {
        if (o2 == null) {
            return 1;
        }
        int n2 = Math.max(this.a.length, o2.a.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = i2 < this.a.length ? this.a[i2] : 0;
            int n5 = n3 = i2 < o2.a.length ? o2.a[i2] : 0;
            if (n4 < n3) {
                return -1;
            }
            if (n4 <= n3) continue;
            return 1;
        }
        return 0;
    }

    public final boolean equals(Object o2) {
        Version version;
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        version = version;
        return Arrays.equals(this.a, version.a);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.a);
    }
}

