/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.BytesData;
import com.teamdev.jxbrowser.chromium.FormData;
import com.teamdev.jxbrowser.chromium.MultipartFormData;
import com.teamdev.jxbrowser.chromium.RawData;
import com.teamdev.jxbrowser.chromium.TextData;
import com.teamdev.jxbrowser.chromium.UploadData;
import com.teamdev.jxbrowser.chromium.UploadDataType;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UploadDataUtils {
    private static final int[] a = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66};

    public static UploadDataType getDataTypeFromHeader(String contentTypeHeader) {
        String string;
        if (contentTypeHeader == null) {
            return null;
        }
        if (contentTypeHeader.contains("application/x-www-form-urlencoded")) {
            return UploadDataType.FORM_URL_ENCODED;
        }
        if (contentTypeHeader.contains("multipart/form-data")) {
            return UploadDataType.MULTIPART_FORM_DATA;
        }
        if (string.contains("text/plain")) {
            return UploadDataType.PLAIN_TEXT;
        }
        return UploadDataType.BYTES;
    }

    public static String getBoundaryFromContentHeader(String contentTypeHeader) {
        Object object = UploadDataUtils.getDataTypeFromHeader(contentTypeHeader);
        if (object == UploadDataType.MULTIPART_FORM_DATA) {
            String string;
            object = "boundary=";
            int n2 = contentTypeHeader.indexOf((String)object) + ((String)object).length();
            return string.substring(n2);
        }
        return null;
    }

    public static String generateUniqueBoundary() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("----WebKitFormBoundary");
        for (int i2 = 0; i2 < 16; ++i2) {
            int n2 = secureRandom.nextInt(64);
            stringBuilder.append((char)a[n2]);
        }
        return stringBuilder.toString();
    }

    public static Map<String, List<String>> buildFilesMap(MultipartFormData data) {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        Object object = data.getFileKeys();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            treeMap.put(string, new ArrayList<String>(data.getFiles(string)));
        }
        return treeMap;
    }

    public static UploadData copy(UploadData data) {
        RawData rawData = null;
        if (data instanceof MultipartFormData) {
            rawData = new MultipartFormData((MultipartFormData)data);
        } else if (data instanceof FormData) {
            rawData = new FormData((FormData)data);
        } else if (data instanceof TextData) {
            rawData = new TextData((TextData)data);
        } else if (data instanceof BytesData) {
            UploadData uploadData;
            rawData = new BytesData((BytesData)uploadData);
        }
        return rawData;
    }

    public static String createContentTypeHeader(UploadDataType dataType) {
        Object object;
        if (dataType == UploadDataType.FORM_URL_ENCODED) {
            return "application/x-www-form-urlencoded";
        }
        if (object == UploadDataType.MULTIPART_FORM_DATA) {
            object = UploadDataUtils.generateUniqueBoundary();
            return "multipart/form-data; boundary=" + (String)object;
        }
        return "text/plain";
    }
}

