/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.ColorModel;
import com.teamdev.jxbrowser.chromium.DuplexMode;
import com.teamdev.jxbrowser.chromium.PageMargins;
import com.teamdev.jxbrowser.chromium.PageRange;
import com.teamdev.jxbrowser.chromium.PaperSize;
import com.teamdev.jxbrowser.chromium.PrintJob;
import com.teamdev.jxbrowser.chromium.PrintSettings;
import com.teamdev.jxbrowser.chromium.internal.ExtensionFilter;
import com.teamdev.jxbrowser.chromium.internal.w;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrintDialogModel {
    public static final String SAVE_AS_PDF = "Save as PDF";
    public static final String LAYOUT_PORTRAIT = "Portrait";
    public static final String LAYOUT_LANDSCAPE = "Landscape";
    public static final String COLOR_MODE_COLOR = "Color";
    public static final String COLOR_MODE_BLACK_AND_WHITE = "Black and White";
    public static final String MARGIN_TYPE_DEFAULT = "Default";
    public static final String MARGIN_TYPE_CUSTOM = "Custom";
    public static final List<ExtensionFilter> DEFAULT_EXTENSION_FILTERS = Collections.unmodifiableList(new w());
    private final PrintSettings a;
    private final List<ExtensionFilter> b;
    private final PrintJob.DocumentType c;
    private CloseStatus d;

    /*
     * WARNING - void declaration
     */
    public PrintDialogModel(PrintSettings settings, PrintJob.DocumentType documentType) {
        void var2_2;
        this.a = settings;
        this.c = var2_2;
        this.b = DEFAULT_EXTENSION_FILTERS;
        if (settings.getDuplexMode() == DuplexMode.UNKNOWN) {
            void var1_1;
            var1_1.setDuplexMode(DuplexMode.SIMPLEX);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PrintDialogModel(PrintSettings settings, List<ExtensionFilter> extensionFilters) {
        void var2_2;
        this.a = settings;
        this.c = PrintJob.DocumentType.UNKNOWN;
        this.b = Collections.unmodifiableList(new ArrayList(var2_2));
        if (settings.getDuplexMode() == DuplexMode.UNKNOWN) {
            void var1_1;
            var1_1.setDuplexMode(DuplexMode.SIMPLEX);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printHeadersAndFooters(boolean print) {
        void var1_1;
        this.a.setDisplayHeaderFooter((boolean)var1_1);
    }

    public boolean isPrintHeadersAndFooters() {
        return this.a.isDisplayHeaderFooter();
    }

    /*
     * WARNING - void declaration
     */
    public void printBackgroundGraphics(boolean print) {
        void var1_1;
        this.a.setPrintBackgrounds((boolean)var1_1);
    }

    public boolean isPrintBackgroundGraphics() {
        return this.a.isPrintBackgrounds();
    }

    /*
     * WARNING - void declaration
     */
    public void printSelectionOnly(boolean print) {
        void var1_1;
        this.a.setPrintSelectionOnly((boolean)var1_1);
    }

    public void printTwoSided(boolean print) {
        if (print) {
            this.a.setDuplexMode(this.a.isLandscape() ? DuplexMode.SHORT_EDGE : DuplexMode.LONG_EDGE);
            return;
        }
        this.a.setDuplexMode(DuplexMode.SIMPLEX);
    }

    public boolean isPrintTwoSided() {
        DuplexMode duplexMode = this.a.getDuplexMode();
        return duplexMode == DuplexMode.SHORT_EDGE || duplexMode == DuplexMode.LONG_EDGE;
    }

    /*
     * WARNING - void declaration
     */
    public void setPDFFilePath(String path) {
        void var1_1;
        this.a.setPDFFilePath((String)var1_1);
    }

    public String getPrinterName() {
        return this.a.getPrinterName();
    }

    /*
     * WARNING - void declaration
     */
    public void setPrinterName(String printerName) {
        void var1_1;
        if (SAVE_AS_PDF.equals(printerName)) {
            this.a.setPrintToPDF(true);
            return;
        }
        this.a.setPrintToPDF(false);
        this.a.setPrinterName((String)var1_1);
    }

    public boolean isPrintToPDF() {
        return this.a.isPrintToPDF();
    }

    public boolean isLandscape() {
        return this.a.isLandscape();
    }

    /*
     * WARNING - void declaration
     */
    public void setLandscape(boolean landscape) {
        void var1_1;
        this.a.setLandscape((boolean)var1_1);
        DuplexMode duplexMode = this.a.getDuplexMode();
        this.printTwoSided(duplexMode == DuplexMode.SHORT_EDGE || duplexMode == DuplexMode.LONG_EDGE);
    }

    public PaperSize getPaperSize() {
        return this.a.getPaperSize();
    }

    /*
     * WARNING - void declaration
     */
    public void setPaperSize(PaperSize paperSize) {
        void var1_1;
        this.a.setPaperSize((PaperSize)var1_1);
    }

    public int getCopies() {
        return this.a.getCopies();
    }

    /*
     * WARNING - void declaration
     */
    public void setCopies(int copies) {
        void var1_1;
        this.a.setCopies((int)var1_1);
    }

    public boolean isColorMode() {
        return this.a.getColorModel() == ColorModel.COLOR;
    }

    /*
     * WARNING - void declaration
     */
    public void setColorMode(boolean colorMode) {
        void var1_1;
        this.a.setColorModel(var1_1 != false ? ColorModel.COLOR : ColorModel.GRAY);
    }

    public boolean isCustomMarginsEnabled() {
        return this.a.getPageMargins() != null;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomMargins(int top, int right, int bottom, int left) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.a.setPageMargins(new PageMargins(0, 0, (int)var1_1, left, (int)var2_2, (int)var3_3));
    }

    public PageMargins getCustomMargins() {
        return this.a.getPageMargins();
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomMargins(PageMargins margins) {
        void var1_1;
        this.a.setPageMargins((PageMargins)var1_1);
    }

    public void printAllPages() {
        this.a.setPageRanges(new ArrayList<PageRange>());
    }

    public boolean isPrintAllPages() {
        return this.a.getPageRanges() == null || this.a.getPageRanges().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public void printPageRanges(int from, int to) {
        if (to >= from) {
            void var2_2;
            void var1_1;
            ArrayList<PageRange> arrayList = new ArrayList<PageRange>();
            arrayList.add(new PageRange((int)(var1_1 - true), (int)(var2_2 - true)));
            this.a.setPageRanges(arrayList);
        }
    }

    public PageRange getPrintPageRange() {
        List<PageRange> list = this.a.getPageRanges();
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CloseStatus getCloseStatus() {
        return this.d;
    }

    /*
     * WARNING - void declaration
     */
    public void setCloseStatus(CloseStatus status) {
        void var1_1;
        this.d = var1_1;
    }

    public PrintJob.DocumentType getDocumentType() {
        return this.c;
    }

    public List<ExtensionFilter> getSaveDialogExtensionFilters() {
        return this.b;
    }

    public static enum CloseStatus {
        PRINT,
        CANCEL;

    }
}

