/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.PluginInfo;
import com.teamdev.jxbrowser.chromium.PluginType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PluginInfoParser {
    public static final String PLUGIN_DELIMITER = "|";
    public static final String MIME_TYPE_DELIMITER = "jxb-part";
    public static final String FIELD_DELIMITER = "jxb-field";
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private static final Pattern b = Pattern.compile("jxb-field");
    private static final Pattern c = Pattern.compile("jxb-part");

    public static List<PluginInfo> parsePluginsInfo(String pluginsInfo) {
        StringTokenizer stringTokenizer;
        ArrayList<PluginInfo> arrayList = new ArrayList<PluginInfo>();
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), PLUGIN_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            Object object = stringTokenizer.nextToken();
            if ((object = PluginInfoParser.parsePluginInfo((String)object)) == null) continue;
            arrayList.add((PluginInfo)object);
        }
        return arrayList;
    }

    public static PluginInfo parsePluginInfo(String pluginRepresentation) {
        try {
            String[] stringArray = b.split(pluginRepresentation, Integer.MAX_VALUE);
            if (stringArray.length != 6) {
                a.log(Level.SEVERE, "Failed to parse the '" + pluginRepresentation + "' plugin representation.");
                return null;
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            PluginType pluginType = PluginType.fromString(stringArray[4]);
            ArrayList<String> arrayList = new ArrayList<String>();
            stringArray = c.split(stringArray[5]);
            Collections.addAll(arrayList, stringArray);
            return new PluginInfo(string, string2, string3, string4, arrayList, pluginType);
        }
        catch (Exception exception) {
            String string;
            a.log(Level.SEVERE, "Failed to parse the '" + string + "' plugin representation", exception);
            return null;
        }
    }
}

