/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.u;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtil {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public static void createDirs(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            File file;
            throw new RuntimeException("Failed to create directory: " + file.getPath());
        }
    }

    public static void createDirs(String dirPath) {
        Object object;
        if (!((File)(object = new File((String)object))).exists() && !((File)object).mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + ((File)object).getPath());
        }
    }

    public static boolean createFile(File file) {
        try {
            return file.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean copyFile(File srcFile, File dstFile) {
        if (dstFile.exists() || !dstFile.createNewFile()) {
            return false;
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            void var1_2;
            File file;
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream((File)var1_2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
        return true;
    }

    public static void deleteFiles(File dir) {
        File[] fileArray;
        if (dir.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.isFile() || file.delete()) continue;
                throw new RuntimeException("Failed to delete file " + file.getAbsolutePath());
            }
        }
    }

    public static void deleteDir(File dir) {
        File file;
        File[] fileArray;
        if (dir.isDirectory() && (fileArray = dir.listFiles()) != null) {
            for (File file2 : fileArray) {
                FileUtil.deleteDir(file2);
            }
        }
        FileUtil.deleteFile(file);
    }

    public static void deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            File file2;
            throw new RuntimeException("Failed to delete file " + file2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean allFilesExist(File dir, List<String> fileNames) {
        void var1_1;
        return FileUtil.filesExist(dir, (List<String>)var1_1).isEmpty();
    }

    public static List<File> filesExist(File dir, List<String> fileNames) {
        Iterator iterator;
        ArrayList<File> arrayList = new ArrayList<File>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (String)iterator.next();
            if (((File)(object = new File(dir, (String)object))).exists()) continue;
            arrayList.add((File)object);
        }
        return arrayList;
    }

    public static File createTempDir(String prefix) {
        try {
            File file = File.createTempFile(prefix, Long.toString(System.nanoTime()));
            if (!file.delete()) {
                throw new IllegalStateException("Failed to delete temp file: " + file.getAbsolutePath());
            }
            if (!file.mkdir()) {
                throw new IllegalStateException("Failed to create temp dir: " + file.getAbsolutePath());
            }
            return file;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File findByTemplate(String dir, String fileNameTemplate) {
        void var1_1;
        File[] fileArray;
        if ((fileArray = new File((String)fileArray)).isDirectory() && (fileArray = fileArray.listFiles(new u((String)var1_1))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    public static String getFileName(File file) {
        String string = file.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String getFileExtension(File file, boolean includeDot) {
        String string = file.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            void var1_1;
            return string.substring(var1_1 != false ? n2 : n2 + 1);
        }
        return "";
    }

    public static void validateDirectory(String path) {
        Object object;
        if (path.isEmpty()) {
            throw new IOException("The path to the directory is empty.");
        }
        if (!((File)(object = new File((String)object))).exists() && !((File)object).mkdirs()) {
            throw new IOException("The directory " + ((File)object).getAbsolutePath() + " does not exist and cannot be created.");
        }
        if (!((File)object).isDirectory()) {
            throw new IOException("The path " + ((File)object).getAbsolutePath() + " does not refer to a directory.");
        }
        if (!FileUtil.canWriteToDirectory(((File)object).getAbsolutePath())) {
            throw new IOException("There is no write permission to the directory " + ((File)object).getAbsolutePath());
        }
    }

    public static boolean canWriteToDirectory(String dirPath) {
        Object object;
        Long l2 = System.currentTimeMillis();
        object = (String)object + File.separator + "jxbrowser-test-file-" + l2;
        object = new File((String)object);
        try {
            new FileOutputStream((File)object, true).close();
            ((File)object).delete();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static byte[] readFile(String path) {
        byte[] byArray = null;
        try {
            Object object = new File(new URI(path));
            object = new DataInputStream(new FileInputStream((File)object));
            byArray = new byte[((FilterInputStream)object).available()];
            ((DataInputStream)object).readFully(byArray);
        }
        catch (IOException iOException) {
            a.log(Level.SEVERE, "Failed to read the file: " + path, iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string;
            a.log(Level.SEVERE, "Failed to parse the path: " + string, uRISyntaxException);
        }
        return byArray;
    }

    public static void restorePermissionsForFile(File file) {
        if (!file.setExecutable(true, false)) {
            File file2;
            throw new RuntimeException("Failed to update permissions for file: " + file2.getAbsolutePath());
        }
    }
}

