/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.ChromiumArchive;
import com.teamdev.jxbrowser.chromium.internal.ChromiumExtractorException;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFile;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFiles;
import com.teamdev.jxbrowser.chromium.internal.ChromiumVerifier;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import com.teamdev.jxbrowser.chromium.internal.XZExtractor;
import com.teamdev.jxbrowser.chromium.internal.c;
import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChromiumExtractor {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final File b;
    private final List<ChromiumArchive> c;
    private final ChromiumVerifier d;

    /*
     * WARNING - void declaration
     */
    public ChromiumExtractor(String chromiumDir, List<ChromiumArchive> chromiumArchives, ChromiumVerifier verifier) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.b = new File((String)var1_1);
        this.c = var2_2;
        this.d = var3_3;
    }

    private static List<String> a(ChromiumFiles object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ChromiumFile chromiumFile : ((ChromiumFiles)object).getFiles()) {
            arrayList.add(chromiumFile.getFileName());
        }
        return arrayList;
    }

    public void extractChromiumBinariesIfNecessary() {
        String string = this.b.getAbsolutePath();
        a.info("Chromium binaries dir: " + string);
        for (ChromiumArchive object : this.c) {
            a.info("Analyzing Chromium binaries dir for " + object.getArchiveName() + " archive...");
            Object object2 = object.getChromiumFiles();
            if (!this.a((List<String>)(object2 = ChromiumExtractor.a((ChromiumFiles)object2)), object)) continue;
            return;
        }
        try {
            ChromiumArchive chromiumArchive = this.a();
            AccessController.doPrivileged(new c(this, chromiumArchive));
            return;
        }
        catch (Exception exception) {
            String string2 = "Failed to extract Chromium binaries into " + string;
            a.log(Level.SEVERE, string2, exception);
            throw new ChromiumExtractorException(string2, exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ChromiumArchive a() {
        void var1_2;
        RuntimeException object2 = new RuntimeException("Failed to locate Chromium binaries archive.");
        for (ChromiumArchive chromiumArchive : this.c) {
            try {
                XZExtractor.a(chromiumArchive.getArchiveName());
                return chromiumArchive;
            }
            catch (Exception exception) {
                Exception exception3 = exception;
                exception3 = exception;
            }
        }
        throw new ChromiumExtractorException(var1_2.getMessage(), (Throwable)var1_2);
    }

    private boolean a(List<String> object, ChromiumArchive object2) {
        if ((object = FileUtil.filesExist(this.b, object)).isEmpty()) {
            a.fine("Chromium binaries dir contains all required files");
            a.info("Verifying Chromium binaries...");
            if (this.d.verify(this.b, ((ChromiumArchive)object2).getChromiumFiles())) {
                a.info("Verifying Chromium binaries... [OK]");
                return true;
            }
        } else {
            a.fine("The directory doesn't have the following files:");
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (File)object.next();
                a.fine(((File)object2).getAbsolutePath());
            }
        }
        return false;
    }

    static /* synthetic */ void a(ChromiumExtractor chromiumExtractor, ChromiumArchive object) {
        String object22 = chromiumExtractor.b.getAbsolutePath();
        a.info("Extracting Chromium binaries from " + ((ChromiumArchive)((Object)object)).getArchiveName() + " to '" + object22 + "'...");
        long l2 = System.currentTimeMillis();
        XZExtractor.extract(chromiumExtractor.b, (ChromiumArchive)((Object)object));
        a.fine("Extracting xz archive time: " + (System.currentTimeMillis() - l2) + "ms");
        a.info(" Chromium binaries from " + ((ChromiumArchive)((Object)object)).getArchiveName() + " are extracted to '" + object22 + '\'');
        for (ChromiumFile chromiumFile : ((ChromiumArchive)((Object)object)).getChromiumFiles().getFiles()) {
            if (!chromiumFile.isExecutable()) continue;
            String string = chromiumFile.getFileName();
            File file = new File(chromiumExtractor.b, string);
            a.fine("Restoring file permissions for " + file.getAbsolutePath() + "...");
            FileUtil.restorePermissionsForFile(file);
        }
    }
}

