/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.internal.ChromiumArchive;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFilesLinux64;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFilesMac;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFilesWin32;
import com.teamdev.jxbrowser.chromium.internal.ChromiumFilesWin64;
import com.teamdev.jxbrowser.chromium.internal.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ChromiumArchiveProvider {
    public static List<ChromiumArchive> getChromiumArchives() {
        if (Environment.isWindows()) {
            ArrayList<ChromiumArchive> arrayList = new ArrayList<ChromiumArchive>();
            if (Environment.isWindows64()) {
                arrayList.add(new ChromiumArchive(new ChromiumFilesWin64(), "/chromium-win64.7z"));
            }
            arrayList.add(new ChromiumArchive(new ChromiumFilesWin32(), "/chromium-win32.7z"));
            return arrayList;
        }
        if (Environment.isMac()) {
            return Collections.singletonList(new ChromiumArchive(new ChromiumFilesMac(), "/chromium-mac.7z"));
        }
        if (Environment.isLinux() && Environment.is64Bit()) {
            return Collections.singletonList(new ChromiumArchive(new ChromiumFilesLinux64(), "/chromium-linux64.7z"));
        }
        throw new IllegalStateException("Unsupported operating system");
    }
}

