/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.dom.internal;

import com.teamdev.jxbrowser.chromium.XPathResult;
import com.teamdev.jxbrowser.chromium.XPathResultType;
import com.teamdev.jxbrowser.chromium.dom.By;
import com.teamdev.jxbrowser.chromium.dom.DOMElement;
import com.teamdev.jxbrowser.chromium.dom.DOMNode;
import com.teamdev.jxbrowser.chromium.dom.DOMNodePosition;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeType;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMContext;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMFactory;
import com.teamdev.jxbrowser.chromium.dom.internal.EventTarget;
import com.teamdev.jxbrowser.chromium.dom.internal.NodeInfo;
import com.teamdev.jxbrowser.chromium.dom.internal.NodePtr;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.AppendChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CompareDocumentPositionMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.EvaluateXPathMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetElementsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeDataMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeParentFrameMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeSiblingMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetTextContentMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.InsertChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.NodeEqualsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.QuerySelectorAllMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.RemoveChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ReplaceChildNodeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetNodeValueMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetTextContentMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SimulateClickMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Node
extends EventTarget
implements DOMNode {
    public static final int NODE_POSITION_DISCONNECTED = 1;
    public static final int NODE_POSITION_PRECEDING = 2;
    public static final int NODE_POSITION_FOLLOWING = 4;
    public static final int NODE_POSITION_CONTAINS = 8;
    public static final int NODE_POSITION_CONTAINED_BY = 16;
    public static final int NODE_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    private final DOMNodeType a;

    /*
     * WARNING - void declaration
     */
    public Node(long ptr, DOMFactory factory, DOMContext context, DOMNodeType nodeType) {
        super((long)var1_1, (DOMFactory)var3_2, context);
        void var3_2;
        void var1_1;
        this.a = nodeType;
    }

    @Override
    public synchronized String getNodeName() {
        GetNodeDataMessage getNodeDataMessage = new GetNodeDataMessage();
        new GetNodeDataMessage().flag = 0;
        getNodeDataMessage.nodePtr = this.getPtr();
        getNodeDataMessage = this.post(getNodeDataMessage);
        return getNodeDataMessage.result;
    }

    @Override
    public synchronized String getNodeValue() {
        GetNodeDataMessage getNodeDataMessage = new GetNodeDataMessage();
        new GetNodeDataMessage().flag = 1;
        getNodeDataMessage.nodePtr = this.getPtr();
        getNodeDataMessage = this.post(getNodeDataMessage);
        return getNodeDataMessage.result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setNodeValue(String value) {
        void var1_1;
        SetNodeValueMessage setNodeValueMessage = new SetNodeValueMessage();
        new SetNodeValueMessage().nodePtr = this.getPtr();
        setNodeValueMessage.nodeValue = var1_1;
        this.send(setNodeValueMessage);
    }

    @Override
    public synchronized DOMNodeType getNodeType() {
        return this.a;
    }

    @Override
    public synchronized DOMNode getParent() {
        GetNodeDataMessage getNodeDataMessage = new GetNodeDataMessage();
        new GetNodeDataMessage().flag = 2;
        getNodeDataMessage.nodePtr = this.getPtr();
        getNodeDataMessage = this.post(getNodeDataMessage);
        return this.getFactory().createNode(NodeInfo.getNodeInfo(getNodeDataMessage.result));
    }

    public boolean equals(Object obj) {
        NodeEqualsMessage nodeEqualsMessage;
        if (!(obj instanceof NodePtr)) {
            return false;
        }
        NodeEqualsMessage nodeEqualsMessage2 = new NodeEqualsMessage();
        new NodeEqualsMessage().firstNodePtr = this.getPtr();
        nodeEqualsMessage2.secondNodePtr = ((NodePtr)((Object)nodeEqualsMessage)).getPtr();
        nodeEqualsMessage = this.post(nodeEqualsMessage2);
        return nodeEqualsMessage.result;
    }

    @Override
    public synchronized List<DOMNode> getChildren() {
        GetNodeDataMessage getNodeDataMessage = new GetNodeDataMessage();
        new GetNodeDataMessage().flag = 3;
        getNodeDataMessage.nodePtr = this.getPtr();
        getNodeDataMessage = this.post(getNodeDataMessage);
        return this.getFactory().createNodes(NodeInfo.getNodeInfos(getNodeDataMessage.result));
    }

    @Override
    public DOMNode getNextSibling() {
        GetNodeSiblingMessage getNodeSiblingMessage = new GetNodeSiblingMessage();
        new GetNodeSiblingMessage().nodePtr = this.getPtr();
        getNodeSiblingMessage.next = true;
        getNodeSiblingMessage = this.post(getNodeSiblingMessage);
        return this.getFactory().createNode(NodeInfo.getNodeInfo(getNodeSiblingMessage.result));
    }

    @Override
    public DOMNode getPreviousSibling() {
        GetNodeSiblingMessage getNodeSiblingMessage = new GetNodeSiblingMessage();
        new GetNodeSiblingMessage().nodePtr = this.getPtr();
        getNodeSiblingMessage.next = false;
        getNodeSiblingMessage = this.post(getNodeSiblingMessage);
        return this.getFactory().createNode(NodeInfo.getNodeInfo(getNodeSiblingMessage.result));
    }

    @Override
    public synchronized void click() {
        SimulateClickMessage simulateClickMessage = new SimulateClickMessage();
        new SimulateClickMessage().nodePtr = this.getPtr();
        this.send(simulateClickMessage);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean insertChild(DOMNode node, DOMNode beforeNode) {
        void var2_2;
        InsertChildNodeMessage insertChildNodeMessage;
        if (node == null) {
            throw new IllegalArgumentException("The node parameter cannot be null.");
        }
        if (beforeNode == null) {
            throw new IllegalArgumentException("The beforeNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)((Object)insertChildNodeMessage)).getPtr();
        long l4 = ((NodePtr)var2_2).getPtr();
        insertChildNodeMessage = new InsertChildNodeMessage();
        new InsertChildNodeMessage().nodePtr = l2;
        insertChildNodeMessage.childNodePtr = l3;
        insertChildNodeMessage.refNodePtr = l4;
        insertChildNodeMessage = this.post(insertChildNodeMessage);
        return insertChildNodeMessage.result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean replaceChild(DOMNode newNode, DOMNode oldNode) {
        void var2_2;
        ReplaceChildNodeMessage replaceChildNodeMessage;
        if (newNode == null) {
            throw new IllegalArgumentException("The newNode parameter cannot be null.");
        }
        if (oldNode == null) {
            throw new IllegalArgumentException("The oldNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)((Object)replaceChildNodeMessage)).getPtr();
        long l4 = ((NodePtr)var2_2).getPtr();
        replaceChildNodeMessage = new ReplaceChildNodeMessage();
        new ReplaceChildNodeMessage().nodePtr = l2;
        replaceChildNodeMessage.childNodePtr = l3;
        replaceChildNodeMessage.refNodePtr = l4;
        replaceChildNodeMessage = this.post(replaceChildNodeMessage);
        return replaceChildNodeMessage.result;
    }

    @Override
    public synchronized boolean removeChild(DOMNode childNode) {
        RemoveChildNodeMessage removeChildNodeMessage;
        if (childNode == null) {
            throw new IllegalArgumentException("The childNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)((Object)removeChildNodeMessage)).getPtr();
        removeChildNodeMessage = new RemoveChildNodeMessage();
        new RemoveChildNodeMessage().nodePtr = l2;
        removeChildNodeMessage.childNodePtr = l3;
        removeChildNodeMessage = this.post(removeChildNodeMessage);
        return removeChildNodeMessage.result;
    }

    @Override
    public synchronized boolean appendChild(DOMNode childNode) {
        AppendChildNodeMessage appendChildNodeMessage;
        if (childNode == null) {
            throw new IllegalArgumentException("The childNode parameter cannot be null.");
        }
        long l2 = this.getPtr();
        long l3 = ((NodePtr)((Object)appendChildNodeMessage)).getPtr();
        appendChildNodeMessage = new AppendChildNodeMessage();
        new AppendChildNodeMessage().nodePtr = l2;
        appendChildNodeMessage.childNodePtr = l3;
        appendChildNodeMessage = this.post(appendChildNodeMessage);
        return appendChildNodeMessage.result;
    }

    @Override
    public synchronized String getTextContent() {
        GetTextContentMessage getTextContentMessage = new GetTextContentMessage();
        new GetTextContentMessage().nodePtr = this.getPtr();
        getTextContentMessage = this.post(getTextContentMessage);
        return getTextContentMessage.textContent;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setTextContent(String textContent) {
        void var1_1;
        if (textContent == null) {
            throw new IllegalArgumentException("The textContent parameter cannot be null.");
        }
        SetTextContentMessage setTextContentMessage = new SetTextContentMessage();
        new SetTextContentMessage().nodePtr = this.getPtr();
        setTextContentMessage.textContent = var1_1;
        this.post(setTextContentMessage);
    }

    private List<DOMElement> a(String object) {
        if (object == null || ((String)object).isEmpty()) {
            throw new IllegalArgumentException("The selectors parameter cannot be null or empty");
        }
        QuerySelectorAllMessage querySelectorAllMessage = new QuerySelectorAllMessage();
        new QuerySelectorAllMessage().nodePtr = this.getPtr();
        querySelectorAllMessage.selectors = object;
        object = this.post(querySelectorAllMessage);
        return this.getFactory().createNodes(NodeInfo.getNodeInfos(((QuerySelectorAllMessage)object).resultNodes));
    }

    @Override
    public synchronized List<DOMElement> findElements(By method) {
        Object object;
        if (((By)method).getType() == By.Type.ID) {
            return this.a("[id='" + ((By)method).getValue() + "']");
        }
        if (((By)method).getType() == By.Type.TAG) {
            Object object2 = ((By)method).getValue();
            method = this;
            GetElementsMessage getElementsMessage = new GetElementsMessage();
            new GetElementsMessage().flag = 0;
            getElementsMessage.nodePtr = ((NodePtr)method).getPtr();
            getElementsMessage.tagName = object2;
            object2 = ((NodePtr)method).post(getElementsMessage);
            return ((NodePtr)method).getFactory().createNodes(NodeInfo.getNodeInfos(((GetElementsMessage)object2).elementPointers));
        }
        if (((By)method).getType() == By.Type.NAME) {
            Object object3 = ((By)method).getValue();
            method = this;
            GetElementsMessage getElementsMessage = new GetElementsMessage();
            new GetElementsMessage().flag = 1;
            getElementsMessage.nodePtr = ((NodePtr)method).getPtr();
            getElementsMessage.tagName = object3;
            object3 = ((NodePtr)method).post(getElementsMessage);
            return ((NodePtr)method).getFactory().createNodes(NodeInfo.getNodeInfos(((GetElementsMessage)object3).elementPointers));
        }
        if (((By)method).getType() == By.Type.CLASS) {
            Object object4 = ((By)method).getValue();
            method = this;
            GetElementsMessage getElementsMessage = new GetElementsMessage();
            new GetElementsMessage().flag = 2;
            getElementsMessage.nodePtr = ((NodePtr)method).getPtr();
            getElementsMessage.tagName = object4;
            object4 = ((NodePtr)method).post(getElementsMessage);
            return ((NodePtr)method).getFactory().createNodes(NodeInfo.getNodeInfos(((GetElementsMessage)object4).elementPointers));
        }
        if (((By)method).getType() == By.Type.CSS_SELECTOR) {
            return this.a(((By)method).getValue());
        }
        if (((By)method).getType() == By.Type.XPATH && !((XPathResult)(object = this.evaluate(((By)object).getValue(), XPathResultType.ORDERED_NODE_SNAPSHOT_TYPE))).isError() && ((XPathResult)object).isSnapshotNodes()) {
            ArrayList<DOMElement> arrayList = new ArrayList<DOMElement>();
            object = ((XPathResult)object).getSnapshotNodes();
            Iterator<DOMNode> iterator = object.iterator();
            while (iterator.hasNext()) {
                DOMNode dOMNode = iterator.next();
                if (!(dOMNode instanceof DOMElement)) continue;
                arrayList.add((DOMElement)dOMNode);
            }
            if (arrayList.size() == object.size()) {
                return arrayList;
            }
        }
        return new ArrayList<DOMElement>();
    }

    @Override
    public synchronized DOMElement findElement(By method) {
        List<DOMElement> list;
        if ((list = this.findElements((By)((Object)list))).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized XPathResult evaluate(String expression) {
        void var1_1;
        return this.evaluate((String)var1_1, XPathResultType.ANY_TYPE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized XPathResult evaluate(String expression, XPathResultType type) {
        void var2_2;
        EvaluateXPathMessage evaluateXPathMessage;
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("The expression parameter cannot be null or empty.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type parameter cannot be null.");
        }
        EvaluateXPathMessage evaluateXPathMessage2 = new EvaluateXPathMessage();
        new EvaluateXPathMessage().expression = evaluateXPathMessage;
        evaluateXPathMessage2.contextNodePtr = this.getPtr();
        evaluateXPathMessage2.resultType = var2_2.getValue();
        evaluateXPathMessage = this.post(evaluateXPathMessage2);
        return new XPathResult(this.getChannel(), this.getFactory(), evaluateXPathMessage.resultId, evaluateXPathMessage.errorMsg);
    }

    @Override
    public long getParentFrameId() {
        GetNodeParentFrameMessage getNodeParentFrameMessage = new GetNodeParentFrameMessage();
        new GetNodeParentFrameMessage().nodePtr = this.getPtr();
        getNodeParentFrameMessage = this.post(getNodeParentFrameMessage);
        return getNodeParentFrameMessage.resultFrameId;
    }

    @Override
    public String getXPath() {
        GetNodeDataMessage getNodeDataMessage = new GetNodeDataMessage();
        new GetNodeDataMessage().flag = 4;
        getNodeDataMessage.nodePtr = this.getPtr();
        getNodeDataMessage = this.post(getNodeDataMessage);
        return getNodeDataMessage.result;
    }

    @Override
    public DOMNodePosition compareDocumentPosition(DOMNode targetNode) {
        CompareDocumentPositionMessage compareDocumentPositionMessage;
        if (targetNode == null) {
            throw new IllegalArgumentException("The targetNode parameter cannot be null.");
        }
        CompareDocumentPositionMessage compareDocumentPositionMessage2 = new CompareDocumentPositionMessage();
        new CompareDocumentPositionMessage().nodePtr = this.getPtr();
        compareDocumentPositionMessage2.parameterNodePtr = ((NodePtr)((Object)compareDocumentPositionMessage)).getPtr();
        compareDocumentPositionMessage = this.post(compareDocumentPositionMessage2);
        return DOMNodePosition.getValue(compareDocumentPositionMessage.result);
    }
}

