/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.BeforeRedirectParams;
import com.teamdev.jxbrowser.chromium.BeforeSendHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeSendProxyHeadersParams;
import com.teamdev.jxbrowser.chromium.BeforeURLRequestParams;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BytesData;
import com.teamdev.jxbrowser.chromium.Certificate;
import com.teamdev.jxbrowser.chromium.CertificateVerifier;
import com.teamdev.jxbrowser.chromium.CertificateVerifyFlag;
import com.teamdev.jxbrowser.chromium.CertificateVerifyParams;
import com.teamdev.jxbrowser.chromium.CertificateVerifyResult;
import com.teamdev.jxbrowser.chromium.Cookie;
import com.teamdev.jxbrowser.chromium.DataReceivedParams;
import com.teamdev.jxbrowser.chromium.FormData;
import com.teamdev.jxbrowser.chromium.HeadersReceivedParams;
import com.teamdev.jxbrowser.chromium.HostPortPair;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.MultipartFormData;
import com.teamdev.jxbrowser.chromium.NetworkDelegate;
import com.teamdev.jxbrowser.chromium.PACScriptErrorParams;
import com.teamdev.jxbrowser.chromium.ProxyType;
import com.teamdev.jxbrowser.chromium.RawData;
import com.teamdev.jxbrowser.chromium.RequestCompletedParams;
import com.teamdev.jxbrowser.chromium.RequestParams;
import com.teamdev.jxbrowser.chromium.RequestStatus;
import com.teamdev.jxbrowser.chromium.ResourceHandler;
import com.teamdev.jxbrowser.chromium.ResourceParams;
import com.teamdev.jxbrowser.chromium.ResourceType;
import com.teamdev.jxbrowser.chromium.ResponseStartedParams;
import com.teamdev.jxbrowser.chromium.SendHeadersParams;
import com.teamdev.jxbrowser.chromium.StatusLine;
import com.teamdev.jxbrowser.chromium.TextData;
import com.teamdev.jxbrowser.chromium.UploadData;
import com.teamdev.jxbrowser.chromium.at;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.internal.BytesDataBuilder;
import com.teamdev.jxbrowser.chromium.internal.CertificateFactory;
import com.teamdev.jxbrowser.chromium.internal.CookieParser;
import com.teamdev.jxbrowser.chromium.internal.EventQueueHelper;
import com.teamdev.jxbrowser.chromium.internal.FormDataBuilder;
import com.teamdev.jxbrowser.chromium.internal.HttpHeadersExImpl;
import com.teamdev.jxbrowser.chromium.internal.HttpHeadersImpl;
import com.teamdev.jxbrowser.chromium.internal.MultipartFormDataBuilder;
import com.teamdev.jxbrowser.chromium.internal.TextDataBuilder;
import com.teamdev.jxbrowser.chromium.internal.UploadDataBuilder;
import com.teamdev.jxbrowser.chromium.internal.UploadDataFactory;
import com.teamdev.jxbrowser.chromium.internal.UploadDataUtils;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.ChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCChannelListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.CloseAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.Message;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageType;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeRedirectMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeSendProxyHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnBeforeURLRequestMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanGetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCanSetCookiesMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCompletedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnDataReceivedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHeadersReceivedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnNetworkDelegateReadyMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPACScriptErrorMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRequestDestroyedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnResponseStartedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRunAuthDialogMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnSendHeadersMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnShouldBeginRequestMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnVerifyCertMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetAuthWhiteListsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetNetworkDelegateConfigMessage;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NetworkService {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final int b;
    private final EventQueueHelper c;
    private final ChannelListener d;
    private Channel e;
    private ResourceHandler f;
    private NetworkDelegate g;
    private CertificateVerifier h;
    private String i;
    private String j;
    private final IPCChannelListener k;
    private final IPC l;

    /*
     * WARNING - void declaration
     */
    NetworkService(int browserContextId, IPC ipc) {
        void var2_2;
        void var1_1;
        this.b = var1_1;
        this.d = new a(0);
        this.l = ipc;
        this.i = "";
        this.j = "";
        this.e = var2_2.getMainChannel();
        if (this.e != null) {
            this.e.addChannelListener(this.d);
        }
        this.k = new b(this, 0);
        this.c = new EventQueueHelper("Network Events Thread");
    }

    private void a(boolean bl) {
        if (this.e != null) {
            SetNetworkDelegateConfigMessage setNetworkDelegateConfigMessage = new SetNetworkDelegateConfigMessage();
            new SetNetworkDelegateConfigMessage().browserContextId = this.b;
            setNetworkDelegateConfigMessage.disableMessages = !bl;
            this.e.send(setNetworkDelegateConfigMessage);
        }
    }

    public final NetworkDelegate getNetworkDelegate() {
        return this.g;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNetworkDelegate(NetworkDelegate delegate) {
        void var1_1;
        this.g = var1_1;
        this.a(this.g != null);
    }

    public final CertificateVerifier getCertificateVerifier() {
        return this.h;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCertificateVerifier(CertificateVerifier verifier) {
        void var1_1;
        this.h = var1_1;
    }

    public final ResourceHandler getResourceHandler() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    public final void setResourceHandler(ResourceHandler handler) {
        void var1_1;
        this.f = var1_1;
    }

    public final String getServerWhiteList() {
        return this.i;
    }

    /*
     * WARNING - void declaration
     */
    public final void setServerWhiteList(String serverWhiteList) {
        void var1_1;
        this.i = var1_1;
        this.d();
    }

    public final String getDelegateWhiteList() {
        return this.j;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDelegateWhiteList(String delegateWhiteList) {
        void var1_1;
        this.j = var1_1;
        this.d();
    }

    private void d() {
        if (this.e != null) {
            SetAuthWhiteListsMessage setAuthWhiteListsMessage = new SetAuthWhiteListsMessage();
            new SetAuthWhiteListsMessage().browserContextId = this.b;
            setAuthWhiteListsMessage.serverWhiteList = this.i;
            setAuthWhiteListsMessage.delegateWhiteList = this.j;
            this.e.send(setAuthWhiteListsMessage);
        }
    }

    final void a() {
        NetworkService networkService = this;
        if (!networkService.c.isInitialized()) {
            networkService = this;
            networkService.c.initialize();
        }
        this.l.addIPCChannelListener(this.k);
    }

    final void b() {
        NetworkService networkService = this;
        if (networkService.c.isInitialized()) {
            networkService = this;
            networkService.c.uninitialize();
        }
        this.l.removeIPCChannelListener(this.k);
    }

    final class b
    extends IPCChannelAdapter {
        private /* synthetic */ NetworkService a;

        private b(NetworkService networkService) {
            this.a = networkService;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void onMainChannelAdded(Channel mainChannel) {
            void var1_1;
            mainChannel.addChannelListener(this.a.d);
            this.a.e = (Channel)var1_1;
        }

        @Override
        public final void onMainChannelRemoved(Channel mainChannel) {
            mainChannel.removeChannelListener(this.a.d);
            this.a.e = null;
        }

        /* synthetic */ b(NetworkService networkService, byte by) {
            this(networkService);
        }
    }

    final class a
    extends ChannelAdapter {
        private a() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void onMessageReceived(Message message) {
            a a2;
            MessageType messageType = message.getType();
            if (messageType == MessageType.OnBeforeUrlRequest) {
                OnBeforeURLRequestMessage onBeforeURLRequestMessage = (OnBeforeURLRequestMessage)message;
                message = this;
                if (onBeforeURLRequestMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    long l2 = onBeforeURLRequestMessage.requestId;
                    String string = onBeforeURLRequestMessage.url;
                    String string2 = onBeforeURLRequestMessage.method;
                    String string3 = onBeforeURLRequestMessage.originalHeaders;
                    byte[] byArray = onBeforeURLRequestMessage.uploadData;
                    String string4 = onBeforeURLRequestMessage.fileList;
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string3);
                    String string5 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    UploadData uploadData = null;
                    if ("POST".equals(string2)) {
                        object3 = httpHeadersExImpl.getHeader("Content-Type");
                        uploadData = UploadDataFactory.create((String)object3, byArray, string4);
                    }
                    if ("PUT".equals(string2) || "PATCH".equals(string2)) {
                        uploadData = new BytesData(byArray);
                    }
                    object3 = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onBeforeURLRequestMessage.renderProcessId, onBeforeURLRequestMessage.renderFrameId);
                    BeforeURLRequestParams beforeURLRequestParams = new BeforeURLRequestParams(l2, string, string2, (Browser)object3, uploadData);
                    ((a)message).NetworkService.this.g.onBeforeURLRequest(beforeURLRequestParams);
                    if ("POST".equals(string2)) {
                        object2 = beforeURLRequestParams.getUploadData();
                        if (object2 != null && uploadData != null && !uploadData.equals(object2)) {
                            Object object4;
                            object = uploadData.getType();
                            if (object2.getType() != object) {
                                object4 = UploadDataUtils.createContentTypeHeader(object2.getType());
                                httpHeadersExImpl.setHeader("Content-Type", (String)object4);
                            }
                            object4 = null;
                            if (object2 instanceof TextData) {
                                object4 = new TextDataBuilder((TextData)object2);
                            } else if (object2 instanceof MultipartFormData) {
                                String string6 = httpHeadersExImpl.getHeader("Content-Type");
                                string3 = UploadDataUtils.getBoundaryFromContentHeader(string6);
                                object4 = new MultipartFormDataBuilder((MultipartFormData)object2, string3);
                            } else if (object2 instanceof FormData) {
                                object4 = new FormDataBuilder((FormData)object2);
                            } else if (object2 instanceof BytesData) {
                                object4 = new BytesDataBuilder((BytesData)object2);
                            }
                            if (object4 != null) {
                                onBeforeURLRequestMessage.uploadData = ((UploadDataBuilder)object4).build();
                                onBeforeURLRequestMessage.fileList = ((UploadDataBuilder)object4).buildFileList();
                            }
                        }
                    } else if (("PUT".equals(string2) || "PATCH".equals(string2)) && (object2 = beforeURLRequestParams.getUploadData()) instanceof BytesData) {
                        object = (BytesData)object2;
                        onBeforeURLRequestMessage.uploadData = ((RawData)object).getData();
                    }
                    object2 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    if (!string5.equals(object2)) {
                        onBeforeURLRequestMessage.originalHeaders = object2;
                    }
                    if ((object = beforeURLRequestParams.getURL()) == null || string.equals(object)) return;
                    onBeforeURLRequestMessage.newLocation = object;
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeURLRequest() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeSendHeaders) {
                OnBeforeSendHeadersMessage onBeforeSendHeadersMessage = (OnBeforeSendHeadersMessage)message;
                message = this;
                if (onBeforeSendHeadersMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string;
                    String string7 = onBeforeSendHeadersMessage.url;
                    String string8 = onBeforeSendHeadersMessage.method;
                    long l3 = onBeforeSendHeadersMessage.requestId;
                    String string9 = onBeforeSendHeadersMessage.originalHeaders;
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string9);
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string9);
                    String string10 = httpHeadersImpl.getStringRepresentation("\r\n");
                    String string11 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onBeforeSendHeadersMessage.renderProcessId, onBeforeSendHeadersMessage.renderFrameId);
                    BeforeSendHeadersParams beforeSendHeadersParams = new BeforeSendHeadersParams(l3, string7, string8, browser, httpHeadersImpl, httpHeadersExImpl);
                    ((a)message).NetworkService.this.g.onBeforeSendHeaders(beforeSendHeadersParams);
                    String string12 = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (!string10.equals(string12)) {
                        onBeforeSendHeadersMessage.overrideHeaders = string12;
                    }
                    if (string11.equals(string = httpHeadersExImpl.getStringRepresentation("\r\n"))) return;
                    onBeforeSendHeadersMessage.overrideHeaders = string;
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeSendHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnSendHeaders) {
                OnSendHeadersMessage onSendHeadersMessage = (OnSendHeadersMessage)message;
                message = this;
                if (onSendHeadersMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onSendHeadersMessage.url;
                    String string13 = onSendHeadersMessage.method;
                    String string14 = onSendHeadersMessage.headers;
                    long l4 = onSendHeadersMessage.requestId;
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string14);
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string14);
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onSendHeadersMessage.renderProcessId, onSendHeadersMessage.renderFrameId);
                    SendHeadersParams sendHeadersParams = new SendHeadersParams(l4, string, string13, browser, httpHeadersImpl, httpHeadersExImpl);
                    ((a)message).NetworkService.this.g.onSendHeaders(sendHeadersParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onSendHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnHeadersReceived) {
                OnHeadersReceivedMessage onHeadersReceivedMessage = (OnHeadersReceivedMessage)message;
                message = this;
                if (onHeadersReceivedMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onHeadersReceivedMessage.url;
                    String string15 = onHeadersReceivedMessage.method;
                    long l5 = onHeadersReceivedMessage.requestId;
                    int n2 = onHeadersReceivedMessage.contentLength;
                    String string16 = onHeadersReceivedMessage.charset;
                    String string17 = onHeadersReceivedMessage.mimeType;
                    int n3 = onHeadersReceivedMessage.responseCode;
                    String string18 = onHeadersReceivedMessage.statusLine;
                    String string19 = onHeadersReceivedMessage.statusText;
                    String string20 = onHeadersReceivedMessage.originalHeaders;
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString(string20);
                    String string21 = httpHeadersImpl.getStringRepresentation("\r\n");
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString(string20);
                    String string22 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onHeadersReceivedMessage.renderProcessId, onHeadersReceivedMessage.renderFrameId);
                    HeadersReceivedParams headersReceivedParams = new HeadersReceivedParams(l5, string, string15, browser, n2, string16, string17, new StatusLine(string18, n3, string19), httpHeadersImpl, httpHeadersExImpl);
                    ((a)message).NetworkService.this.g.onHeadersReceived(headersReceivedParams);
                    string17 = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (!string21.equals(string17)) {
                        onHeadersReceivedMessage.overrideHeaders = string17;
                    }
                    if (string22.equals(message = httpHeadersExImpl.getStringRepresentation("\r\n"))) return;
                    onHeadersReceivedMessage.overrideHeaders = message;
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onHeadersReceived() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeRedirect) {
                OnBeforeRedirectMessage onBeforeRedirectMessage = (OnBeforeRedirectMessage)message;
                message = this;
                if (onBeforeRedirectMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onBeforeRedirectMessage.url;
                    String string23 = onBeforeRedirectMessage.method;
                    long l6 = onBeforeRedirectMessage.requestId;
                    int n4 = onBeforeRedirectMessage.responseCode;
                    String string24 = onBeforeRedirectMessage.newLocation;
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onBeforeRedirectMessage.renderProcessId, onBeforeRedirectMessage.renderFrameId);
                    BeforeRedirectParams beforeRedirectParams = new BeforeRedirectParams(l6, string, string23, browser, n4, string24);
                    ((a)message).NetworkService.this.g.onBeforeRedirect(beforeRedirectParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeRedirect() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnResponseStarted) {
                OnResponseStartedMessage onResponseStartedMessage = (OnResponseStartedMessage)message;
                message = this;
                if (onResponseStartedMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onResponseStartedMessage.url;
                    String string25 = onResponseStartedMessage.method;
                    long l7 = onResponseStartedMessage.requestId;
                    int n5 = onResponseStartedMessage.responseCode;
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onResponseStartedMessage.renderProcessId, onResponseStartedMessage.renderFrameId);
                    ResponseStartedParams responseStartedParams = new ResponseStartedParams(l7, string, string25, browser, n5);
                    ((a)message).NetworkService.this.g.onResponseStarted(responseStartedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onResponseStarted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnCompleted) {
                OnCompletedMessage onCompletedMessage = (OnCompletedMessage)message;
                message = this;
                if (onCompletedMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    RequestStatus requestStatus = RequestStatus.valueOf(onCompletedMessage.status);
                    NetError netError = NetError.valueOf(onCompletedMessage.errorCode);
                    if (netError == NetError.UNKNOWN) {
                        netError = null;
                    }
                    String string = onCompletedMessage.url;
                    String string26 = onCompletedMessage.method;
                    long l8 = onCompletedMessage.requestId;
                    int n6 = onCompletedMessage.responseCode;
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onCompletedMessage.renderProcessId, onCompletedMessage.renderFrameId);
                    RequestCompletedParams requestCompletedParams = new RequestCompletedParams(l8, string, string26, browser, n6, requestStatus, netError);
                    ((a)message).NetworkService.this.g.onCompleted(requestCompletedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onCompleted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnRequestDestroyed) {
                OnRequestDestroyedMessage onRequestDestroyedMessage = (OnRequestDestroyedMessage)message;
                message = this;
                if (onRequestDestroyedMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onRequestDestroyedMessage.url;
                    String string27 = onRequestDestroyedMessage.method;
                    long l9 = onRequestDestroyedMessage.requestId;
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onRequestDestroyedMessage.renderProcessId, onRequestDestroyedMessage.renderFrameId);
                    RequestParams requestParams = new RequestParams(l9, string, string27, browser);
                    ((a)message).NetworkService.this.g.onDestroyed(requestParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onCompleted() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnPACScriptError) {
                OnPACScriptErrorMessage onPACScriptErrorMessage = (OnPACScriptErrorMessage)message;
                message = this;
                if (onPACScriptErrorMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onPACScriptErrorMessage.errorText;
                    int n7 = onPACScriptErrorMessage.lineNumber;
                    ((a)message).NetworkService.this.g.onPACScriptError(new PACScriptErrorParams(n7, string));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onPACScriptError() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnRunAuthDialog) {
                OnRunAuthDialogMessage onRunAuthDialogMessage = (OnRunAuthDialogMessage)message;
                message = this;
                if (onRunAuthDialogMessage.browserContextId != ((a)message).NetworkService.this.b) return;
                CloseAuthDialogMessage closeAuthDialogMessage = new CloseAuthDialogMessage();
                new CloseAuthDialogMessage().browserContextId = ((a)message).NetworkService.this.b;
                closeAuthDialogMessage.dialogId = onRunAuthDialogMessage.dialogId;
                if (((a)message).NetworkService.this.g == null) {
                    ((a)message).NetworkService.this.e.send(closeAuthDialogMessage);
                    return;
                }
                ((a)message).NetworkService.this.c.getEventQueue().invokeLater(new at((a)message, onRunAuthDialogMessage, closeAuthDialogMessage));
                return;
            }
            if (messageType == MessageType.OnCanGetCookies) {
                OnCanGetCookiesMessage onCanGetCookiesMessage = (OnCanGetCookiesMessage)message;
                message = this;
                if (onCanGetCookiesMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                String string = onCanGetCookiesMessage.url;
                List<Cookie> list = CookieParser.parseCookiesString(onCanGetCookiesMessage.cookies);
                try {
                    onCanGetCookiesMessage.canGetCookies = ((a)message).NetworkService.this.g.onCanGetCookies(string, list);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The DialogHandler.onCanGetCookies() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnCanSetCookies) {
                OnCanSetCookiesMessage onCanSetCookiesMessage = (OnCanSetCookiesMessage)message;
                message = this;
                if (onCanSetCookiesMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                String string = onCanSetCookiesMessage.url;
                List<Cookie> list = CookieParser.parseCookiesString(onCanSetCookiesMessage.cookies);
                try {
                    onCanSetCookiesMessage.canSetCookies = ((a)message).NetworkService.this.g.onCanSetCookies(string, list);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The DialogHandler.onCanSetCookies() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnShouldBeginRequest) {
                OnShouldBeginRequestMessage onShouldBeginRequestMessage = (OnShouldBeginRequestMessage)message;
                message = this;
                if (onShouldBeginRequestMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.f == null) return;
                String string = onShouldBeginRequestMessage.url;
                String string28 = onShouldBeginRequestMessage.method;
                ResourceType resourceType = ResourceType.valueOf(onShouldBeginRequestMessage.resourceType);
                try {
                    onShouldBeginRequestMessage.cancel = !((a)message).NetworkService.this.f.canLoadResource(new ResourceParams(string, string28, resourceType));
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The ResourceHandler.canLoadResource() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnBeforeSendProxyHeaders) {
                OnBeforeSendProxyHeadersMessage onBeforeSendProxyHeadersMessage = (OnBeforeSendProxyHeadersMessage)message;
                message = this;
                if (onBeforeSendProxyHeadersMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onBeforeSendProxyHeadersMessage.url;
                    String string29 = onBeforeSendProxyHeadersMessage.method;
                    long l10 = onBeforeSendProxyHeadersMessage.requestId;
                    Object object = onBeforeSendProxyHeadersMessage.originalHeaders;
                    boolean bl = onBeforeSendProxyHeadersMessage.didProxyBypass;
                    boolean bl2 = onBeforeSendProxyHeadersMessage.didUsePacScript;
                    String string30 = onBeforeSendProxyHeadersMessage.host;
                    int n8 = onBeforeSendProxyHeadersMessage.port;
                    int n9 = onBeforeSendProxyHeadersMessage.schema;
                    ProxyType proxyType = ProxyType.from(n9);
                    HostPortPair hostPortPair = new HostPortPair(string30, n8);
                    HttpHeadersImpl httpHeadersImpl = HttpHeadersImpl.buildFromString((String)object);
                    String string31 = httpHeadersImpl.getStringRepresentation("\r\n");
                    HttpHeadersExImpl httpHeadersExImpl = HttpHeadersExImpl.buildFromString((String)object);
                    String string32 = httpHeadersExImpl.getStringRepresentation("\r\n");
                    object = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onBeforeSendProxyHeadersMessage.renderProcessId, onBeforeSendProxyHeadersMessage.renderFrameId);
                    BeforeSendProxyHeadersParams beforeSendProxyHeadersParams = new BeforeSendProxyHeadersParams(l10, string, string29, (Browser)object, httpHeadersImpl, httpHeadersExImpl, bl, bl2, proxyType, hostPortPair);
                    ((a)message).NetworkService.this.g.onBeforeSendProxyHeaders(beforeSendProxyHeadersParams);
                    message = httpHeadersImpl.getStringRepresentation("\r\n");
                    if (!string31.equals(message)) {
                        onBeforeSendProxyHeadersMessage.overrideHeaders = message;
                    }
                    if (string32.equals(message = httpHeadersExImpl.getStringRepresentation("\r\n"))) return;
                    onBeforeSendProxyHeadersMessage.overrideHeaders = message;
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onBeforeSendProxyHeaders() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnVerifyCert) {
                OnVerifyCertMessage onVerifyCertMessage = (OnVerifyCertMessage)message;
                message = this;
                if (((a)message).NetworkService.this.h == null || onVerifyCertMessage.browserContextId != ((a)message).NetworkService.this.b) return;
                Certificate certificate = CertificateFactory.certificateFromString(onVerifyCertMessage.certData);
                EnumSet<CertificateVerifyFlag> enumSet = EnumSet.noneOf(CertificateVerifyFlag.class);
                int n10 = onVerifyCertMessage.resultFlags;
                if ((n10 & 1) != 0) {
                    enumSet.add(CertificateVerifyFlag.COMMON_NAME_INVALID);
                }
                if ((n10 & 2) != 0) {
                    enumSet.add(CertificateVerifyFlag.DATE_INVALID);
                }
                if ((n10 & 4) != 0) {
                    enumSet.add(CertificateVerifyFlag.AUTHORITY_INVALID);
                }
                if ((n10 & 0x10) != 0) {
                    enumSet.add(CertificateVerifyFlag.NO_REVOCATION_MECHANISM);
                }
                if ((n10 & 0x20) != 0) {
                    enumSet.add(CertificateVerifyFlag.UNABLE_TO_CHECK_REVOCATION);
                }
                if ((n10 & 0x40) != 0) {
                    enumSet.add(CertificateVerifyFlag.REVOKED);
                }
                if ((n10 & 0x80) != 0) {
                    enumSet.add(CertificateVerifyFlag.INVALID);
                }
                if ((n10 & 0x100) != 0) {
                    enumSet.add(CertificateVerifyFlag.WEAK_SIGNATURE_ALGORITHM);
                }
                if ((n10 & 0x400) != 0) {
                    enumSet.add(CertificateVerifyFlag.NON_UNIQUE_NAME);
                }
                if ((n10 & 0x800) != 0) {
                    enumSet.add(CertificateVerifyFlag.WEAK_KEY);
                }
                if ((n10 & 0x2000) != 0) {
                    enumSet.add(CertificateVerifyFlag.PINNED_KEY_MISSING);
                }
                if ((n10 & 0x4000) != 0) {
                    enumSet.add(CertificateVerifyFlag.NAME_CONSTRAINT_VIOLATION);
                }
                if ((n10 & 0x8000) != 0) {
                    enumSet.add(CertificateVerifyFlag.VALIDITY_TOO_LONG);
                }
                if ((n10 & 0x10000) != 0) {
                    enumSet.add(CertificateVerifyFlag.IS_EV);
                }
                if ((n10 & 0x20000) != 0) {
                    enumSet.add(CertificateVerifyFlag.REV_CHECKING_ENABLED);
                }
                if ((n10 & 0x80000) != 0) {
                    enumSet.add(CertificateVerifyFlag.SHA1_SIGNATURE_PRESENT);
                }
                String string = onVerifyCertMessage.hostName;
                CertificateVerifyParams certificateVerifyParams = new CertificateVerifyParams(string, certificate, enumSet);
                try {
                    CertificateVerifyResult certificateVerifyResult = ((a)message).NetworkService.this.h.verify(certificateVerifyParams);
                    if (certificateVerifyResult == CertificateVerifyResult.INVALID) {
                        onVerifyCertMessage.resultCode = -207;
                        onVerifyCertMessage.resultFlags = 128;
                        return;
                    }
                    if (certificateVerifyResult != CertificateVerifyResult.OK) return;
                    onVerifyCertMessage.resultCode = 0;
                    onVerifyCertMessage.resultFlags = 0;
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The CertificateVerifier.verify() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType == MessageType.OnReceivedData) {
                OnDataReceivedMessage onDataReceivedMessage = (OnDataReceivedMessage)message;
                message = this;
                if (onDataReceivedMessage.browserContextId != ((a)message).NetworkService.this.b || ((a)message).NetworkService.this.g == null) return;
                try {
                    String string = onDataReceivedMessage.url;
                    String string33 = onDataReceivedMessage.method;
                    String string34 = onDataReceivedMessage.charset;
                    String string35 = onDataReceivedMessage.mimeType;
                    long l11 = onDataReceivedMessage.requestId;
                    byte[] byArray = onDataReceivedMessage.data;
                    Browser browser = com.teamdev.jxbrowser.chromium.NetworkService$a.a(onDataReceivedMessage.renderProcessId, onDataReceivedMessage.renderFrameId);
                    DataReceivedParams dataReceivedParams = new DataReceivedParams(l11, string, string33, browser, string34, string35, byArray);
                    ((a)message).NetworkService.this.g.onDataReceived(dataReceivedParams);
                    return;
                }
                catch (Exception exception) {
                    a.log(Level.SEVERE, "The NetworkDelegate.onDataReceived() method has thrown exception: ", exception);
                }
                return;
            }
            if (messageType != MessageType.OnNetworkDelegateReady) return;
            OnNetworkDelegateReadyMessage onNetworkDelegateReadyMessage = (OnNetworkDelegateReadyMessage)((Object)a2);
            a2 = this;
            if (onNetworkDelegateReadyMessage.browserContextId != a2.NetworkService.this.b) return;
            a2.NetworkService.this.a(a2.NetworkService.this.g != null);
            a2.NetworkService.this.d();
        }

        private static Browser a(int n2, int n3) {
            for (Browser browser : IPC.getBrowsers()) {
                if (n2 != browser.a()) continue;
                for (Long l2 : browser.b()) {
                    if (l2 != (long)n3) continue;
                    return browser;
                }
            }
            return null;
        }

        /* synthetic */ a(byte by) {
            this();
        }

        static /* synthetic */ Browser a(a a2, int n2, int n3) {
            return com.teamdev.jxbrowser.chromium.NetworkService$a.a(n2, n3);
        }
    }
}

