/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.ExtendedKeyUsage;
import com.teamdev.jxbrowser.chromium.KeyUsage;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.Principal;
import com.teamdev.jxbrowser.chromium.SubjectAlternativeName;
import com.teamdev.jxbrowser.chromium.internal.X509CertificateFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public final class Certificate {
    private final String a;
    private final String b;
    private final boolean c;
    private final long d;
    private final long e;
    private final String f;
    private final Principal g;
    private final Principal h;
    private final X509Certificate i;
    private final PrivateKey j;

    /*
     * WARNING - void declaration
     */
    public Certificate(String issuerName, String subjectName, boolean hasExpired, long startTime, long expiryTime, String caFingerPrint, String certData) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = startTime;
        this.e = expiryTime;
        this.f = caFingerPrint;
        this.i = Certificate.a(certData);
        this.g = Certificate.a(this.i);
        this.h = Certificate.b(this.i);
        this.j = null;
    }

    /*
     * WARNING - void declaration
     */
    public Certificate(X509Certificate certificate) {
        this((X509Certificate)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Certificate(X509Certificate certificate, PrivateKey key) {
        void var1_1;
        void var2_2;
        if (certificate == null) {
            throw new IllegalArgumentException("The certificate parameter cannot be null.");
        }
        this.i = certificate;
        this.j = var2_2;
        this.g = Certificate.a(certificate);
        this.h = Certificate.b(certificate);
        this.a = Certificate.a(this.g);
        this.b = Certificate.a(this.h);
        this.d = certificate.getNotBefore().getTime();
        this.e = var1_1.getNotAfter().getTime();
        this.c = System.currentTimeMillis() > this.e;
        this.f = "";
    }

    private static X509Certificate a(String string) {
        try {
            return X509CertificateFactory.create(string);
        }
        catch (CertificateException certificateException) {
            LoggerProvider.getBrowserLogger().log(Level.WARNING, "Failed to parse X509Certificate data. " + certificateException.getMessage());
            return null;
        }
    }

    private static Principal a(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            return new Principal(x509Certificate.getIssuerX500Principal().getName());
        }
        return null;
    }

    private static Principal b(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            return new Principal(x509Certificate.getSubjectX500Principal().getName());
        }
        return null;
    }

    private static String a(Principal principal) {
        if (!principal.getCommonName().isEmpty()) {
            return principal.getCommonName();
        }
        if (!principal.getOrganizationName().isEmpty()) {
            return principal.getOrganizationName();
        }
        return principal.getOrganizationUnitName();
    }

    public final X509Certificate getX509Certificate() {
        return this.i;
    }

    public final Principal getIssuer() {
        return this.g;
    }

    public final String getIssuerName() {
        return this.a;
    }

    public final Principal getSubject() {
        return this.h;
    }

    public final String getSubjectName() {
        return this.b;
    }

    public final boolean hasExpired() {
        return this.c;
    }

    public final long getValidStartTime() {
        return this.d;
    }

    public final long getValidExpiryTime() {
        return this.e;
    }

    public final String getFingerPrint() {
        if (this.i != null) {
            try {
                Object object = MessageDigest.getInstance("SHA-1");
                Object[] objectArray = this.i.getEncoded();
                ((MessageDigest)object).update((byte[])objectArray);
                byte[] byArray = ((MessageDigest)object).digest();
                object = byArray;
                object = byArray;
                objectArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
                StringBuilder stringBuilder = new StringBuilder(((Object)object).length << 1);
                for (Object object2 : object) {
                    stringBuilder.append((char)objectArray[(object2 & 0xF0) >> 4]);
                    stringBuilder.append((char)objectArray[object2 & 0xF]);
                }
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public final String getSerialNumber() {
        if (this.i != null) {
            return this.i.getSerialNumber().toString().toUpperCase();
        }
        return "";
    }

    public final List<KeyUsage> getKeyUsages() {
        boolean[] blArray;
        LinkedList<KeyUsage> linkedList = new LinkedList<KeyUsage>();
        if (this.i != null && (blArray = this.i.getKeyUsage()) != null) {
            for (int i2 = 0; i2 < blArray.length && KeyUsage.values().length > i2; ++i2) {
                if (!blArray[i2]) continue;
                linkedList.add(KeyUsage.values()[i2]);
            }
        }
        return linkedList;
    }

    public final List<ExtendedKeyUsage> getExtendedKeyUsages() {
        LinkedList<ExtendedKeyUsage> linkedList = new LinkedList<ExtendedKeyUsage>();
        if (this.i != null) {
            try {
                Object object = this.i.getExtendedKeyUsage();
                if (object != null) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object2 = (String)object.next();
                        if ((object2 = ExtendedKeyUsage.a(object2)) == null) continue;
                        linkedList.add((ExtendedKeyUsage)((Object)object2));
                    }
                }
            }
            catch (CertificateParsingException certificateParsingException) {}
        }
        return linkedList;
    }

    public final List<SubjectAlternativeName> getSubjectAlternativeNames() {
        LinkedList<SubjectAlternativeName> linkedList = new LinkedList<SubjectAlternativeName>();
        if (this.i != null) {
            try {
                Object object = this.i.getSubjectAlternativeNames();
                if (object != null) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object2 = (List)object.next();
                        if (object2.size() != 2) continue;
                        int n2 = (Integer)object2.get(0);
                        object2 = object2.get(1).toString();
                        if (n2 >= SubjectAlternativeName.Type.values().length) continue;
                        linkedList.add(new SubjectAlternativeName(SubjectAlternativeName.Type.values()[n2], (String)object2));
                    }
                }
            }
            catch (CertificateParsingException certificateParsingException) {}
        }
        return linkedList;
    }

    public final String getCAFingerPrint() {
        return this.f;
    }

    public final String toString() {
        return "Certificate{subject=" + this.h + '}';
    }

    public final PrivateKey getPrivateKey() {
        return this.j;
    }
}

