/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.internal.NativeKeyModifiers;

public final class BrowserKeyEvent {
    public static final char CHAR_UNDEFINED = '\uffff';
    private final KeyCode a;
    private final KeyEventType b;
    private final KeyModifiers c;
    private final char d;
    private final long e;

    /*
     * WARNING - void declaration
     */
    public BrowserKeyEvent(KeyEventType eventType, KeyCode keyCode) {
        this((KeyEventType)var1_1, (KeyCode)var2_2, '\uffff');
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BrowserKeyEvent(KeyEventType eventType, KeyCode keyCode, char keyChar) {
        this((KeyEventType)var1_1, (KeyCode)var2_2, (char)var3_3, KeyModifiers.NO_MODIFIERS);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BrowserKeyEvent(KeyEventType eventType, KeyCode keyCode, KeyModifiers modifiers) {
        this((KeyEventType)var1_1, (KeyCode)var2_2, '\uffff', (KeyModifiers)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BrowserKeyEvent(KeyEventType eventType, KeyCode keyCode, char keyChar, KeyModifiers modifiers) {
        this((KeyEventType)var1_1, (KeyCode)var2_2, (char)var3_3, modifiers, System.currentTimeMillis());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BrowserKeyEvent(KeyEventType eventType, KeyCode keyCode, char keyChar, KeyModifiers modifiers, long when) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (modifiers == null) {
            throw new IllegalArgumentException("The modifiers parameter cannot be null.");
        }
        if (when < 0L) {
            throw new IllegalArgumentException("The when parameter cannot be negative.");
        }
        this.a = var2_2;
        this.b = var1_1;
        this.d = var3_3;
        this.c = modifiers;
        this.e = when;
    }

    public final KeyCode getKeyCode() {
        return this.a;
    }

    public final KeyEventType getEventType() {
        return this.b;
    }

    public final char getKeyChar() {
        return this.d;
    }

    public final KeyModifiers getModifiers() {
        return this.c;
    }

    public final long getWhen() {
        return this.e;
    }

    public static final class KeyModifiersBuilder {
        private int a;

        public final KeyModifiers build() {
            return new KeyModifiers(this.a, 0);
        }

        public final KeyModifiersBuilder altDown() {
            this.a |= NativeKeyModifiers.ALT_DOWN_MASK.getValue();
            return this;
        }

        public final KeyModifiersBuilder altGraphDown() {
            this.a |= NativeKeyModifiers.ALT_GRAPH_DOWN_MASK.getValue();
            return this;
        }

        public final KeyModifiersBuilder shiftDown() {
            this.a |= NativeKeyModifiers.SHIFT_DOWN_MASK.getValue();
            return this;
        }

        public final KeyModifiersBuilder ctrlDown() {
            this.a |= NativeKeyModifiers.CTRL_DOWN_MASK.getValue();
            return this;
        }

        public final KeyModifiersBuilder metaDown() {
            this.a |= NativeKeyModifiers.META_DOWN_MASK.getValue();
            return this;
        }

        public final KeyModifiersBuilder mouseButton() {
            this.a |= NativeKeyModifiers.LEFT_BUTTON_MASK.getValue();
            return this;
        }
    }

    public static final class KeyModifiers {
        public static final KeyModifiers NO_MODIFIERS = new KeyModifiers(0);
        private final int a;

        /*
         * WARNING - void declaration
         */
        private KeyModifiers(int modifiers) {
            void var1_1;
            this.a = var1_1;
        }

        public final boolean isAltDown() {
            return (this.a & NativeKeyModifiers.ALT_DOWN_MASK.getValue()) != 0;
        }

        public final boolean isAltGraphDown() {
            return (this.a & NativeKeyModifiers.ALT_GRAPH_DOWN_MASK.getValue()) != 0;
        }

        public final boolean isShiftDown() {
            return (this.a & NativeKeyModifiers.SHIFT_DOWN_MASK.getValue()) != 0;
        }

        public final boolean isControlDown() {
            return (this.a & NativeKeyModifiers.CTRL_DOWN_MASK.getValue()) != 0;
        }

        public final boolean isMetaDown() {
            return (this.a & NativeKeyModifiers.META_DOWN_MASK.getValue()) != 0;
        }

        final int a() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ KeyModifiers(int x0, byte by) {
            this((int)var1_1);
            void var1_1;
        }
    }

    public static enum KeyCode {
        VK_LBUTTON(1),
        VK_RBUTTON(2),
        VK_CANCEL(3),
        VK_MBUTTON(4),
        VK_XBUTTON1(5),
        VK_XBUTTON2(6),
        VK_BACK(8),
        VK_TAB(9),
        VK_CLEAR(12),
        VK_RETURN(13),
        VK_SHIFT(16),
        VK_CONTROL(17),
        VK_MENU(18),
        VK_PAUSE(19),
        VK_CAPITAL(20),
        VK_KANA(21),
        VK_HANGUEL(21),
        VK_HANGUL(21),
        VK_JUNJA(23),
        VK_FINAL(24),
        VK_HANJA(25),
        VK_KANJI(25),
        VK_ESCAPE(27),
        VK_CONVERT(28),
        VK_NONCONVERT(29),
        VK_ACCEPT(30),
        VK_MODECHANGE(31),
        VK_SPACE(32),
        VK_PRIOR(33),
        VK_NEXT(34),
        VK_END(35),
        VK_HOME(36),
        VK_LEFT(37),
        VK_UP(38),
        VK_RIGHT(39),
        VK_DOWN(40),
        VK_SELECT(41),
        VK_PRINT(42),
        VK_EXECUTE(43),
        VK_SNAPSHOT(44),
        VK_INSERT(45),
        VK_DELETE(46),
        VK_HELP(47),
        VK_0(48),
        VK_1(49),
        VK_2(50),
        VK_3(51),
        VK_4(52),
        VK_5(53),
        VK_6(54),
        VK_7(55),
        VK_8(56),
        VK_9(57),
        VK_A(65),
        VK_B(66),
        VK_C(67),
        VK_D(68),
        VK_E(69),
        VK_F(70),
        VK_G(71),
        VK_H(72),
        VK_I(73),
        VK_J(74),
        VK_K(75),
        VK_L(76),
        VK_M(77),
        VK_N(78),
        VK_O(79),
        VK_P(80),
        VK_Q(81),
        VK_R(82),
        VK_S(83),
        VK_T(84),
        VK_U(85),
        VK_V(86),
        VK_W(87),
        VK_X(88),
        VK_Y(89),
        VK_Z(90),
        VK_LWIN(91),
        VK_RWIN(92),
        VK_LCMD(91),
        VK_RCMD(93),
        VK_APPS(93),
        VK_SLEEP(95),
        VK_NUMPAD0(96),
        VK_NUMPAD1(97),
        VK_NUMPAD2(98),
        VK_NUMPAD3(99),
        VK_NUMPAD4(100),
        VK_NUMPAD5(101),
        VK_NUMPAD6(102),
        VK_NUMPAD7(103),
        VK_NUMPAD8(104),
        VK_NUMPAD9(105),
        VK_MULTIPLY(106),
        VK_ADD(107),
        VK_SEPARATOR(108),
        VK_SUBTRACT(109),
        VK_DECIMAL(110),
        VK_DIVIDE(111),
        VK_F1(112),
        VK_F2(113),
        VK_F3(114),
        VK_F4(115),
        VK_F5(116),
        VK_F6(117),
        VK_F7(118),
        VK_F8(119),
        VK_F9(120),
        VK_F10(121),
        VK_F11(122),
        VK_F12(123),
        VK_F13(124),
        VK_F14(125),
        VK_F15(126),
        VK_F16(127),
        VK_F17(128),
        VK_F18(129),
        VK_F19(130),
        VK_F20(131),
        VK_F21(132),
        VK_F22(133),
        VK_F23(134),
        VK_F24(135),
        VK_NUMLOCK(144),
        VK_SCROLL(145),
        VK_LSHIFT(160),
        VK_RSHIFT(161),
        VK_LCONTROL(162),
        VK_RCONTROL(163),
        VK_LMENU(164),
        VK_RMENU(165),
        VK_COMMAND(157),
        VK_BROWSER_BACK(166),
        VK_BROWSER_FORWARD(167),
        VK_BROWSER_REFRESH(168),
        VK_BROWSER_STOP(169),
        VK_BROWSER_SEARCH(170),
        VK_BROWSER_FAVORITES(171),
        VK_BROWSER_HOME(172),
        VK_VOLUME_MUTE(173),
        VK_VOLUME_DOWN(174),
        VK_VOLUME_UP(175),
        VK_MEDIA_NEXT_TRACK(176),
        VK_MEDIA_PREV_TRACK(177),
        VK_MEDIA_STOP(178),
        VK_MEDIA_PLAY_PAUSE(179),
        VK_LAUNCH_MAIL(180),
        VK_LAUNCH_MEDIA_SELECT(181),
        VK_LAUNCH_APP1(182),
        VK_LAUNCH_APP2(183),
        VK_OEM_PLUS(187),
        VK_OEM_COMMA(188),
        VK_OEM_MINUS(189),
        VK_OEM_PERIOD(190),
        VK_OEM_1(186),
        VK_OEM_2(191),
        VK_OEM_3(192),
        VK_OEM_4(219),
        VK_OEM_5(220),
        VK_OEM_6(221),
        VK_OEM_7(222),
        VK_OEM_8(223),
        VK_OEM_102(226),
        VK_PROCESSKEY(229),
        VK_PACKET(231),
        VK_ATTN(246),
        VK_CRSEL(247),
        VK_EXSEL(248),
        VK_EREOF(249),
        VK_PLAY(250),
        VK_ZOOM(251),
        VK_NONAME(252),
        VK_PA1(253),
        VK_OEM_CLEAR(254),
        VK_DBE_ALPHANUMERIC(240),
        VK_UNDEFINED(0);

        private final int a;

        /*
         * WARNING - void declaration
         */
        private KeyCode(int code) {
            void var3_3;
            this.a = var3_3;
        }

        public final int getCode() {
            return this.a;
        }
    }

    public static enum KeyEventType {
        PRESSED(401),
        RELEASED(402),
        TYPED(400);

        private final int a;

        /*
         * WARNING - void declaration
         */
        private KeyEventType(int value) {
            void var3_3;
            this.a = var3_3;
        }

        public final int getValue() {
            return this.a;
        }
    }
}

