/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.swing.internal;

import com.teamdev.jxbrowser.chromium.internal.OS;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Method;

public class AWTHelper {
    private static final String LIBRARY_NAME = "awt-helper";

    private AWTHelper() {
        try {
            Class<?> aClass = Class.forName("com.teamdev.jxbrowser.chromium.BrowserPreferences");
            Method getChromiumDir = aClass.getDeclaredMethod("getChromiumDir", new Class[0]);
            String chromiumDir = (String)getChromiumDir.invoke(null, new Object[0]);
            File library = new File(chromiumDir, AWTHelper.getName());
            System.load(library.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getName() {
        String libraryName = LIBRARY_NAME;
        if (OS.isWindows()) {
            return libraryName + ".dll";
        }
        if (OS.isMac()) {
            return "lib" + libraryName + ".dylib";
        }
        if (OS.isLinux()) {
            return "lib" + libraryName + ".so";
        }
        throw new RuntimeException("Unsupported operating system.");
    }

    public static AWTHelper getInstance() {
        return InstanceHolder.instance;
    }

    public native long getWindowHandle(Window var1);

    public native void requestFocus(Window var1);

    private static class InstanceHolder {
        private static final AWTHelper instance = new AWTHelper();

        private InstanceHolder() {
        }
    }
}

