/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal.dialogs;

import com.sun.javafx.scene.control.CustomColorDialog;
import com.teamdev.jxbrowser.chromium.javafx.internal.Native;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.stage.Window;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ColorDialog {
    private final Node parent;
    private Color currentColor;

    public ColorDialog(Node parent, Color currentColor) {
        this.parent = parent;
        this.currentColor = currentColor;
    }

    public Color getCurrentColor() {
        return this.currentColor;
    }

    public boolean show() {
        AtomicReference<Boolean> result = new AtomicReference<Boolean>(false);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                Window window = Native.getInstance().getWindowForNode(this.parent);
                if (window == null) {
                    return;
                }
                CustomColorDialog dialog = new CustomColorDialog(window);
                dialog.setCurrentColor(this.currentColor);
                VBox controlBox = (VBox)dialog.getChildren().get(1);
                HBox buttonBox = (HBox)controlBox.getChildren().get(2);
                buttonBox.getChildren().remove(0);
                dialog.setOnUse(() -> {
                    this.currentColor = dialog.getCustomColor();
                    result.set(true);
                    latch.countDown();
                });
                dialog.setOnHidden(event -> latch.countDown());
                Stage stage = dialog.getDialog();
                stage.setTitle("Select Color");
                dialog.show();
                stage.centerOnScreen();
            }
            catch (Exception e) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        return result.get();
    }
}

