/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.javafx.internal;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.stage.StageHelper;
import com.sun.javafx.tk.TKStage;
import com.teamdev.jxbrowser.chromium.internal.OS;
import com.teamdev.jxbrowser.chromium.javafx.internal.NativeMac;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Native {
    private static Native instance = null;

    Native() {
    }

    public static Native getInstance() {
        if (instance == null) {
            instance = OS.isMac() ? new NativeMac() : new Native();
        }
        return instance;
    }

    public long getWindowHandle(Window window) {
        TKStage tkStage = StageHelper.getPeer((Window)window);
        long rawHandle = tkStage.getRawHandle();
        List windows = com.sun.glass.ui.Window.getWindows();
        for (com.sun.glass.ui.Window platformWindow : windows) {
            if (platformWindow.getRawHandle() != rawHandle) continue;
            return platformWindow.getNativeWindow();
        }
        return 0L;
    }

    public void traverseFocus(Node node, Direction direction) {
        NodeHelper.NodeAccessor nodeAccessor = NodeHelper.getNodeAccessor();
        nodeAccessor.traverse(node, direction);
    }

    public Window getWindowForNode(Node node) {
        Scene scene;
        if (node != null && (scene = node.getScene()) != null) {
            return scene.getWindow();
        }
        return null;
    }

    public boolean isDpiAware(double deviceScaleFactor) {
        return OS.isMac() || OS.isWindows();
    }
}

