/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.math;

import com.ti.eps.calc.math.DefaultNumberFormatter;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.z80.math.MathException;
import com.ti.eps.calc.z80.math.MathUtil;
import com.ti.eps.calc.z80.math.Operand;
import com.ti.eps.calc.z80.math.VarConverter83;
import javax.swing.text.NumberFormatter;

public class Z80Number
extends MathNumber {
    private static final long serialVersionUID = 1L;
    private static NumberFormatter defaultNumberFormatter = new DefaultNumberFormatter(Z80Number.class);
    public static Z80Number ZERO = new Z80Number(0.0);
    public static Z80Number INFINITY = new Z80Number(0.0);
    public static Z80Number NaN;
    private Operand m_operand = new Operand();
    private boolean m_infinite = false;

    public Z80Number(String string) {
        this.setValue(string);
    }

    public Z80Number(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    private void set(int n, int n2, int n3) {
        this.m_operand.set1(n, n2, n3);
    }

    public Z80Number(double d) {
        this.m_operand.set(VarConverter83.doubleToMathPack2(d));
    }

    public Z80Number(Operand operand) {
        this.m_operand.set(operand);
    }

    public Z80Number(Number number) {
        if (number instanceof Z80Number) {
            Z80Number z80Number = (Z80Number)number;
            this.m_operand.set(z80Number.getOperand());
            this.setNaN(z80Number.isNaN());
            this.setInfinite(z80Number.isInfinite());
        } else {
            this.m_operand.set(VarConverter83.doubleToMathPack2(number.doubleValue()));
        }
    }

    public Z80Number(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF & 0xFFFFFF80;
        int n3 = (byte)n2 == -128 ? -1 : 1;
        int n4 = byArray[n] & 0x7F;
        if (n4 == 21 || n4 == 23) {
            int n5 = 0;
            n5 = 10 * n5 + (byArray[n + 2] >> 4 & 0xF);
            n5 = 10 * n5 + (byArray[n + 2] & 0xF);
            n5 = 10 * n5 + (byArray[n + 3] >> 4 & 0xF);
            int n6 = 0;
            n6 = 10 * n6 + (byArray[n + 4] >> 4 & 0xF);
            n6 = 10 * n6 + (byArray[n + 4] & 0xF);
            n6 = 10 * n6 + (byArray[n + 5] >> 4 & 0xF);
            int n7 = 0;
            n7 = 10 * n7 + (byArray[n + 6] >> 4 & 0xF);
            n7 = 10 * n7 + (byArray[n + 6] & 0xF);
            n7 = 10 * n7 + (byArray[n + 7] >> 4 & 0xF);
            n7 = 10 * n7 + (byArray[n + 7] & 0xF);
            this.m_operand.set(n3 == 1 ? 0 : 128, n5, n6, n7);
        } else if (n4 == 20 || n4 == 22) {
            int n8 = 0;
            n8 = 10 * n8 + (byArray[n + 2] >> 4 & 0xF);
            n8 = 10 * n8 + (byArray[n + 2] & 0xF);
            n8 = 10 * n8 + (byArray[n + 3] >> 4 & 0xF);
            n8 = 10 * n8 + (byArray[n + 3] & 0xF);
            n8 = 10 * n8 + (byArray[n + 4] >> 4 & 0xF);
            n8 = 10 * n8 + (byArray[n + 4] & 0xF);
            int n9 = 0;
            n9 = 10 * n9 + (byArray[n + 6] >> 4 & 0xF);
            n9 = 10 * n9 + (byArray[n + 6] & 0xF);
            n9 = 10 * n9 + (byArray[n + 7] >> 4 & 0xF);
            n9 = 10 * n9 + (byArray[n + 7] & 0xF);
            this.m_operand.set(n3 == 1 ? 0 : 128, 0, n8, n9);
        } else {
            int n10 = (byArray[n + 1] & 0x80) == 128 ? byArray[n + 1] & 0x7F : -1 * (128 - byArray[n + 1]);
            long l = 0L;
            for (int i = n + 2; i < n + 9; ++i) {
                l = 10L * l;
                l += (long)(byArray[i] >> 4 & 0xF);
                l = 10L * l;
                l += (long)(byArray[i] & 0xF);
            }
            this.m_operand.set(n2, n10, l);
        }
    }

    @Override
    public boolean isFraction() {
        return this.m_operand.isFrac();
    }

    @Override
    public String getFractionSign() {
        return this.m_operand.sign == 0 ? "" : "-";
    }

    @Override
    public String getFractionUnit() {
        if (this.isFraction()) {
            return this.m_operand.wholenum + "";
        }
        return super.getFractionUnit();
    }

    @Override
    public String getFractionNumerator() {
        if (this.isFraction()) {
            return this.m_operand.numerator + "";
        }
        return super.getFractionUnit();
    }

    @Override
    public String getFractionDenominator() {
        if (this.isFraction()) {
            return this.m_operand.denominator + "";
        }
        return super.getFractionUnit();
    }

    @Override
    public String toUniFractionString() {
        if (this.isFraction()) {
            return this.m_operand.toUniString();
        }
        return this.toString();
    }

    public void setValue(String string) {
        if (string.equals("NaN")) {
            this.setNaN(true);
        } else {
            this.setFloatFromString(string);
        }
    }

    protected void setFractionFromString(String string) {
        try {
            Operand operand;
            int n = 0;
            int n2 = string.indexOf(" ");
            if (n2 != -1) {
                operand = new Operand(string.substring(n, n2));
                n = n2 + 1;
            } else {
                operand = new Operand(MathUtil._0_);
            }
            int n3 = string.indexOf("/");
            Operand operand2 = new Operand(string.substring(n, n3));
            n = n3 + 1;
            Operand operand3 = new Operand(string.substring(n, string.length()));
            try {
                this.m_operand = new Operand(operand, operand2, operand3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setNaN(true);
            }
        }
        catch (Exception exception) {
            this.setNaN(true);
        }
    }

    private void setFloatFromString(String string) {
        try {
            this.m_operand = new Operand(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setNaN(true);
        }
    }

    @Override
    public NumberFormatter getNumberFormatter() {
        return null;
    }

    public Operand getOperand() {
        return this.m_operand;
    }

    @Override
    public double doubleValue() {
        return VarConverter83.doubleFromMathPack2(this.m_operand);
    }

    @Override
    public float floatValue() {
        return (float)VarConverter83.doubleFromMathPack2(this.m_operand);
    }

    @Override
    public byte byteValue() {
        return (byte)VarConverter83.doubleFromMathPack2(this.m_operand);
    }

    @Override
    public short shortValue() {
        return (short)VarConverter83.doubleFromMathPack2(this.m_operand);
    }

    @Override
    public int intValue() {
        return (int)VarConverter83.doubleFromMathPack2(this.m_operand);
    }

    @Override
    public long longValue() {
        return (long)VarConverter83.doubleFromMathPack2(this.m_operand);
    }

    public Z80Number round() {
        Z80Number z80Number = new Z80Number(this);
        MathUtil.rndguard(z80Number.getOperand());
        return z80Number;
    }

    public String toString() {
        return this.m_operand.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Z80Number) {
            return this.m_operand.equals(((Z80Number)object).getOperand());
        }
        if (object instanceof Number) {
            return this.doubleValue() == ((Number)object).doubleValue();
        }
        return false;
    }

    public int hashCode() {
        Operand operand = new Operand(this.getOperand());
        return operand.fracToDec().toString().hashCode();
    }

    public void setNaN(boolean bl) {
        this.m_operand.NaN = bl;
    }

    @Override
    public boolean isNaN() {
        return this.m_operand.NaN;
    }

    public void setInfinite(boolean bl) {
        this.m_infinite = bl;
    }

    @Override
    public boolean isInfinite() {
        return this.m_infinite;
    }

    public boolean isRealOrFrac() {
        return !this.isNaN() && !this.isInfinite();
    }

    void handleException(MathException mathException) {
        this.setNaN(true);
        if (mathException.getText() == "DIVIDE BY 0") {
            this.setInfinite(true);
            this.setNaN(true);
        } else if (mathException.getText() == "NON REAL ANSWER") {
            this.setNaN(true);
        } else if (mathException.getText() == "DOMAIN") {
            this.setInfinite(true);
            this.setNaN(true);
        } else if (mathException.getText() == "OVERFLOW") {
            this.setInfinite(true);
            this.setNaN(true);
        }
    }

    static {
        INFINITY.setInfinite(true);
        INFINITY.setNaN(true);
        NaN = new Z80Number(0.0);
        NaN.setNaN(true);
    }
}

