/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.math;

import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathEngine;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.z80.math.MathException;
import com.ti.eps.calc.z80.math.MathPack;
import com.ti.eps.calc.z80.math.Operand;
import com.ti.eps.calc.z80.math.Z80Number;
import java.util.logging.Logger;

public class Z80MathEngine
extends MathEngine {
    private static final Logger log = Logger.getLogger(Z80MathEngine.class.getName());
    private static MathEngine INSTANCE = new Z80MathEngine();

    protected Z80MathEngine() {
    }

    public static MathEngine getInstance() {
        return INSTANCE;
    }

    @Override
    public MathNumber getNumberFromString(String string) {
        return new Z80Number(string);
    }

    @Override
    public Number finishEvaluation(Number number, MathContext mathContext) {
        if (!(number instanceof Z80Number)) {
            number = new Z80Number(number.doubleValue());
            log.fine("Wrong type of number.  Expecting Z80Number.  Got " + number.getClass() + " for " + number.toString());
        }
        Z80Number z80Number = (Z80Number)number;
        try {
            MathPack.checkvalid83num(z80Number.getOperand());
        }
        catch (MathException mathException) {
            z80Number = Z80Number.INFINITY;
        }
        return z80Number;
    }

    @Override
    public Number add(Number number, Number number2, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        Z80Number z80Number2 = new Z80Number(number2);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        if (!z80Number2.isRealOrFrac()) {
            return z80Number2;
        }
        try {
            MathPack.chkFracfpadd(z80Number.getOperand(), z80Number2.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number subtract(Number number, Number number2, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        Z80Number z80Number2 = new Z80Number(number2);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        if (!z80Number2.isRealOrFrac()) {
            return z80Number2;
        }
        try {
            MathPack.chkFracfpsub(z80Number.getOperand(), z80Number2.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number mult(Number number, Number number2, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        Z80Number z80Number2 = new Z80Number(number2);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        if (!z80Number2.isRealOrFrac()) {
            return z80Number2;
        }
        try {
            MathPack.chkFracfpmult(z80Number.getOperand(), z80Number2.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number divide(Number number, Number number2, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        Z80Number z80Number2 = new Z80Number(number2);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        if (!z80Number2.isRealOrFrac()) {
            return z80Number2;
        }
        try {
            MathPack.chkFracfpdiv(z80Number.getOperand(), z80Number2.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number sin(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpsin(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number cos(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpcos(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number tan(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fptan(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number asin(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpasin(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number acos(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpacos(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number atan(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpatan(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number sinh(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpsinh(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number cosh(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpcosh(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number tanh(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fptanh(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number sqrt(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.chkFracfpsqroot(z80Number.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number floor(Number number, MathContext mathContext) {
        return new Z80Number(Math.floor(number.doubleValue()));
    }

    @Override
    public Number naturalLog(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpln(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number exp(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpetox(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number log(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fplog(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number abs(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        MathPack.fpabs(z80Number.getOperand());
        return z80Number;
    }

    @Override
    public Number power(Number number, Number number2, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        Z80Number z80Number2 = new Z80Number(number2);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        if (!z80Number2.isRealOrFrac()) {
            return z80Number2;
        }
        try {
            MathPack.chkFracfpytox(z80Number.getOperand(), z80Number2.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number negative(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        MathPack.fpnegate(z80Number.getOperand());
        return z80Number;
    }

    @Override
    public Number pi(MathContext mathContext) {
        return new Z80Number(MathPack.fpPI());
    }

    @Override
    public Number e(MathContext mathContext) {
        return new Z80Number(new Operand(0, 0, 27182818284590L));
    }

    @Override
    public Number tenToX(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fptenx(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number inverse(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.chkFracfprecip(z80Number.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number square(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.chkFracfpsquare(z80Number.getOperand());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number acosh(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpacosh(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number asinh(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpasinh(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    @Override
    public Number atanh(Number number, MathContext mathContext) {
        Z80Number z80Number = new Z80Number(number);
        if (!z80Number.isRealOrFrac()) {
            return z80Number;
        }
        try {
            MathPack.fpatanh(z80Number.getOperand().fracToDec());
        }
        catch (MathException mathException) {
            Z80MathEngine.handleException(mathException, z80Number);
        }
        return z80Number;
    }

    private static void handleException(MathException mathException, Z80Number z80Number) {
        z80Number.handleException(mathException);
    }
}

