/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80.assessment;

import com.ti.eps.calc.z80.assessment.Z80AssessmentFile;
import com.ti.eps.calc.z80.assessment.Z80AssessmentObj;
import java.io.IOException;
import java.io.OutputStream;

public class Z80AssessmentFileAnswer
extends Z80AssessmentFile {
    private final int status;
    private final int currentEntry;
    private final int topEntry;

    public Z80AssessmentFileAnswer(int n, int n2, int n3, Z80AssessmentObj[] z80AssessmentObjArray) {
        super(1851880965, z80AssessmentObjArray);
        this.status = n;
        this.currentEntry = n2;
        this.topEntry = n3;
    }

    public int getStatus() {
        return this.status;
    }

    public int getCurrentEntry() {
        return this.currentEntry;
    }

    public int getTopEntry() {
        return this.topEntry;
    }

    @Override
    public int getSize() {
        return 11 + this.getObjsSize();
    }

    public void write(OutputStream outputStream) throws IOException {
        int n = this.getSize();
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(Z80AssessmentFileAnswer.intToByte4(1851880965));
        outputStream.write(5);
        outputStream.write(0);
        outputStream.write(this.status & 0xFF);
        outputStream.write(this.currentEntry & 0xFF);
        outputStream.write(this.currentEntry >> 8 & 0xFF);
        outputStream.write(this.topEntry & 0xFF);
        outputStream.write(this.topEntry >> 8 & 0xFF);
        this.writeObjs(outputStream);
    }

    private static byte[] intToByte4(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n >>= 8) & 0xFF);
        byArray[1] = (byte)((n >>= 8) & 0xFF);
        byArray[0] = (byte)((n >>= 8) & 0xFF);
        return byArray;
    }
}

