/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

import com.ti.eps.calc.TiCalc;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DeviceFileImpl;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import com.ti.eps.calc.math.MathConverter;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.z80.Z80Utils;
import com.ti.eps.calc.z80.math.Z80Number;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class Z80DeviceFile
extends DeviceFileImpl {
    private static final Logger LOGGER = Logger.getLogger("Z80DeviceFile");
    public static final int MAX_NAME_LEN = 8;
    public static final int FILE_COMMENT_LEN = 42;
    protected static final int FILE_HEADER_LEN = 11;
    protected static final int SIZE_LEN = 2;
    protected static final int CHECKSUM_LEN = 2;
    protected static final int MAX_MSG_BLOCK1_LEN = 32;
    private byte[] fileComment = new byte[42];

    public Z80DeviceFile(DBUSDataType dBUSDataType) {
        super(dBUSDataType);
    }

    public Z80DeviceFile(File file) throws InvalidDeviceFileException, IOException {
        super(file);
    }

    public Z80DeviceFile(InputStream inputStream) throws InvalidDeviceFileException, IOException {
        super(inputStream);
    }

    @Override
    public void setName(DeviceString deviceString) {
        String string = this.getDataType().getName();
        if (!("Window Range".equals(string) || "Table Setup".equals(string) || "User Zoom Window".equals(string) || deviceString == null || deviceString.toBytes().length <= 8)) {
            String string2 = "Device file name too long.  name=" + deviceString + " len=" + deviceString.toBytes().length + " max=" + 8;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
            illegalArgumentException.printStackTrace();
            throw illegalArgumentException;
        }
        super.setName(deviceString);
    }

    @Override
    public String getObjectName() {
        if (this.getDataType().getName().equals("Real List")) {
            String string = this.getName().toAscii().replaceAll("theta", "T");
            if (string.equals("L1") | string.equals("L2") | string.equals("L3") | string.equals("L4") | string.equals("L5") | string.equals("L6")) {
                return string;
            }
            return string.replaceFirst("L", "");
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    @Override
    public Object getData() {
        if (this.getDataType().getName().equals("Real List")) {
            return this.createListData();
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    @Override
    public void setData(Object object) {
        if (!this.getDataType().getName().equals("Real List")) {
            throw new IllegalArgumentException("Unsupported data type");
        }
        this.setListData(object);
    }

    private void setListData(Object object) throws IllegalArgumentException {
        if (!"Real List".equals(this.getDataType().getName()) || !(object instanceof List)) {
            throw new IllegalArgumentException("Unsupported data type");
        }
        List list = (List)object;
        byte[] byArray = Z80DeviceFile.getRealListBytes(list, this.getDeviceCode());
        this.setDatablock(byArray);
    }

    private static byte[] getRealListBytes(List<Number> list, DBUSDeviceCode dBUSDeviceCode) {
        DBUSDeviceHandler dBUSDeviceHandler = TiCalc.getDeviceHandler(DBUSDeviceCode.UNIT_83PLUS);
        MathConverter mathConverter = dBUSDeviceHandler.getMathConverter();
        int n = mathConverter.deviceFromMathNumber(Z80Number.ZERO, dBUSDeviceCode).length;
        int n2 = 0;
        byte[] byArray = new byte[2 + n * list.size()];
        byArray[n2++] = (byte)(list.size() & 0xFF);
        byArray[n2++] = (byte)(list.size() >> 8 & 0xFF);
        for (int i = 0; i < list.size(); ++i) {
            Number number = list.get(i);
            mathConverter.deviceFromMathNumber((MathNumber)number, byArray, n2, dBUSDeviceCode);
            n2 += n;
        }
        return byArray;
    }

    private List<MathNumber> createListData() throws IllegalArgumentException {
        if (!"Real List".equals(this.getDataType().getName())) {
            throw new IllegalArgumentException("Unsupported data type");
        }
        DBUSDeviceHandler dBUSDeviceHandler = TiCalc.getDeviceHandler(this.getDeviceCode());
        MathConverter mathConverter = dBUSDeviceHandler.getMathConverter();
        int n = mathConverter.deviceFromMathNumber(dBUSDeviceHandler.newMathNumber(0.0), this.getDeviceCode()).length;
        ArrayList<MathNumber> arrayList = new ArrayList<MathNumber>();
        int n2 = 0;
        byte[] byArray = this.getDatablock();
        int n3 = byArray[n2++] & 0xFF;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = n3 + 256 * n4;
        for (int i = 0; i < n5; ++i) {
            MathNumber mathNumber = mathConverter.mathNumberFromDevice(byArray, n2);
            n2 += n;
            arrayList.add(mathNumber);
        }
        return arrayList;
    }

    @Override
    public void setDatablock(byte[] byArray, boolean bl) {
        if (bl) {
            int n = byArray.length;
            byte[] byArray2 = new byte[n + 2];
            byArray2[0] = (byte)(n & 0xFF);
            byArray2[1] = (byte)(n >> 8 & 0xFF);
            System.arraycopy(byArray, 0, byArray2, 2, n);
            byArray = byArray2;
        }
        this.setDatablock(byArray);
    }

    public byte[] getFileComment() {
        return this.fileComment;
    }

    public void setFileComment(byte[] byArray) {
        if (byArray == null || byArray.length > 42) {
            throw new IllegalArgumentException("Invalid file comment");
        }
        if (byArray.length < 42) {
            byte[] byArray2 = new byte[42];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        this.fileComment = byArray;
    }

    protected abstract boolean verifyHeader(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseFile(InputStream inputStream) throws InvalidDeviceFileException, IOException {
        try (BufferedInputStream bufferedInputStream = null;){
            int n = 0;
            bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[11];
            n = bufferedInputStream.read(byArray);
            if (n < 11) {
                if (n == -1) {
                    throw new InvalidDeviceFileException("End of file while reading header");
                }
                throw new BufferUnderflowException();
            }
            if (!this.verifyHeader(byArray)) {
                String string = this.getFile() != null ? this.getFile().toString() : "InputStream";
                String string2 = Z80Utils.byteArrayToHexString(byArray);
                String string3 = "Invalid header found in the file, halting parsing of the file:" + string + " header=" + string2;
                LOGGER.info(string3);
                this.setFile(null);
                throw new InvalidDeviceFileException(string3);
            }
            this.fileComment = new byte[42];
            bufferedInputStream.read(this.fileComment);
            byte[] byArray2 = new byte[2];
            bufferedInputStream.read(byArray2);
            byte[] byArray3 = new byte[2];
            bufferedInputStream.read(byArray3);
            int n2 = Z80Utils.toInt(byArray3);
            byte[] byArray4 = new byte[n2];
            bufferedInputStream.read(byArray4);
            this.parseMsgBlock1(ByteBuffer.wrap(byArray4));
            byte[] byArray5 = new byte[2];
            bufferedInputStream.read(byArray5);
            int n3 = Z80Utils.toInt(byArray5);
            byte[] byArray6 = new byte[n3];
            bufferedInputStream.read(byArray6);
            this.setDatablock(byArray6);
            byte[] byArray7 = new byte[2];
            bufferedInputStream.read(byArray7);
        }
    }

    protected void parseMsgBlock1(ByteBuffer byteBuffer) throws InvalidDeviceFileException {
        byteBuffer.getShort();
        byte by = byteBuffer.get();
        DBUSDataType dBUSDataType = DBUSDataType.find(this.getDeviceCode(), by);
        if (dBUSDataType == null) {
            throw new InvalidDeviceFileException("Invalid dataType=0x" + Integer.toHexString(by));
        }
        this.setDataType(dBUSDataType);
        byte[] byArray = new byte[8];
        byteBuffer.get(byArray);
        this.setName(byArray);
    }

    protected abstract void setName(byte[] var1);

    protected boolean isValid() {
        return true;
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        if (!this.isValid()) {
            throw new IllegalStateException("Device file data is not valid. Cannot save");
        }
        int n = 0;
        outputStream.write(this.getFileHeader());
        byte[] byArray = this.getFileComment();
        if (byArray == null) {
            byArray = new byte[42];
        }
        outputStream.write(byArray);
        n += this.calcChecksum(byArray) & 0xFF;
        byte[] byArray2 = new byte[32];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.getMsgBlock1(byteBuffer, this.getDatablock().length);
        byteBuffer.flip();
        int n2 = byteBuffer.remaining();
        int n3 = this.getDatablock().length;
        int n4 = 2 + n2 + 2 + n3;
        byte[] byArray3 = Z80Utils.toByteArray(n4, new byte[2]);
        outputStream.write(byArray3);
        byte[] byArray4 = Z80Utils.toByteArray(n2, new byte[2]);
        n += this.calcChecksum(byArray4);
        outputStream.write(byArray4);
        n += this.calcChecksum(byArray2, 0, n2);
        outputStream.write(byArray2, 0, n2);
        byte[] byArray5 = Z80Utils.toByteArray(n3, new byte[2]);
        n += this.calcChecksum(byArray5);
        outputStream.write(byArray5);
        byte[] byArray6 = this.getDatablock();
        outputStream.write(byArray6);
        outputStream.write(Z80Utils.toByteArray(n += this.calcChecksum(byArray6), new byte[2]));
    }

    protected void getMsgBlock1(ByteBuffer byteBuffer, int n) {
        byteBuffer.putShort((short)(n & 0xFFFF));
        byteBuffer.put(this.getDataType().getValue());
        byte[] byArray = this.getName().toBytes();
        if (byArray.length != 8) {
            byte[] byArray2 = new byte[8];
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, 8));
            byArray = byArray2;
        }
        byteBuffer.put(byArray);
    }

    protected abstract byte[] getFileHeader();

    private int calcChecksum(byte[] byArray) {
        return this.calcChecksum(byArray, 0, byArray.length);
    }

    private int calcChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += byArray[i] & 0xFF;
        }
        return n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("File Contents\n");
        stringBuffer.append(Z80Utils.byteArrayToHexString(this.getFileHeader()));
        stringBuffer.append(Z80Utils.byteArrayToHexString(this.getFileComment()));
        stringBuffer.append(this.getDataType());
        stringBuffer.append("\n");
        stringBuffer.append(Z80Utils.byteArrayToHexString(this.getDatablock()));
        return stringBuffer.toString();
    }
}

