/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.z80.Z80DeviceFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class Z80DBUSPacketSEND
extends DBUSPacket {
    private static final int POS_SIZE = 0;
    private static final int POS_DATA_TYPE = 2;
    private static final int POS_NAME = 3;
    private static final int MAX_NAME_LENGTH = 8;
    private static final byte[] CLEAR_NAME = new byte[8];
    private static final int MIN_PAYLOAD_LENGTH = 11;
    protected final ByteBuffer buffer;

    public Z80DBUSPacketSEND(ByteOrder byteOrder, DBUSDeviceCode dBUSDeviceCode, int n) {
        super(dBUSDeviceCode, DBUSCommand.SEND, new byte[n]);
        if (n < 11) {
            throw new IllegalArgumentException("payloadLength cannot be less than 11");
        }
        this.buffer = ByteBuffer.wrap(this.payload);
        this.buffer.order(byteOrder);
    }

    public Z80DBUSPacketSEND(ByteOrder byteOrder, DBUSDeviceCode dBUSDeviceCode, int n, Z80DeviceFile z80DeviceFile) {
        this(byteOrder, dBUSDeviceCode, n);
        this.setFile(z80DeviceFile);
    }

    public void setFile(DeviceFile deviceFile) {
        this.setDataType(deviceFile.getDataType());
        this.setObjectSize((short)deviceFile.getDatablockSize());
        this.setName(deviceFile.getName());
    }

    public void setDataType(DBUSDataType dBUSDataType) {
        this.buffer.put(2, dBUSDataType.getValue());
    }

    public void setObjectSize(short s) {
        this.buffer.putShort(0, s);
    }

    public void setName(DeviceString deviceString) {
        byte[] byArray = deviceString.toBytes();
        this.buffer.position(3);
        this.buffer.put(CLEAR_NAME);
        this.buffer.position(3);
        int n = Math.min(8, byArray.length);
        this.buffer.put(byArray, 0, n);
    }
}

