/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.z80;

import com.ti.eps.calc.util.IntHashMap;
import com.ti.eps.calc.util.StringUtil;
import com.ti.eps.calc.z80.STok;
import com.ti.eps.calc.z80.Z80STok2STokLabel;
import com.ti.eps.calc.z80.Z80STokensAsciiSC;
import com.ti.eps.calc.z80.Z80STokensUnicodeSC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class GenerateTokenizeMap {
    private static final Comparator<STok> comp = new Comparator<STok>(){

        @Override
        public int compare(STok sTok, STok sTok2) {
            int n;
            if (sTok == sTok2) {
                return 0;
            }
            int n2 = sTok.str.length();
            if (n2 > (n = sTok2.str.length())) {
                return -1;
            }
            if (n2 < n) {
                return 1;
            }
            int n3 = sTok.str.compareTo(sTok2.str);
            if (n3 != 0) {
                return n3;
            }
            if (sTok.stoken > sTok2.stoken) {
                return 1;
            }
            if (sTok.stoken < sTok2.stoken) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    };

    public static void main(String[] stringArray) throws Exception {
        STok sTok;
        TreeSet treeSet;
        int n;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        File file = new File(stringArray[0]);
        file.mkdirs();
        File file2 = new File(file, "com" + File.separator + "ti" + File.separator + "eps" + File.separator + "calc" + File.separator + "z80" + File.separator);
        file2.mkdirs();
        arrayList.add(Z80STokensAsciiSC.stokens);
        arrayList.add(Z80STokensUnicodeSC.stokens);
        String string = "Z80TokenizeMap";
        File file3 = new File(file2, string + ".java");
        PrintStream printStream = new PrintStream(new FileOutputStream(file3, false));
        printStream.println("/* Automatically generated by GenerateTokenizeMap.java */");
        printStream.println();
        printStream.println("package com.ti.eps.calc.z80;");
        printStream.println();
        printStream.println("import com.ti.util.IntHashMap;");
        printStream.println();
        printStream.println("public class " + string);
        printStream.println("{");
        HashMap<String, STok> hashMap = new HashMap<String, STok>();
        IntHashMap intHashMap = new IntHashMap();
        block2: for (n = 0; n < arrayList.size(); ++n) {
            String[] stringArray2 = (String[])arrayList.get(n);
            for (int i = 0; i < 1123; ++i) {
                try {
                    char c;
                    String string2 = stringArray2[i];
                    if (string2 == null || "".equals(string2) || (c = string2.charAt(0)) == '\ufffd') continue;
                    treeSet = (TreeSet)intHashMap.get(c);
                    if (treeSet == null) {
                        treeSet = new TreeSet(comp);
                        intHashMap.put(c, treeSet);
                    }
                    int n2 = i;
                    sTok = (STok)hashMap.get(string2);
                    if (sTok != null && sTok.stoken != n2) {
                        System.err.print("Warning: Duplicate display string: \"" + StringUtil.encodeString(string2) + "\"");
                        System.err.println(" (cur=0x" + Integer.toHexString(sTok.stoken) + "[" + Z80STok2STokLabel.stokens[sTok.stoken] + "], new=0x" + Integer.toHexString(n2) + "[" + Z80STok2STokLabel.stokens[n2] + "])");
                        treeSet.remove(sTok);
                    }
                    sTok = new STok(string2, n2);
                    hashMap.put(string2, sTok);
                    treeSet.add((STok)sTok);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                    continue block2;
                }
            }
        }
        int[] nArray = intHashMap.keys();
        printStream.print("  public static final IntHashMap map = new IntHashMap(");
        printStream.print(intHashMap.capacity());
        printStream.println(");");
        printStream.println("  static {");
        for (n = 0; n < nArray.length; ++n) {
            treeSet = (TreeSet)intHashMap.get(nArray[n]);
            Iterator iterator = treeSet.iterator();
            printStream.print("    map.put(");
            printStream.print(nArray[n]);
            printStream.println(", new STok[] {");
            while (iterator.hasNext()) {
                sTok = (STok)iterator.next();
                printStream.print("      new STok(\"");
                printStream.print(StringUtil.encodeString(sTok.str));
                printStream.print("\", 0x");
                printStream.print(Integer.toHexString(sTok.stoken).toUpperCase());
                printStream.println("),");
            }
            printStream.println("    });");
        }
        printStream.println("  }");
        printStream.println("}");
        printStream.close();
    }
}

