/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti83Plus;

import com.ti.eps.calc.TiCalc;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DeviceFileImpl;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import com.ti.eps.calc.ti83Plus.Ti83PlusConstants;
import com.ti.eps.calc.ti83Plus.Ti83PlusTokenString;
import com.ti.eps.calc.z80.Z80DeviceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Ti83PlusDeviceFile
extends Z80DeviceFile {
    private static final int MAX_EQUATIONS = 10;
    public static final byte MEMORY_RAM = 0;
    public static final byte MEMORY_ARCHIVE = -128;
    public static final byte[] validHeader83P = new byte[]{42, 42, 84, 73, 56, 51, 70, 42, 26, 10, 0};
    private byte version;

    public Ti83PlusDeviceFile(DBUSDataType dBUSDataType) {
        super(dBUSDataType);
    }

    public Ti83PlusDeviceFile(File file) throws IOException, InvalidDeviceFileException {
        super(file);
    }

    public Ti83PlusDeviceFile(InputStream inputStream) throws IOException, InvalidDeviceFileException {
        super(inputStream);
    }

    @Override
    protected byte[] getFileHeader() {
        return validHeader83P;
    }

    @Override
    protected boolean verifyHeader(byte[] byArray) {
        return DeviceFileImpl.isValidHeader(ByteBuffer.wrap(byArray), validHeader83P);
    }

    @Override
    public DBUSDeviceCode getDeviceCode() {
        return Ti83PlusConstants.UNIT_CODE;
    }

    @Override
    public byte getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(byte by) {
        this.version = by;
    }

    @Override
    protected void parseMsgBlock1(ByteBuffer byteBuffer) throws InvalidDeviceFileException {
        super.parseMsgBlock1(byteBuffer);
        if (byteBuffer.remaining() >= 2) {
            this.setVersion(byteBuffer.get());
            byte by = byteBuffer.get();
            if ((by & 0xFFFFFF80) == -128) {
                this.setArchived(true);
            }
        }
    }

    @Override
    protected void getMsgBlock1(ByteBuffer byteBuffer, int n) {
        super.getMsgBlock1(byteBuffer, n);
        byteBuffer.put(this.getVersion());
        byteBuffer.put(this.isArchived() ? (byte)-128 : 0);
    }

    @Override
    protected void setName(byte[] byArray) {
        this.setName(new Ti83PlusTokenString(byArray));
    }

    @Override
    public void setName(int n) {
        if (this.getDataType().getName().equals("Equation")) {
            if (n < 0 || n > 10) {
                throw new IllegalArgumentException("Valid equation ids are 0 to 10");
            }
        } else {
            throw new IllegalArgumentException("Unsupported datatype [" + this.getDataType() + "] for this method");
        }
        int n2 = n + 1 == 10 ? 0 : n + 1;
        String string = "Y_" + n2 + "_";
        this.setName(TiCalc.newTokenString(this.getDeviceCode(), string));
    }
}

