/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti83Plus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSControllerImpl;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSException;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DBUSPacketIOStream;
import com.ti.eps.calc.dbus.DBUSPacketRTS;
import com.ti.eps.calc.dbus.DBUSProgressEvent;
import com.ti.eps.calc.dbus.DBUSProgressListener;
import com.ti.eps.calc.dbus.DeviceConfiguration;
import com.ti.eps.calc.dbus.DeviceDirectory;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceFileDescriptor;
import com.ti.eps.calc.dbus.DeviceInformation;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.dbus.FlashFile;
import com.ti.eps.calc.dbus.FlashFileSlot;
import com.ti.eps.calc.dbus.FontString;
import com.ti.eps.calc.dbus.TIFlash;
import com.ti.eps.calc.dbus.TokenString;
import com.ti.eps.calc.dbus.exceptions.DeviceFileInaccessibleException;
import com.ti.eps.calc.dbus.exceptions.DeviceFileIncompatibleWithTarget;
import com.ti.eps.calc.dbus.exceptions.RtsOrSendTooBigException;
import com.ti.eps.calc.dbus.exceptions.UnexpectedPacketException;
import com.ti.eps.calc.ti83Plus.Ti83PlusConstants;
import com.ti.eps.calc.ti83Plus.Ti83PlusDBUSPacketRTS;
import com.ti.eps.calc.ti83Plus.Ti83PlusDeviceConfiguration;
import com.ti.eps.calc.ti83Plus.Ti83PlusDeviceFile;
import com.ti.eps.calc.ti83Plus.Ti83PlusDeviceInformation;
import com.ti.eps.calc.ti83Plus.Ti83PlusFileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Ti83PlusDBUSController
extends DBUSControllerImpl {
    private static final Logger LOGGER = Logger.getLogger("Ti83PlusDBUSController");
    protected final DBUSProgressEvent event = new DBUSProgressEvent("");

    public Ti83PlusDBUSController(DBUSPacketIOStream dBUSPacketIOStream, DBUSDeviceHandler dBUSDeviceHandler) {
        super(dBUSPacketIOStream, dBUSDeviceHandler);
    }

    private void measureQuality(boolean bl) {
        this.measureQuality(bl, 1);
    }

    private void measureQuality(boolean bl, int n) {
        if (bl) {
            ++qualityIndex;
        } else {
            ++numFailures;
            qualityIndex -= n;
        }
        --numConcurrentCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceConfiguration requestDeviceConfiguration(DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        boolean bl = false;
        Ti83PlusDeviceConfiguration ti83PlusDeviceConfiguration = null;
        try {
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDC:RDC -> " + this.io, 0.0f, this.event);
            this.io.write(DBUSPacket.RDC_PACKET);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDC:Waiting for device acknowledgement", 0.2f, this.event);
            DBUSPacket dBUSPacket = this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            ti83PlusDeviceConfiguration = new Ti83PlusDeviceConfiguration(dBUSPacket);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDC:" + this.io + " -> ACK", 0.99f, this.event);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDC:Complete", 1.0f, this.event);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
        return ti83PlusDeviceConfiguration;
    }

    @Override
    public DeviceDirectory getDirectory() throws RtsOrSendTooBigException, IOException, DBUSException {
        return this.getDirectory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceDirectory getDirectory(DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        DeviceDirectory deviceDirectory;
        boolean bl = false;
        try {
            Object object;
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Requesting device directory", 0.0f, this.event);
            this.io.write(this.packetFactory.getGetDirectoryPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknolegement", 0.1f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for memory statistics", 0.2f, this.event);
            DBUSPacket dBUSPacket = this.io.expect(this.unitCode, DBUSCommand.XDP, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending acknowledgement", 0.3f, this.event);
            this.io.write(this.packetFactory.getAckPacket());
            ArrayList<Ti83PlusFileDescriptor> arrayList = new ArrayList<Ti83PlusFileDescriptor>();
            while (true) {
                double d = Math.log(arrayList.size() + 1);
                d = d / 3.0 * 0.7;
                d = Math.min(0.7, d);
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for next directory entry", (float)(0.5 + d), this.event);
                object = this.io.read(10000);
                if (DBUSCommand.RTS.equals(((DBUSPacket)object).getCommand())) {
                    arrayList.add(new Ti83PlusFileDescriptor((DBUSPacket)object));
                } else if (DBUSCommand.DONE.equals(((DBUSPacket)object).getCommand())) break;
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending acknowledgement", (float)(0.5 + d), this.event);
                this.io.write(this.packetFactory.getAckPacket());
            }
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending DONE acknowledgement", 0.99f, this.event);
            this.io.write(this.packetFactory.getAckPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Complete", 1.0f, this.event);
            final DeviceFileDescriptor[] deviceFileDescriptorArray = arrayList.toArray(new DeviceFileDescriptor[arrayList.size()]);
            ByteBuffer byteBuffer = ByteBuffer.wrap(dBUSPacket.getPayload());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            object = byteBuffer.asShortBuffer();
            final int n = ((ShortBuffer)object).get() & 0xFFFF;
            deviceDirectory = new DeviceDirectory(){

                @Override
                public int getFreeRAM() {
                    return n;
                }

                @Override
                public DeviceFileDescriptor[] getFileDescriptors() {
                    return deviceFileDescriptorArray;
                }
            };
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl, 10);
        }
        return deviceDirectory;
    }

    @Override
    public void deleteVariable(DBUSDataType dBUSDataType, DeviceString deviceString) throws RtsOrSendTooBigException, DBUSException, IOException {
        this.deleteVariable(dBUSDataType, deviceString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVariable(DBUSDataType dBUSDataType, DeviceString deviceString, DBUSProgressListener dBUSProgressListener) throws RtsOrSendTooBigException, DBUSException, IOException {
        boolean bl = false;
        try {
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "DVL:DVL -> " + this.io, 0.25f, this.event);
            this.io.write(this.packetFactory.getDeleteVariablePacket(dBUSDataType, deviceString));
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "DVL:Waiting for device acknowledgement (ACK for DVI)", 0.3f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "DVL:Waiting for device acknowledgement (ACK for Garbage Collect)", 0.3f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 360000);
            bl = true;
        }
        finally {
            this.measureQuality(bl, 5);
        }
    }

    @Override
    public DeviceInformation requestDeviceInformation() throws RtsOrSendTooBigException, IOException, DBUSException {
        return this.requestDeviceInformation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceInformation requestDeviceInformation(DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        DBUSPacket dBUSPacket;
        boolean bl = false;
        try {
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:RDI -> " + this.io, 0.1f, this.event);
            this.io.write(this.packetFactory.getRequestDeviceInformationPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:Waiting for device acknowledgement (ACK for RDI)", 0.2f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:" + this.io + " -> ACK", 0.3f, this.event);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:RDY -> " + this.io, 0.4f, this.event);
            this.io.write(this.packetFactory.getReadyPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:Waiting for device acknowledgement (ACK for RDY)", 0.5f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:" + this.io + " -> ACK", 0.7f, this.event);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:Waiting for device information (RDI-XDP)", 0.8f, this.event);
            dBUSPacket = this.io.expect(this.unitCode, DBUSCommand.XDP, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:ACK -> " + this.io, 0.9f, this.event);
            this.io.write(this.packetFactory.getAckPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RDI:Complete", 1.0f, this.event);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl, 5);
        }
        return new Ti83PlusDeviceInformation(dBUSPacket);
    }

    @Override
    public byte[] requestIOAddress() throws RtsOrSendTooBigException, IOException, DBUSException {
        return this.requestIOAddress(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] requestIOAddress(DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        DBUSPacket dBUSPacket;
        boolean bl = false;
        try {
            ++numConcurrentCalls;
            DBUSPacket dBUSPacket2 = this.packetFactory.getRequestIOAddressPacket();
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RIOA:RIOA -> " + this.io, 0.0f, this.event);
            this.io.write(dBUSPacket2);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RIOA:Awaiting IO Address response", 0.2f, this.event);
            dBUSPacket = this.io.expect(this.unitCode, DBUSCommand.SIOA, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RIOA:" + this.io + " -> ACK", 0.7f, this.event);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RIOA:ACK -> " + this.io, 0.8f, this.event);
            this.io.write(this.packetFactory.getAckPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "RIOA:Complete", 1.0f, this.event);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
        return dBUSPacket.getPayload();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendFlashApp(FlashFile flashFile, DBUSProgressListener dBUSProgressListener) throws IOException, UnexpectedPacketException, RtsOrSendTooBigException, DBUSException {
        int n = 20;
        boolean bl = false;
        try {
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SFA:Starting", 0.0f, this.event);
            byte[] byArray = new byte[128];
            int n2 = flashFile.getNumSectors(128);
            int n3 = 0;
            byte by = flashFile.getNumSlots();
            DBUSPacketRTS dBUSPacketRTS = this.packetFactory.getRequestToSendFlashApp((short)128, (byte)0, (short)16384, (byte)0);
            DBUSPacket dBUSPacket = this.packetFactory.getTransmitDataPacket(byArray);
            for (byte by2 = 0; by2 < by; by2 = (byte)((byte)(by2 + 1))) {
                ByteBuffer byteBuffer = flashFile.getSlotData(by2);
                short s = 16384;
                while (byteBuffer.remaining() > 0) {
                    DBUSPacket dBUSPacket2;
                    short s2 = (short)Math.min(128, byteBuffer.remaining());
                    if (byArray.length != s2) {
                        byArray = new byte[s2];
                        dBUSPacket.setPayload(byArray);
                    }
                    dBUSPacketRTS.setSectorSize(s2);
                    dBUSPacketRTS.setPageNum(by2);
                    dBUSPacketRTS.setPageOffset(s);
                    dBUSPacketRTS.setBlockFlag((byte)0);
                    byteBuffer.get(byArray);
                    this.io.write(dBUSPacketRTS);
                    this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
                    this.io.expect(this.unitCode, DBUSCommand.RDY, 360000);
                    this.io.write(this.packetFactory.getAckPacket());
                    this.io.write(dBUSPacket);
                    if (by2 == 0 && s == 16384) {
                        Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Garbage Collecting...", Float.NaN, this.event);
                    }
                    if (DBUSCommand.EOR.equals((dBUSPacket2 = this.io.read(360000)).getCommand())) {
                        this.io.write(this.packetFactory.getAckPacket());
                        this.io.write(this.packetFactory.getAckPacket());
                        byte[] byArray2 = dBUSPacket2.getPayload();
                        int n4 = byArray2.length >= 3 ? byArray2[2] & 0xFF : -1;
                        DBUSException.DBUS_ERROR_CODE dBUS_ERROR_CODE = DBUSException.DBUS_ERROR_CODE.get(n4);
                        if (dBUS_ERROR_CODE != null && dBUS_ERROR_CODE.equals((Object)DBUSException.DBUS_ERROR_CODE.DUPLICATE_NAME)) {
                            this.io.expect(this.unitCode, DBUSCommand.ACK, 360000);
                        } else {
                            if (dBUS_ERROR_CODE == null && LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.log(Level.SEVERE, "Failed to map " + n4 + " to a dbus error!");
                            }
                            DBUSException.throwException(n4);
                        }
                    } else if (!DBUSCommand.ACK.equals(dBUSPacket2.getCommand())) {
                        throw new UnexpectedPacketException("Unexpected packet " + dBUSPacket2);
                    }
                    float f = Math.min(0.99f, (float)(++n3) / (float)n2);
                    Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SFA:Sent sector", f, this.event);
                    if (by2 != 0 || s != 16384) {
                        Ti83PlusDBUSController.throttle();
                    }
                    s = (short)(s + byArray.length);
                }
            }
            this.io.write(this.packetFactory.getDonePacket());
            DBUSPacket dBUSPacket3 = this.io.expect(this.unitCode, DBUSCommand.ACK, 360000);
            if (DBUSCommand.EOR.equals(dBUSPacket3.getCommand())) {
                this.io.write(this.packetFactory.getAckPacket());
                if (dBUSPacket3.getPayload().length != 3 && dBUSPacket3.getPayload().length != 5) throw new UnexpectedPacketException("Unexpected packet " + dBUSPacket3);
                byte by3 = dBUSPacket3.getPayload()[2];
                DBUSException.throwException(by3);
                return;
            } else {
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Complete", 1.0f, this.event);
                bl = true;
            }
            return;
        }
        catch (TIFlash.TIFlashException tIFlashException) {
            n = 0;
            throw tIFlashException;
        }
        finally {
            this.measureQuality(bl, n);
        }
    }

    @Override
    public void sendBaseCode(FlashFile flashFile, DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        boolean bl = false;
        int n = 20;
        try {
            float f = 0.0f;
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:Starting", f, this.event);
            byte[] byArray = new byte[256];
            int n2 = flashFile.getNumSectors(256);
            int n3 = 0;
            Iterator<FlashFileSlot> iterator = flashFile.getSlotIterator();
            DBUSPacketRTS dBUSPacketRTS = this.packetFactory.getRequestToSendBaseCode((short)256, (byte)0, (short)0, (byte)0);
            DBUSPacket dBUSPacket = this.packetFactory.getTransmitDataPacket(byArray);
            String string = this.io.toString();
            while (iterator.hasNext()) {
                byte by;
                FlashFileSlot flashFileSlot = iterator.next();
                byte by2 = flashFileSlot.getSlotNum();
                ByteBuffer byteBuffer = flashFileSlot.getData();
                boolean bl2 = by2 == 127 || by2 == -128;
                short s = bl2 ? (short)0 : 16384;
                byte by3 = by = bl2 ? (byte)-128 : 0;
                if (bl2) {
                    by2 = 0;
                }
                short s2 = s;
                while (byteBuffer.remaining() > 0) {
                    short s3 = (short)Math.min(256, byteBuffer.remaining());
                    Arrays.fill(byArray, (byte)0);
                    dBUSPacketRTS.setSectorSize((short)256);
                    dBUSPacketRTS.setPageNum(by2);
                    dBUSPacketRTS.setPageOffset(s2);
                    dBUSPacketRTS.setBlockFlag(by);
                    byteBuffer.get(byArray, 0, s3);
                    dBUSPacket.setPayload(byArray);
                    this.io.write(dBUSPacketRTS);
                    this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
                    this.io.expect(this.unitCode, DBUSCommand.RDY, 360000);
                    this.io.write(this.packetFactory.getAckPacket());
                    this.io.write(dBUSPacket);
                    DBUSPacket dBUSPacket2 = this.io.read(10000);
                    if (DBUSCommand.EOR.equals(dBUSPacket2.getCommand())) {
                        Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:" + string + " -> EOR", f, this.event);
                        Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:DONE -> " + string, f, this.event);
                        this.io.write(this.packetFactory.getDonePacket());
                        byte[] byArray2 = dBUSPacket2.getPayload();
                        int n4 = byArray2.length >= 3 ? byArray2[2] & 0xFF : -1;
                        DBUSException.throwException(n4);
                    } else if (!DBUSCommand.ACK.equals(dBUSPacket2.getCommand())) {
                        Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:" + string + " -> " + dBUSPacket2.getCommand(), f, this.event);
                        throw new UnexpectedPacketException(dBUSPacket2.toString());
                    }
                    f = Math.min(0.99f, (float)(++n3) / (float)n2);
                    Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:Sent sector", f, this.event);
                    if (by2 != 0 || s2 != 16384) {
                        Ti83PlusDBUSController.throttle();
                    }
                    s2 = (short)(s2 + byArray.length);
                }
            }
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:DONE -> " + string, f, this.event);
            this.io.write(this.packetFactory.getDonePacket());
            this.io.expect(this.unitCode, DBUSCommand.ACK, 360000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:" + string + " -> ACK", f, this.event);
            Ti83PlusDBUSController.throttle(5000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "SOS:Complete", 1.0f, this.event);
            bl = true;
        }
        catch (TIFlash.TIFlashException tIFlashException) {
            n = 0;
            throw tIFlashException;
        }
        finally {
            this.measureQuality(bl, n);
        }
    }

    @Override
    public void sendFlashApp(FlashFile flashFile) throws RtsOrSendTooBigException, IOException, DBUSException {
        this.sendFlashApp(flashFile, null);
    }

    @Override
    public void sendBaseCode(FlashFile flashFile) throws RtsOrSendTooBigException, IOException, DBUSException {
        this.sendBaseCode(flashFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIOAddress(byte[] byArray, DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        boolean bl = false;
        try {
            ++numConcurrentCalls;
            DBUSPacket dBUSPacket = this.packetFactory.getSetIOAddressPacket(byArray);
            this.io.write(dBUSPacket);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
    }

    @Override
    public void setIOAddress(byte[] byArray) throws RtsOrSendTooBigException, IOException, DBUSException {
        this.setIOAddress(byArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProgram(DeviceString deviceString, DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        boolean bl = false;
        try {
            DBUSDataType dBUSDataType;
            ++numConcurrentCalls;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Entering executeProgram(" + deviceString + ", " + dBUSProgressListener + ")");
            }
            if (deviceString instanceof TokenString) {
                dBUSDataType = DBUSDataType.find(this.unitCode, "Program");
            } else if (deviceString instanceof FontString) {
                dBUSDataType = DBUSDataType.find(this.unitCode, "Program");
            } else {
                throw new IllegalArgumentException("programName must be a token or font string");
            }
            DBUSPacket dBUSPacket = this.packetFactory.getExecuteProgramLinkPacket(dBUSDataType, deviceString);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending execute program command (EPL)", 0.0f, this.event);
            this.io.write(dBUSPacket);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgment (ACK for EPL)", 0.0f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            if (this.unitCode.equals(Ti83PlusConstants.UNIT_CODE)) {
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device to acknowledge program was executed (ACK for execute)", 0.0f, this.event);
                this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            }
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
    }

    @Override
    public void executeProgram(DeviceString deviceString) throws RtsOrSendTooBigException, IOException, DBUSException {
        this.executeProgram(deviceString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendKeys(int[] nArray, DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        boolean bl = false;
        try {
            ++numConcurrentCalls;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                DBUSPacket dBUSPacket = this.packetFactory.getSendKeyPacket((byte)(n2 & 0xFF));
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending key", 0.2f / (float)n * (float)i, this.event);
                this.io.write(dBUSPacket);
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgement of receipt.", 0.65f / (float)n * (float)i, this.event);
                this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgement of display.", 0.85f / (float)n * (float)i, this.event);
                this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            }
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Complete", 1.0f, this.event);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
    }

    @Override
    public void sendKeys(int[] nArray) throws RtsOrSendTooBigException, IOException, DBUSException {
        this.sendKeys(nArray, null);
    }

    @Override
    public void sendDataObject(DeviceFile deviceFile) throws RtsOrSendTooBigException, IOException, DBUSException {
        this.sendDataObject(deviceFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendDataObject(DeviceFile deviceFile, DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        if (!(deviceFile instanceof Ti83PlusDeviceFile)) {
            throw new IllegalArgumentException("file must be a TI-83Plus family data file");
        }
        boolean bl = false;
        Ti83PlusDeviceFile ti83PlusDeviceFile = (Ti83PlusDeviceFile)deviceFile;
        try {
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending request to send file (SEND)", 0.1f, this.event);
            this.io.write(this.packetFactory.getSendDataObjectPacket(ti83PlusDeviceFile));
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgment (ACK for SEND)", 0.2f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            try {
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for the device to be ready to receive the file (RDY)", 0.5f, this.event);
                DBUSPacket dBUSPacket = this.io.expect(this.unitCode, DBUSCommand.RDY, 10000);
                if (DBUSCommand.EOR.equals(dBUSPacket.getCommand())) {
                    throw new DeviceFileIncompatibleWithTarget(dBUSPacket.toString());
                }
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending acknowledgment (ACK for RDY)", 0.55f, this.event);
                this.io.write(this.packetFactory.getAckPacket());
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending file contents (XDP)", 0.6f, this.event);
                this.io.write(this.packetFactory.getTransmitDataPacket(ti83PlusDeviceFile.getDatablock()));
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgment (ACK for XDP)", 0.8f, this.event);
                this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            }
            finally {
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for send file completion (DONE)", 0.9f, this.event);
                this.io.write(this.packetFactory.getDonePacket());
            }
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Complete", 1.0f, this.event);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
    }

    @Override
    public DeviceFile getDataObject(DBUSDataType dBUSDataType, DeviceString deviceString) throws RtsOrSendTooBigException, IOException, DBUSException {
        return this.getDataObject(dBUSDataType, deviceString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceFile getDataObject(DBUSDataType dBUSDataType, DeviceString deviceString, DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        boolean bl = false;
        Ti83PlusDeviceFile ti83PlusDeviceFile = null;
        try {
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending request for file (GET)", 0.05f, this.event);
            this.io.write(this.packetFactory.getGetDataObjectPacket(dBUSDataType, deviceString));
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgment (ACK for GET)", 0.1f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for file information (RTS)", 0.2f, this.event);
            DBUSPacket dBUSPacket = this.io.expect(this.unitCode, DBUSCommand.RTS, 10000);
            if (DBUSCommand.EOR.equals(dBUSPacket.getCommand())) {
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending ACK after EOR", 0.9f, this.event);
                this.io.write(this.packetFactory.getDonePacket());
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Getting complete with EOR", 1.0f, this.event);
                throw new DeviceFileInaccessibleException(dBUSPacket.toString());
            }
            Ti83PlusFileDescriptor ti83PlusFileDescriptor = new Ti83PlusFileDescriptor(dBUSPacket);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending acknowledgement of file information (ACK for RTS)", 0.3f, this.event);
            this.io.write(this.packetFactory.getAckPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending ready for file (RDY)", 0.4f, this.event);
            this.io.write(this.packetFactory.getReadyPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgment (ACK for RDY)", 0.5f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for file data (XDP)", 0.6f, this.event);
            DBUSPacket dBUSPacket2 = this.io.expect(this.unitCode, DBUSCommand.XDP, 10000);
            ti83PlusDeviceFile = new Ti83PlusDeviceFile(dBUSDataType);
            ti83PlusDeviceFile.setArchived(ti83PlusFileDescriptor.isArchived());
            ti83PlusDeviceFile.setDatablock(dBUSPacket2.getPayload());
            ti83PlusDeviceFile.setName(ti83PlusFileDescriptor.getName());
            ti83PlusDeviceFile.setVersion(ti83PlusFileDescriptor.getVersion());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending acknowledgment for file data (ACK for XDP)", 0.9f, this.event);
            this.io.write(this.packetFactory.getAckPacket());
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Complete", 1.0f, this.event);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
        return ti83PlusDeviceFile;
    }

    @Override
    public void deleteFlashApp(DeviceString deviceString) throws RtsOrSendTooBigException, DBUSException, IOException {
        this.deleteFlashApp(deviceString, null);
    }

    @Override
    public void deleteFlashApp(DeviceString deviceString, DBUSProgressListener dBUSProgressListener) throws RtsOrSendTooBigException, DBUSException, IOException {
        this.deleteVariable(Ti83PlusConstants.DATA_TYPE_FLASHAPP_INTERNAL, deviceString, dBUSProgressListener);
    }

    @Override
    public FlashFile getFlashApp(DeviceString deviceString) throws RtsOrSendTooBigException, DBUSException, IOException {
        return this.getFlashApp(deviceString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlashFile getFlashApp(DeviceString deviceString, DBUSProgressListener dBUSProgressListener) throws RtsOrSendTooBigException, DBUSException, IOException {
        boolean bl = false;
        FlashFile flashFile = null;
        ArrayList<FlashFileSlot> arrayList = new ArrayList<FlashFileSlot>();
        byte by = 0;
        FlashFileSlot flashFileSlot = null;
        try {
            ++numConcurrentCalls;
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending request for app (GET)", 0.05f, this.event);
            this.io.write(this.packetFactory.getGetFlashObjectPacket(Ti83PlusConstants.DATA_TYPE_FLASHAPP, deviceString));
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgment (ACK for GET)", 0.1f, this.event);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for file information (RTS)", 0.2f, this.event);
            DBUSPacket dBUSPacket = this.io.expect(this.unitCode, DBUSCommand.RTS, 10000);
            do {
                Ti83PlusDBUSPacketRTS ti83PlusDBUSPacketRTS = new Ti83PlusDBUSPacketRTS(dBUSPacket);
                byte by2 = ti83PlusDBUSPacketRTS.getPageNum();
                short s = ti83PlusDBUSPacketRTS.getPageOffset();
                byte by3 = ti83PlusDBUSPacketRTS.getBlockFlag();
                short s2 = ti83PlusDBUSPacketRTS.getSectorSize();
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending acknowledgement of file information (ACK for RTS)", 0.3f, this.event);
                this.io.write(this.packetFactory.getAckPacket());
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending ready for file (RDY)", 0.4f, this.event);
                this.io.write(this.packetFactory.getReadyPacket());
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for device acknowledgment (ACK for RDY)", 0.5f, this.event);
                this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Waiting for file data (XDP)", 0.6f, this.event);
                DBUSPacket dBUSPacket2 = this.io.expect(this.unitCode, DBUSCommand.XDP, 10000);
                byte[] byArray = dBUSPacket2.getPayload();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Received page=" + by2 + " offset=" + s + " offset=0x" + Integer.valueOf("" + s, 16) + " flag=" + by3 + " size=" + s2 + " length=" + dBUSPacket2.getLength());
                }
                Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Sending acknowledgment for file data (ACK for XDP)", 0.9f, this.event);
                this.io.write(this.packetFactory.getAckPacket());
                dBUSPacket = this.io.read(10000);
                if (by2 != by) {
                    by = by2;
                    flashFileSlot = null;
                }
                if (flashFileSlot == null) {
                    flashFileSlot = new FlashFileSlot(by);
                    flashFileSlot.setStartAddress(s);
                    arrayList.add(flashFileSlot);
                }
                flashFileSlot.append(byArray);
            } while (dBUSPacket.getCommand() == DBUSCommand.RTS);
            if (dBUSPacket.getCommand() == DBUSCommand.DONE) {
                this.io.write(this.packetFactory.getAckPacket());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Received app " + deviceString.toAscii() + " with " + arrayList.size() + " page(s)");
                }
                for (FlashFileSlot flashFileSlot2 : arrayList) {
                    flashFileSlot2.complete();
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine("Page " + flashFileSlot2.getSlotNum() + " starts at address " + flashFileSlot2.getStartAddress() + " or 0x" + Integer.toHexString(flashFileSlot2.getStartAddress()));
                }
            } else {
                throw new DBUSException("Did not receive the entire app");
            }
            flashFile = new FlashFile(deviceString, arrayList);
            Ti83PlusDBUSController.fireEvent(dBUSProgressListener, "Complete", 1.0f, this.event);
            Ti83PlusDBUSController.throttle();
            bl = true;
        }
        finally {
            this.measureQuality(bl);
        }
        return flashFile;
    }
}

