/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti73.math.equation;

import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.MathNumber;
import com.ti.eps.calc.math.equation.EquationHandler;
import com.ti.eps.calc.math.equation.FractionEquationIterator;
import com.ti.eps.calc.math.equation.ResultData;
import com.ti.eps.calc.ti73.math.equation.ASTStart;
import com.ti.eps.calc.ti73.math.equation.BinaryStreamReader;
import com.ti.eps.calc.ti73.math.equation.EquationDumpVisitor;
import com.ti.eps.calc.ti73.math.equation.EquationEvaluateVisitor;
import com.ti.eps.calc.ti73.math.equation.EquationFractionTextVisitor;
import com.ti.eps.calc.ti73.math.equation.EquationParser;
import com.ti.eps.calc.ti73.math.equation.EquationTextVisitor;
import com.ti.eps.calc.ti73.math.equation.ParseException;
import com.ti.eps.calc.ti73.math.equation.TokenMgrError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;

public class Equation
extends EquationHandler {
    private static final Logger logger = Logger.getLogger(Equation.class.getName());
    private String errorString;
    private EquationParser parser;
    private ASTStart startNode;
    private EquationEvaluateVisitor evaluateVisitor;
    private EquationDumpVisitor dumpVisitor;
    private EquationTextVisitor textVisitor;
    private EquationFractionTextVisitor fractionVisitor;
    private Object equation = new String();
    private String stringVal;
    private boolean isEmpty = false;

    public Equation(InputStream inputStream) {
        this.parseEquation(inputStream);
    }

    private void parseEquation(InputStream inputStream) {
        try {
            if (inputStream.available() == 0) {
                this.isEmpty = true;
            }
            this.parser = new EquationParser(new BufferedReader(new BinaryStreamReader(inputStream)));
            this.startNode = this.parser.start();
            this.evaluateVisitor = new EquationEvaluateVisitor();
            this.dumpVisitor = new EquationDumpVisitor();
            this.textVisitor = new EquationTextVisitor();
            this.fractionVisitor = new EquationFractionTextVisitor();
            this.equation = this.startNode.jjtAccept(this.textVisitor, null);
            this.parseError = false;
        }
        catch (ParseException parseException) {
            this.parseError = true;
            this.errorString = parseException.getLocalizedMessage();
        }
        catch (TokenMgrError tokenMgrError) {
            this.parseError = true;
            this.errorString = tokenMgrError.getLocalizedMessage();
        }
        catch (IOException iOException) {
            this.parseError = true;
            this.errorString = iOException.getLocalizedMessage();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public String getAsString() {
        if (this.stringVal != null) {
            return this.stringVal;
        }
        if (this.isEmpty()) {
            return "";
        }
        if (!this.isValid()) {
            return this.errorString;
        }
        this.stringVal = this.equation.toString();
        return this.stringVal;
    }

    @Override
    public FractionEquationIterator fractionIterator() {
        if (this.isValid()) {
            Object object = this.startNode.jjtAccept(this.fractionVisitor, null);
            if (object != null) {
                return new FractionEquationIterator(object.toString());
            }
            return new FractionEquationIterator("");
        }
        return null;
    }

    @Override
    public byte[] getAsNative(DBUSDeviceCode dBUSDeviceCode) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unsupported device type " + dBUSDeviceCode);
    }

    String dump() {
        Object object = this.startNode.jjtAccept(this.dumpVisitor, null);
        return object.toString();
    }

    @Override
    public Number evaluate(Map<String, Object> map, MathContext mathContext) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Equation is empty");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Equation was not recognized");
        }
        this.evaluateVisitor.setSymbolTable(map);
        this.evaluateVisitor.setMathContext(mathContext);
        this.stringVal = null;
        ResultData resultData = (ResultData)this.startNode.jjtAccept(this.evaluateVisitor, null);
        Object object = resultData.result;
        this.isContinuous = resultData.isContinuous;
        if (object instanceof Number) {
            MathNumber mathNumber;
            object = mathContext.getMathEngine().finishEvaluation((Number)object, mathContext);
            if (object instanceof Double) {
                Double d = (Double)object;
                if (d.isInfinite() || d.isNaN()) {
                    this.isContinuous = Boolean.FALSE;
                }
            } else if (object instanceof MathNumber && ((mathNumber = (MathNumber)object).isInfinite() || mathNumber.isNaN())) {
                this.isContinuous = Boolean.FALSE;
            }
            return (Number)object;
        }
        return new Double(object.toString());
    }
}

