/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti73;

import com.ti.eps.calc.TiCalc;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DeviceFileImpl;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import com.ti.eps.calc.ti73.Ti73Constants;
import com.ti.eps.calc.ti73.Ti73TokenString;
import com.ti.eps.calc.z80.Z80DeviceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Ti73DeviceFile
extends Z80DeviceFile {
    private static final int MAX_EQUATIONS = 4;
    public static final byte[] validHeader73 = new byte[]{42, 42, 84, 73, 55, 51, 42, 42, 26, 10, 0};

    public Ti73DeviceFile(DBUSDataType dBUSDataType) {
        super(dBUSDataType);
    }

    public Ti73DeviceFile(File file) throws IOException, InvalidDeviceFileException {
        super(file);
    }

    public Ti73DeviceFile(InputStream inputStream) throws IOException, InvalidDeviceFileException {
        super(inputStream);
    }

    @Override
    protected boolean verifyHeader(byte[] byArray) {
        return DeviceFileImpl.isValidHeader(ByteBuffer.wrap(byArray), validHeader73);
    }

    @Override
    protected byte[] getFileHeader() {
        return validHeader73;
    }

    @Override
    public DBUSDeviceCode getDeviceCode() {
        return Ti73Constants.UNIT_CODE;
    }

    @Override
    protected void setName(byte[] byArray) {
        Ti73TokenString ti73TokenString = new Ti73TokenString(byArray);
        this.setName(ti73TokenString);
    }

    @Override
    public void setName(DeviceString deviceString) {
        if ("Equation".equals(this.getDataType().getName()) && deviceString.toString().startsWith("C")) {
            this.setDataType(Ti73Constants.DATA_TYPE_CONSTANT);
        }
        super.setName(deviceString);
    }

    @Override
    public void setName(int n) {
        if (this.getDataType().getName().equals("Equation")) {
            if (n < 0 || n > 4) {
                throw new IllegalArgumentException("Valid equation ids are 0 to 4");
            }
        } else {
            throw new IllegalArgumentException("Unsupported datatype [" + this.getDataType() + "] for this method");
        }
        int n2 = n + 1;
        String string = "Y_" + n2 + "_";
        this.setName(TiCalc.newTokenString(this.getDeviceCode(), string));
    }

    @Override
    public void setVersion(byte by) {
    }

    @Override
    public byte getVersion() {
        return 0;
    }
}

