/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti73;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceHandler;
import com.ti.eps.calc.dbus.DBUSException;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DBUSPacketIOStream;
import com.ti.eps.calc.dbus.DBUSPacketRTS;
import com.ti.eps.calc.dbus.DBUSProgressListener;
import com.ti.eps.calc.dbus.DeviceConfiguration;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceInformation;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.dbus.TIFlash;
import com.ti.eps.calc.dbus.exceptions.RtsOrSendTooBigException;
import com.ti.eps.calc.ti73.Ti73DeviceConfiguration;
import com.ti.eps.calc.ti73.Ti73DeviceInformation;
import com.ti.eps.calc.ti73.Ti73LFontString;
import com.ti.eps.calc.ti83Plus.Ti83PlusDBUSController;
import java.io.IOException;

public class Ti73DBUSController
extends Ti83PlusDBUSController {
    private static final byte[] APP_HEADER = new byte[]{-128, 15, 0, 0, 63, -106, -128, 18, 1, 2, -128, 33, 1, -128, 49, 1, -128, 71, 78, 85, 77, 76, 73, 78, 69, -128, -127, 1, -128, -111, 1, 3, 38, 9, 4, 6, -4, -126, 39, 2, 13, 64, -121, -74, -64, -45, 93, 55, 64, 60, -104, -35, 103, -29, 16, 86, -32, -17, -49, -77, 2, 33, -95, -75, -118, 62, -54, -7, 26, 35, -86, 109, 72, -44, -76, -120, -21, 81, 61, 16, -11, 49, 17, 28, 76, 107, -63, 23, -106, -20, 125, -21, 4, -67, -107, -81, 75, 53, 50, -63, -66, -3, 13, -72, 88, 76, -128, 127, 0, 0, 0, 0, 0, 0, -51, 92, 0, 17, 0, -128, 1, -25, 1, -81, 18, 19, 11, 32, -5, 17, 43, -124, 1, 101, 0};

    public Ti73DBUSController(DBUSPacketIOStream dBUSPacketIOStream, DBUSDeviceHandler dBUSDeviceHandler) {
        super(dBUSPacketIOStream, dBUSDeviceHandler);
    }

    @Override
    public DeviceInformation requestDeviceInformation(DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        DeviceInformation deviceInformation = super.requestDeviceInformation(dBUSProgressListener);
        return new Ti73DeviceInformation(deviceInformation.getDBUSPacket());
    }

    @Override
    public DeviceConfiguration requestDeviceConfiguration(DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException {
        DeviceConfiguration deviceConfiguration = super.requestDeviceConfiguration(dBUSProgressListener);
        return new Ti73DeviceConfiguration(deviceConfiguration.getDBUSPacket());
    }

    @Override
    public void deleteVariable(DBUSDataType dBUSDataType, DeviceString deviceString, DBUSProgressListener dBUSProgressListener) throws IOException, RtsOrSendTooBigException, DBUSException, TIFlash.TIFlashException {
        boolean bl = false;
        int n = 2;
        try {
            ++numConcurrentCalls;
            byte[] byArray = Ti73DBUSController.getFakeAppHeader(deviceString);
            Ti73DBUSController.fireEvent(dBUSProgressListener, "DEL:Starting", 0.0f, this.event);
            DBUSPacketRTS dBUSPacketRTS = this.packetFactory.getRequestToSendFlashApp((short)128, (byte)0, (short)16384, (byte)0);
            DBUSPacket dBUSPacket = this.packetFactory.getTransmitDataPacket(byArray);
            this.io.write(dBUSPacketRTS);
            this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
            this.io.expect(this.unitCode, DBUSCommand.RDY, 10000);
            this.io.write(this.packetFactory.getAckPacket());
            this.io.write(dBUSPacket);
            Ti73DBUSController.fireEvent(dBUSProgressListener, "Garbage Collecting...", Float.NaN, this.event);
            DBUSPacket dBUSPacket2 = this.io.read(10000);
            if (DBUSCommand.EOR.equals(dBUSPacket2.getCommand())) {
                int n2;
                this.io.write(this.packetFactory.getAckPacket());
                this.io.write(this.packetFactory.getAckPacket());
                byte[] byArray2 = dBUSPacket2.getPayload();
                int n3 = n2 = byArray2.length >= 3 ? byArray2[2] & 0xFF : -1;
                if (n2 == 2) {
                    this.io.expect(this.unitCode, DBUSCommand.ACK, 10000);
                } else if (n2 != 1) {
                    throw new IOException("Error code " + n2);
                }
            } else if (!DBUSCommand.ACK.equals(dBUSPacket2.getCommand())) {
                throw new IOException("Unexpected packet " + dBUSPacket2);
            }
            this.io.write(this.packetFactory.getDonePacket());
            this.io.expect(this.unitCode, DBUSCommand.EOR, 10000);
            this.io.write(this.packetFactory.getAckPacket());
            Ti73DBUSController.fireEvent(dBUSProgressListener, "Complete", 1.0f, this.event);
            bl = true;
        }
        catch (TIFlash.TIFlashException tIFlashException) {
            n = 0;
            throw tIFlashException;
        }
        finally {
            if (bl) {
                ++qualityIndex;
            } else {
                qualityIndex -= n;
                ++numFailures;
            }
            --numConcurrentCalls;
        }
    }

    private static byte[] getFakeAppHeader(DeviceString deviceString) {
        byte[] byArray = deviceString.toBytes();
        byte[] byArray2 = new byte[128];
        System.arraycopy(APP_HEADER, 0, byArray2, 0, 16);
        byArray2[16] = -128;
        byArray2[17] = (byte)(64 + byArray.length);
        System.arraycopy(byArray, 0, byArray2, 18, byArray.length);
        int n = 18 + byArray.length;
        int n2 = byArray2.length - n;
        System.arraycopy(APP_HEADER, 25, byArray2, n, n2);
        return byArray2;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = Ti73DBUSController.getFakeAppHeader(new Ti73LFontString("FOO"));
        for (int i = 0; i < byArray.length; ++i) {
            if (i % 8 == 0) {
                System.out.println();
            }
            System.out.print("(byte) 0x" + Integer.toHexString((byArray[i] & 0xF0) >> 4) + Integer.toHexString(byArray[i] & 0xF) + ", ");
        }
    }

    public void sendDataObject(DBUSDataType dBUSDataType, DeviceFile deviceFile, DBUSProgressListener dBUSProgressListener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public DeviceFile getDataObject(DBUSDataType dBUSDataType, DeviceString deviceString, DBUSProgressListener dBUSProgressListener) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

