/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.ti73;

import com.ti.eps.calc.z80.Z80STokenOffsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseAsmTable {
    private Pattern CONST_PATTERN = Pattern.compile("\\s*(\\w+)\\s+EQU\\s+([^;]+)\\s*;?(.*)?", 2);

    public ParseAsmTable(String string) {
        try {
            File file = new File(string);
            file.mkdirs();
            File file2 = new File(file, "com" + File.separator + "ti" + File.separator + "eps" + File.separator + "calc" + File.separator + "ti73" + File.separator);
            file2.mkdirs();
            List<String> list = this.createTokensFile(file2);
            this.createTokSTok(file2, list);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void createTokSTok(File file, List<String> list) throws FileNotFoundException, IOException {
        File file2 = new File(file, "Ti73Tok2STok.java");
        PrintStream printStream = new PrintStream(new FileOutputStream(file2, false));
        printStream.println("package com.ti.eps.calc.ti73;");
        printStream.println();
        printStream.println("import com.ti.eps.calc.ti83.Ti83STokenOffsets;");
        printStream.println();
        printStream.println("public class Ti73Tok2STok");
        printStream.println("{");
        printStream.println("    static final int[] tokens = new int[0x100];");
        printStream.println("    static {");
        Class<Z80STokenOffsets> clazz = Z80STokenOffsets.class;
        Field[] fieldArray = clazz.getFields();
        HashSet<String> hashSet = new HashSet<String>();
        for (Field field : fieldArray) {
            String string = field.getName();
            if (!string.startsWith("ST")) continue;
            hashSet.add(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string.startsWith("TVAR") || "T2BYTETOK".equals(string)) {
                printStream.println("        tokens[Ti73Tokens." + string + "] = -1;");
                continue;
            }
            if (hashSet.contains("S" + string)) {
                printStream.println("        tokens[Ti73Tokens." + string + "] = Ti83STokenOffsets.S" + string + ";");
                continue;
            }
            if (string.startsWith("T")) {
                printStream.println("        tokens[Ti73Tokens." + string + "] = Ti83STokenOffsets.STINVALID; // TODO - Add token to string token table");
                continue;
            }
            printStream.println("        // " + string);
        }
        printStream.println("    }");
        printStream.println("}");
        printStream.close();
    }

    private List<String> createTokensFile(File file) throws FileNotFoundException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = new File(file, "Ti73Tokens.java");
        PrintStream printStream = new PrintStream(new FileOutputStream(file2, false));
        printStream.println("package com.ti.eps.calc.ti73;");
        printStream.println();
        printStream.println("public class Ti73Tokens");
        printStream.println("{");
        InputStream inputStream = this.getClass().getResourceAsStream("TOK73.INC");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = this.CONST_PATTERN.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1).toUpperCase();
                if ("CMDOFF3".equals(string2)) {
                    printStream.println("    // " + string);
                    continue;
                }
                arrayList.add(string2);
                String string3 = matcher.group(2).toUpperCase();
                string3 = string3.trim();
                if (Character.isDigit(string3.charAt(0)) && string3.endsWith("H")) {
                    string3 = "0x" + string3.substring(0, string3.length() - 1);
                }
                String string4 = matcher.group(3) != null ? matcher.group(3).trim() : "";
                printStream.println();
                if (!"".equals(string4)) {
                    printStream.println("    /** " + string4 + " */");
                }
                printStream.println("    public static final int " + string2 + " = " + string3 + ";");
                printStream.println();
                continue;
            }
            if (";".equals(string)) continue;
            printStream.println("    // " + string);
        }
        printStream.println("}");
        printStream.close();
        bufferedReader.close();
        return arrayList;
    }

    public static void main(String[] stringArray) {
        new ParseAsmTable(stringArray[0]);
    }
}

