/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.math.equation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FractionEquationIterator
implements Iterator<String> {
    private final String equation;
    private final ArrayList<String> list = new ArrayList();
    private Iterator<String> listIter;
    private boolean isUnit;
    private boolean isNumerator;
    private boolean isDenominator;
    private static final Pattern equationPattern = Pattern.compile("<equation>(.*)</equation>");
    private static final Pattern pattern = Pattern.compile("<fraction>([^<]*)(<numerator>[^<]+)(<denominator>[^<]+)</fraction>");
    private static final Pattern markup = Pattern.compile("<(\\w+)>");
    private transient String toHtml;

    public FractionEquationIterator(String string) {
        Matcher matcher = equationPattern.matcher(string);
        matcher.find();
        this.equation = matcher.group(1);
        Matcher matcher2 = pattern.matcher(this.equation);
        int n = 0;
        while (matcher2.find()) {
            if (n < matcher2.start()) {
                this.list.add(this.equation.substring(n, matcher2.start()));
            }
            if (matcher2.group(1) != null) {
                this.list.add("<fraction>" + matcher2.group(1));
                this.list.add(matcher2.group(2));
            } else {
                this.list.add("<fraction>" + matcher2.group(2));
            }
            this.list.add(matcher2.group(3));
            n = matcher2.end();
        }
        if (n < this.equation.length()) {
            this.list.add(this.equation.substring(n));
        }
        this.listIter = this.list.iterator();
    }

    public String getEquation() {
        return this.equation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String next() {
        this.isUnit = false;
        this.isNumerator = false;
        this.isDenominator = false;
        String string = this.listIter.next();
        Matcher matcher = markup.matcher(string);
        int n = 0;
        if (matcher.find()) {
            this.isUnit = "fraction".equals(matcher.group(1));
            this.isNumerator = "numerator".equals(matcher.group(1));
            this.isDenominator = "denominator".equals(matcher.group(1));
            n = matcher.end();
        }
        return string.substring(n);
    }

    @Override
    public boolean hasNext() {
        return this.listIter.hasNext();
    }

    public boolean isUnit() {
        return this.isUnit;
    }

    public boolean isNumerator() {
        return this.isNumerator;
    }

    public boolean isDenominator() {
        return this.isDenominator;
    }

    public boolean isFractionPart() {
        return this.isNumerator || this.isDenominator;
    }

    public void reset() {
        this.listIter = this.list.iterator();
        this.isUnit = false;
        this.isNumerator = false;
        this.isDenominator = false;
    }

    public String toString() {
        return String.format("FractionEquationIterator: equation: `%s', hasNext: %s", this.equation, this.hasNext());
    }

    public String toHtml(String string) {
        if (this.toHtml == null) {
            String string2;
            this.reset();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<table border=0 cellspacing=0 cellpadding=0><tr>");
            if (string != null) {
                stringBuilder.append("<td rowspan=2>&nbsp;");
                stringBuilder.append(string);
                stringBuilder.append(" =&nbsp;");
            }
            while (this.hasNext()) {
                string2 = this.next();
                if (!this.isFractionPart() && !string2.equals("")) {
                    stringBuilder.append("<td rowspan=2 align=right valign=middle>");
                    stringBuilder.append(string2);
                    if (!this.isUnit()) continue;
                    stringBuilder.append("&nbsp;");
                    continue;
                }
                if (!this.isNumerator()) continue;
                stringBuilder.append("<td valign=bottom align=center><u>");
                stringBuilder.append(string2);
                stringBuilder.append("</u>");
            }
            this.reset();
            stringBuilder.append("<tr>");
            while (this.hasNext()) {
                string2 = this.next();
                if (!this.isDenominator()) continue;
                stringBuilder.append("<td valign=top align=center>");
                stringBuilder.append(string2);
            }
            stringBuilder.append("<td rowspan=2>&nbsp;</table>");
            this.reset();
            this.toHtml = stringBuilder.toString();
        }
        return this.toHtml;
    }
}

