/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.math;

import java.text.ParseException;
import javax.swing.text.NumberFormatter;

public abstract class MathNumber
extends Number
implements Comparable<Number> {
    private static final long serialVersionUID = 1L;
    public static final String NaN = "NaN";

    public abstract NumberFormatter getNumberFormatter();

    public String toFormattedString() {
        try {
            return this.getNumberFormatter().valueToString(this);
        }
        catch (ParseException parseException) {
            return "Invalid";
        }
    }

    @Override
    public abstract int intValue();

    @Override
    public abstract long longValue();

    @Override
    public abstract float floatValue();

    @Override
    public abstract double doubleValue();

    @Override
    public abstract byte byteValue();

    @Override
    public abstract short shortValue();

    public abstract boolean isNaN();

    public abstract boolean isInfinite();

    public boolean isFraction() {
        return false;
    }

    public String getFractionSign() {
        throw new IllegalStateException("Not A Fraction");
    }

    public String getFractionUnit() {
        throw new IllegalStateException("Not A Fraction");
    }

    public String getFractionNumerator() {
        throw new IllegalStateException("Not A Fraction");
    }

    public String getFractionDenominator() {
        throw new IllegalStateException("Not A Fraction");
    }

    public String toUniFractionString() {
        throw new IllegalStateException("Not A Fraction");
    }

    @Override
    public int compareTo(Number number) {
        double d = this.doubleValue();
        double d2 = number.doubleValue();
        return new Double(d).compareTo(new Double(d2));
    }
}

