/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.java.math.equation;

import com.ti.eps.calc.java.math.JavaMathContext;
import com.ti.eps.calc.java.math.equation.ASTAbs;
import com.ti.eps.calc.java.math.equation.ASTAcos;
import com.ti.eps.calc.java.math.equation.ASTAcosh;
import com.ti.eps.calc.java.math.equation.ASTAdd;
import com.ti.eps.calc.java.math.equation.ASTAsin;
import com.ti.eps.calc.java.math.equation.ASTAsinh;
import com.ti.eps.calc.java.math.equation.ASTAtan;
import com.ti.eps.calc.java.math.equation.ASTAtanh;
import com.ti.eps.calc.java.math.equation.ASTCos;
import com.ti.eps.calc.java.math.equation.ASTCosh;
import com.ti.eps.calc.java.math.equation.ASTDiv;
import com.ti.eps.calc.java.math.equation.ASTExp;
import com.ti.eps.calc.java.math.equation.ASTFraction;
import com.ti.eps.calc.java.math.equation.ASTIdentifier;
import com.ti.eps.calc.java.math.equation.ASTInt;
import com.ti.eps.calc.java.math.equation.ASTLog;
import com.ti.eps.calc.java.math.equation.ASTMult;
import com.ti.eps.calc.java.math.equation.ASTNaturalLog;
import com.ti.eps.calc.java.math.equation.ASTNegative;
import com.ti.eps.calc.java.math.equation.ASTNumber;
import com.ti.eps.calc.java.math.equation.ASTPI;
import com.ti.eps.calc.java.math.equation.ASTParenExpression;
import com.ti.eps.calc.java.math.equation.ASTPower;
import com.ti.eps.calc.java.math.equation.ASTRand;
import com.ti.eps.calc.java.math.equation.ASTSin;
import com.ti.eps.calc.java.math.equation.ASTSinh;
import com.ti.eps.calc.java.math.equation.ASTSqrt;
import com.ti.eps.calc.java.math.equation.ASTStart;
import com.ti.eps.calc.java.math.equation.ASTSubtract;
import com.ti.eps.calc.java.math.equation.ASTTan;
import com.ti.eps.calc.java.math.equation.ASTTanh;
import com.ti.eps.calc.java.math.equation.ASTe;
import com.ti.eps.calc.java.math.equation.Equation;
import com.ti.eps.calc.java.math.equation.EquationParserVisitor;
import com.ti.eps.calc.java.math.equation.SimpleNode;
import com.ti.eps.calc.math.MathContext;
import com.ti.eps.calc.math.equation.ResultData;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;

public class EquationEvaluateVisitor
implements EquationParserVisitor {
    private static final String TOK_UNIT = "\u2423";
    private static final String TOK_FRACTION = "\uf01e";
    private Map<String, Object> symtab = new Hashtable<String, Object>();
    private MathContext mathContext = JavaMathContext.getInstance();

    private ResultData getValue(String string) {
        ResultData resultData = new ResultData();
        Object object = this.symtab.get(string);
        if (object instanceof Number) {
            resultData.result = object;
        } else if (object instanceof String) {
            String string2 = (String)object;
            if (string2.toUpperCase().indexOf(string.toUpperCase()) != -1) {
                throw new IllegalArgumentException("Can't define variable in terms of itself.");
            }
            Equation equation = new Equation(new StringReader(string2));
            Number number = equation.evaluate(this.symtab, this.mathContext);
            resultData.result = number;
            resultData.isContinuous = equation.isContinuous();
            this.symtab.put(string, number);
        } else if (object instanceof ResultData) {
            resultData = (ResultData)object;
        } else {
            throw new IllegalArgumentException("Variable " + string + " is not a number or a string representation of an equation.");
        }
        return resultData;
    }

    public void setSymbolTable(Map<String, Object> map) {
        this.symtab = map;
    }

    public void setMathContext(MathContext mathContext) {
        this.mathContext = mathContext;
    }

    @Override
    public Object visit(SimpleNode simpleNode, Object object) {
        System.out.println(simpleNode + ": acceptor not implemented in subclass?");
        return object;
    }

    @Override
    public Object visit(ASTStart aSTStart, Object object) {
        ResultData resultData = new ResultData();
        if (aSTStart.jjtGetNumChildren() > 0) {
            resultData = (ResultData)aSTStart.jjtGetChild(0).jjtAccept(this, resultData);
        } else {
            resultData.result = new Integer(0);
        }
        return resultData;
    }

    @Override
    public Object visit(ASTAdd aSTAdd, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAdd.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        Number number2 = (Number)((ResultData)aSTAdd.jjtGetChild((int)1).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().add(number, number2, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTSubtract aSTSubtract, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTSubtract.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        Number number2 = (Number)((ResultData)aSTSubtract.jjtGetChild((int)1).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().subtract(number, number2, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTMult aSTMult, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTMult.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        Number number2 = (Number)((ResultData)aSTMult.jjtGetChild((int)1).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().mult(number, number2, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTDiv aSTDiv, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTDiv.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        Number number2 = (Number)((ResultData)aSTDiv.jjtGetChild((int)1).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().divide(number, number2, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTIdentifier aSTIdentifier, Object object) {
        return this.getValue(aSTIdentifier.getName());
    }

    @Override
    public Object visit(ASTNumber aSTNumber, Object object) {
        ResultData resultData = (ResultData)object;
        resultData.result = aSTNumber.getValAsNumber(this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTSin aSTSin, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTSin.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().sin(number, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTCos aSTCos, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTCos.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().cos(number, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTTan aSTTan, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTTan.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().tan(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTAsin aSTAsin, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAsin.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().asin(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTAcos aSTAcos, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAcos.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().acos(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTAtan aSTAtan, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAtan.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().atan(number, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTSinh aSTSinh, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTSinh.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().sinh(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTCosh aSTCosh, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTCosh.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().cosh(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTTanh aSTTanh, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTTanh.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().tanh(number, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTAsinh aSTAsinh, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAsinh.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().asinh(number, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTAcosh aSTAcosh, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAcosh.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().acosh(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTAtanh aSTAtanh, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAtanh.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().atanh(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTSqrt aSTSqrt, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTSqrt.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().sqrt(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTAbs aSTAbs, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTAbs.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().abs(number, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTInt aSTInt, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTInt.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().floor(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTNaturalLog aSTNaturalLog, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTNaturalLog.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().naturalLog(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTExp aSTExp, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTExp.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().exp(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTLog aSTLog, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTLog.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().log(number, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTPower aSTPower, Object object) {
        ResultData resultData = (ResultData)object;
        aSTPower.jjtGetChild(0).jjtAccept(this, resultData);
        Number number = (Number)((ResultData)aSTPower.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        Number number2 = (Number)((ResultData)aSTPower.jjtGetChild((int)1).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().power(number, number2, this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTNegative aSTNegative, Object object) {
        ResultData resultData = (ResultData)object;
        Number number = (Number)((ResultData)aSTNegative.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        resultData.result = this.mathContext.getMathEngine().negative(number, this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTRand aSTRand, Object object) {
        ResultData resultData = (ResultData)object;
        resultData.result = this.mathContext.getMathEngine().random(this.mathContext);
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }

    @Override
    public Object visit(ASTPI aSTPI, Object object) {
        ResultData resultData = (ResultData)object;
        resultData.result = this.mathContext.getMathEngine().pi(this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTe aSTe, Object object) {
        ResultData resultData = (ResultData)object;
        resultData.result = this.mathContext.getMathEngine().e(this.mathContext);
        return resultData;
    }

    @Override
    public Object visit(ASTParenExpression aSTParenExpression, Object object) {
        ResultData resultData = (ResultData)object;
        resultData.result = ((ResultData)aSTParenExpression.jjtGetChild((int)0).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        return resultData;
    }

    @Override
    public Object visit(ASTFraction aSTFraction, Object object) {
        Object object2;
        ResultData resultData = (ResultData)object;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (aSTFraction.jjtGetNumChildren() == 3) {
            object2 = ((ResultData)aSTFraction.jjtGetChild((int)n++).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
            stringBuilder.append(object2);
            stringBuilder.append(TOK_UNIT);
        }
        object2 = ((ResultData)aSTFraction.jjtGetChild((int)n++).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        Object object3 = ((ResultData)aSTFraction.jjtGetChild((int)n++).jjtAccept((EquationParserVisitor)this, (Object)resultData)).result;
        stringBuilder.append(object2);
        stringBuilder.append(TOK_FRACTION);
        stringBuilder.append(object3);
        resultData.result = this.mathContext.parseMathNumber(stringBuilder.toString());
        resultData.isContinuous = resultData.isContinuous == Boolean.TRUE ? null : resultData.isContinuous;
        return resultData;
    }
}

