/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.java.math;

import com.ti.eps.calc.java.math.DoubleMathNumber;
import com.ti.eps.calc.java.math.JavaMathContext;
import com.ti.eps.calc.math.MathContext;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.text.NumberFormatter;

public class DefaultJavaNumberFormatter
extends NumberFormatter {
    private static final long serialVersionUID = 1L;
    private static final double LARGE_EXP_CUTOFF = 1.0E10;
    private static final DecimalFormat LARGE_EXP_FORMATTER = new DecimalFormat("0.##########E0");
    private static final double SMALL_EXP_CUTOFF = 1.0E-4;
    private static final DecimalFormat SMALL_EXP_FORMATTER = new DecimalFormat("0.####E0");
    private static final DecimalFormat NORMAL_EXP_FORMATTER = new DecimalFormat("#,##0.####");
    private static final int MAX_DIGITS = 10;
    private static final int MIN_INT_DIGITS = 1;
    private static final MathContext mathContext = JavaMathContext.getInstance();

    public DefaultJavaNumberFormatter(Class<?> clazz) {
        this.setValueClass(clazz);
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        String string;
        this.setValueClass(Double.class);
        BigDecimal bigDecimal = new BigDecimal(object.toString());
        double d = Math.abs(((Number)object).doubleValue());
        if (d >= 1.0E10) {
            DecimalFormat decimalFormat = LARGE_EXP_FORMATTER;
            string = decimalFormat.format(bigDecimal);
        } else if (d <= 1.0E-4) {
            DecimalFormat decimalFormat = SMALL_EXP_FORMATTER;
            string = decimalFormat.format(bigDecimal);
        } else {
            DecimalFormat decimalFormat = NORMAL_EXP_FORMATTER;
            decimalFormat.setMinimumIntegerDigits(1);
            if (d >= 1.0) {
                int n = 9 - mathContext.getMathEngine().log(new DoubleMathNumber(d), mathContext).intValue();
                if (n < 0) {
                    n = 0;
                }
                decimalFormat.setMaximumFractionDigits(n);
            } else {
                decimalFormat.setMaximumFractionDigits(9);
            }
            string = decimalFormat.format(bigDecimal);
        }
        if (string.endsWith("E0")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.equals("-0")) {
            string = "0.0";
        }
        return string;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        this.setValueClass(Double.class);
        Object object = super.stringToValue(string);
        return object;
    }
}

