/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DeviceMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DeviceMessageImpl
implements DeviceMessage {
    protected DBUSPacket packet;
    protected ByteBuffer dataBlock;

    protected DeviceMessageImpl(DBUSPacket dBUSPacket, ByteOrder byteOrder) {
        if (dBUSPacket == null) {
            throw new NullPointerException("packet argument was null");
        }
        this.packet = dBUSPacket;
        byte[] byArray = dBUSPacket.getPayload();
        if (byArray != null && byArray.length > 0) {
            this.dataBlock = ByteBuffer.wrap(byArray);
            this.dataBlock.order(byteOrder);
        }
    }

    @Override
    public DBUSPacket getDBUSPacket() {
        return this.packet;
    }

    @Override
    public DBUSDeviceCode getDeviceCode() {
        return this.packet.getDeviceCode();
    }

    @Override
    public ByteBuffer getDataBlock() {
        return this.dataBlock.duplicate();
    }
}

