/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.dbus.exceptions.InvalidDeviceFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class DeviceFileImpl
implements DeviceFile {
    private DBUSDataType dataType;
    private byte[] datablock;
    private DeviceString objectName;
    private boolean isArchived;
    private File pcFile;

    public DeviceFileImpl(DBUSDataType dBUSDataType) {
        this.setDataType(dBUSDataType);
    }

    public DeviceFileImpl(File file) throws InvalidDeviceFileException, IOException {
        this.pcFile = file;
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            this.parseFile(fileInputStream);
        }
    }

    public DeviceFileImpl(InputStream inputStream) throws InvalidDeviceFileException, IOException {
        this.parseFile(inputStream);
    }

    @Override
    public byte[] getDatablock() {
        return this.datablock;
    }

    @Override
    public void setDatablock(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("The paramter datablock is null");
        }
        this.datablock = byArray;
    }

    @Override
    public void setFile(File file) {
        this.pcFile = file;
    }

    @Override
    public File getFile() {
        return this.pcFile;
    }

    @Override
    public int getDatablockSize() {
        return this.datablock.length;
    }

    @Override
    public DBUSDataType getDataType() {
        return this.dataType;
    }

    protected void setDataType(DBUSDataType dBUSDataType) {
        DBUSDeviceCode dBUSDeviceCode = dBUSDataType.getDeviceCode();
        if (!this.getDeviceCode().equals(dBUSDeviceCode)) {
            throw new IllegalArgumentException("DataType and DeviceCode are incompatible");
        }
        this.dataType = dBUSDataType;
    }

    @Override
    public DeviceString getName() {
        return this.objectName;
    }

    @Override
    public void setName(DeviceString deviceString) {
        this.objectName = deviceString;
    }

    @Override
    public boolean isArchived() {
        return this.isArchived;
    }

    @Override
    public void setArchived(boolean bl) {
        this.isArchived = bl;
    }

    @Override
    public void save() throws FileNotFoundException, IOException {
        this.saveAs(this.pcFile);
    }

    @Override
    public void saveAs(File file) throws FileNotFoundException, IOException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file, false);
            this.save(fileOutputStream);
        }
    }

    protected abstract void parseFile(InputStream var1) throws InvalidDeviceFileException, IOException;

    public static final boolean isValidHeader(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer = byteBuffer.duplicate();
        for (int i = 0; i < 10; ++i) {
            if (!byteBuffer.hasRemaining()) {
                return false;
            }
            if (byteBuffer.get() == byArray[i]) continue;
            return false;
        }
        return true;
    }
}

