/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSPacket;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBUSPacketStreamWriter {
    private static final Logger LOGGER = Logger.getLogger("DBUSPacketStreamWriter");
    private final String name;
    private final OutputStream output;

    public DBUSPacketStreamWriter(String string, OutputStream outputStream) {
        this.name = string;
        this.output = outputStream;
    }

    public void writeDBUSPacket(DBUSPacket dBUSPacket) throws IOException {
        byte[] byArray = dBUSPacket.toBuffer();
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            stringBuffer.append(": writing packet: ");
            for (byte by : byArray) {
                String string = Integer.toHexString(by & 0xFF);
                stringBuffer.append(string.length() < 2 ? "0x0" : "0x");
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            LOGGER.finest(stringBuffer.toString());
        }
        this.output.write(byArray);
        this.output.flush();
    }

    public void close() throws IOException {
        this.output.close();
    }
}

