/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSCommand;
import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSPacket;
import com.ti.eps.calc.dbus.DBUSPacketRTS;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceString;

public abstract class DBUSPacketFactory {
    protected final DBUSDeviceCode deviceCode;
    private final DBUSPacket ackPacket;
    private final DBUSPacket rdiPacket;
    private final DBUSPacket rdyPacket;
    private final DBUSPacket donePacket;
    private final DBUSPacket rioaPacket;

    public DBUSPacketFactory(DBUSDeviceCode dBUSDeviceCode) {
        this.deviceCode = dBUSDeviceCode;
        this.ackPacket = new DBUSPacket(dBUSDeviceCode, DBUSCommand.ACK, null);
        this.rdiPacket = new DBUSPacket(dBUSDeviceCode, DBUSCommand.RDI, null);
        this.rdyPacket = new DBUSPacket(dBUSDeviceCode, DBUSCommand.RDY, null);
        this.donePacket = new DBUSPacket(dBUSDeviceCode, DBUSCommand.DONE, null);
        this.rioaPacket = new DBUSPacket(dBUSDeviceCode, DBUSCommand.RIOA, null);
    }

    public DBUSPacket getAckPacket() {
        return this.ackPacket;
    }

    public DBUSPacket getRequestDeviceInformationPacket() {
        return this.rdiPacket;
    }

    public DBUSPacket getReadyPacket() {
        return this.rdyPacket;
    }

    public DBUSPacket getDonePacket() {
        return this.donePacket;
    }

    public DBUSPacket getRequestIOAddressPacket() {
        return this.rioaPacket;
    }

    public abstract DBUSPacket getSetIOAddressPacket(byte[] var1);

    public abstract DBUSPacket getSendDataObjectPacket(DeviceFile var1);

    public abstract DBUSPacket getGetDataObjectPacket(DBUSDataType var1, DeviceString var2);

    public abstract DBUSPacket getGetFlashObjectPacket(DBUSDataType var1, DeviceString var2);

    public abstract DBUSPacket getGetDirectoryPacket();

    public abstract DBUSPacket getExecuteProgramLinkPacket(DBUSDataType var1, DeviceString var2);

    public abstract DBUSPacketRTS getRequestToSendFlashApp(short var1, byte var2, short var3, byte var4);

    public abstract DBUSPacketRTS getRequestToSendBaseCode(short var1, byte var2, short var3, byte var4);

    public abstract DBUSPacket getTransmitDataPacket(byte[] var1);

    public abstract DBUSPacket getSendKeyPacket(byte var1);

    public abstract DBUSPacket getDeleteVariablePacket(DBUSDataType var1, DeviceString var2);
}

