/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBUSException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Integer dbusErrorCode = null;

    public DBUSException() {
    }

    public DBUSException(String string) {
        super(string);
    }

    public static void throwException(int n) throws DBUSException {
        if (n == DBUS_ERROR_CODE.NO_ERROR.getOrdinal()) {
            return;
        }
        DBUSException dBUSException = new DBUSException("Got DBUS Error code: " + n);
        dBUSException.setDBUSErrorCode(n);
        throw dBUSException;
    }

    private void setDBUSErrorCode(int n) {
        this.dbusErrorCode = n;
    }

    public static int mapToTIErrorCode(int n, Exception exception, int n2, boolean bl, String string, String string2) {
        int n3;
        Logger logger = Logger.getLogger(DBUSException.class.getSimpleName());
        if (null == exception) {
            return n2;
        }
        if (exception instanceof IOException) {
            n3 = n;
        } else if (exception instanceof DBUSException) {
            DBUSException dBUSException = (DBUSException)exception;
            boolean bl2 = true;
            switch (dBUSException.getHostExceptionType()) {
                case INPUT_FLASH_FILE_FORMAT_EXCEPTION: {
                    if (exception.getMessage() != null && exception.getMessage().equals("Binary format FlashApp file aren't currently supported")) {
                        n3 = 65;
                        break;
                    }
                    n3 = 103;
                    break;
                }
                case INVALID_DEVICE_FILE_EXCEPTION: {
                    n3 = -1;
                    break;
                }
                case RTS_OR_SEND_TOO_BIG_EXCEPTION: {
                    n3 = 40;
                    break;
                }
                case TIMEOUT_EXCEPTION: {
                    n3 = 5;
                    break;
                }
                case UNEXPECTED_PACKET_EXCEPTION: {
                    n3 = 28;
                    break;
                }
                case DEVICE_FILE_INACCESSIBLE: {
                    n3 = 7;
                    break;
                }
                case DEVICE_FILE_INVALID_TARGET: {
                    n3 = 65;
                    break;
                }
                case NONE: {
                    bl2 = false;
                    int n4 = dBUSException.dbusErrorCode;
                    DBUS_ERROR_CODE dBUS_ERROR_CODE = DBUS_ERROR_CODE.get(n4);
                    n3 = dBUS_ERROR_CODE.getTIStatus(bl);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (bl2 && dBUSException.dbusErrorCode != null) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        logger.log(Level.SEVERE, String.format("%s %s StatusCode: %d", string2, exception.getMessage(), n3));
        return n3;
    }

    public HOST_EXCEPTION getHostExceptionType() {
        return HOST_EXCEPTION.NONE;
    }

    public static enum DBUS_ERROR_CODE {
        NO_ERROR(0, 0),
        QUIT_OR_MEMORY_FULL(1, 75),
        DUPLICATE_NAME(2, 32),
        MEMORY_FULL(3, 30),
        LEGACY_INVALID_CERT(4, 33),
        DATA_NOT_AVAILABLE(3, 7),
        BUSY(5, 18),
        CERTIFICATE_INVALID(6, 33),
        NO_CERTIFICATE(7, 34),
        BAD_SIGNATURE(8, 35),
        EXPIRED_CERTIFICATE(9, 36),
        CAN_NOT_REPLACE_CERTIFICATION(10, 37),
        BAD_LOAD_ADDRESS(11, 38),
        BATTERIES_TOO_LOW_FOR_FLASH_OPERATION(12, 39),
        RTS_OR_SEND_TOO_BIG(20, 40),
        ERROR_ERASING(21, 41),
        ERROR_WRITING(22, 42),
        ITEM_IS_LOCKED(30, 8),
        ITEM_IS_ARCHIVED(31, 9),
        ILLEGAL_DATA_TYPE(32, 48),
        DATA_TYPE_MISMATCH(33, 49),
        FOLDER_NOT_EMPTY(34, 50),
        UNABLE_TO_DELETE(35, 51),
        OS_UPDATE_NOT_ALLOWED(36, 54),
        OVERWRITE_OF_DATA_OBJECT_FAILED(37, 55),
        CANNOT_OVERWRITE_A_RESERVED_SYSTEM_OBJECT(38, 56),
        NAME_IS_ILLEGAL_OR_TOO_LONG_OR_BAD(39, 57),
        CALCULATOR_MISMATCH(97, 45),
        BAD_FILE_FORMAT(98, 44),
        BATTERIES_LOW(99, 6);

        private static volatile HashMap<Byte, DBUS_ERROR_CODE>[] ordinalToEnum;
        byte ordinal;
        int tiStatus;

        private DBUS_ERROR_CODE(int n2, int n3) {
            if ((n2 & 0xFF) != n2) {
                throw new IllegalArgumentException();
            }
            this.ordinal = (byte)n2;
            this.tiStatus = n3;
        }

        public byte getOrdinal() {
            return this.ordinal;
        }

        public int getTIStatus(boolean bl) {
            int n = bl && this.equals((Object)QUIT_OR_MEMORY_FULL) ? 31 : this.tiStatus;
            return n;
        }

        public static DBUS_ERROR_CODE get(int n) {
            int n2 = n & 0xFF;
            if (n2 != n) {
                return null;
            }
            return DBUS_ERROR_CODE.get((byte)n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DBUS_ERROR_CODE get(byte by) {
            HashMap<Byte, DBUS_ERROR_CODE> hashMap = ordinalToEnum[0];
            if (null != hashMap) return hashMap.get(by);
            HashMap<Byte, DBUS_ERROR_CODE>[] hashMapArray = ordinalToEnum;
            synchronized (ordinalToEnum) {
                hashMap = ordinalToEnum[0];
                if (null != hashMap) return hashMap.get(by);
                DBUS_ERROR_CODE[] dBUS_ERROR_CODEArray = DBUS_ERROR_CODE.values();
                hashMap = new HashMap(dBUS_ERROR_CODEArray.length);
                for (DBUS_ERROR_CODE dBUS_ERROR_CODE : dBUS_ERROR_CODEArray) {
                    hashMap.put(dBUS_ERROR_CODE.getOrdinal(), dBUS_ERROR_CODE);
                }
                DBUS_ERROR_CODE.ordinalToEnum[0] = hashMap;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return hashMap.get(by);
            }
        }

        static {
            ordinalToEnum = new HashMap[]{null};
        }
    }

    public static enum HOST_EXCEPTION {
        NONE,
        INPUT_FLASH_FILE_FORMAT_EXCEPTION,
        INVALID_DEVICE_FILE_EXCEPTION,
        RTS_OR_SEND_TOO_BIG_EXCEPTION,
        TIMEOUT_EXCEPTION,
        UNEXPECTED_PACKET_EXCEPTION,
        DEVICE_FILE_INACCESSIBLE,
        DEVICE_FILE_INVALID_TARGET;

    }
}

