/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import com.ti.eps.calc.dbus.DBUSDataType;
import com.ti.eps.calc.dbus.DBUSDeviceCode;
import com.ti.eps.calc.dbus.DBUSException;
import com.ti.eps.calc.dbus.DBUSProgressListener;
import com.ti.eps.calc.dbus.DeviceConfiguration;
import com.ti.eps.calc.dbus.DeviceDirectory;
import com.ti.eps.calc.dbus.DeviceFile;
import com.ti.eps.calc.dbus.DeviceInformation;
import com.ti.eps.calc.dbus.DeviceString;
import com.ti.eps.calc.dbus.FlashFile;
import com.ti.eps.calc.dbus.TIFlash;
import com.ti.eps.calc.dbus.exceptions.RtsOrSendTooBigException;
import com.ti.eps.calc.dbus.exceptions.TimeoutException;
import com.ti.eps.calc.dbus.exceptions.UnexpectedPacketException;
import java.io.IOException;

public interface DBUSController {
    public static final int TWO_SECOND_TIMEOUT = 10000;
    public static final int SIX_SECOND_TIMEOUT = 10000;
    public static final int SIX_MINUTE_TIMEOUT = 360000;

    public DBUSDeviceCode getDeviceCode() throws IOException, RtsOrSendTooBigException, DBUSException;

    public DBUSDeviceCode getDeviceCode(DBUSProgressListener var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public DeviceConfiguration requestDeviceConfiguration() throws IOException, RtsOrSendTooBigException, DBUSException;

    public DeviceConfiguration requestDeviceConfiguration(DBUSProgressListener var1) throws IOException, RtsOrSendTooBigException, DBUSException;

    public DeviceInformation requestDeviceInformation() throws RtsOrSendTooBigException, IOException, DBUSException;

    public DeviceInformation requestDeviceInformation(DBUSProgressListener var1) throws IOException, RtsOrSendTooBigException, DBUSException;

    public byte[] requestIOAddress() throws RtsOrSendTooBigException, IOException, DBUSException;

    public byte[] requestIOAddress(DBUSProgressListener var1) throws IOException, RtsOrSendTooBigException, DBUSException;

    public void setIOAddress(byte[] var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public void setIOAddress(byte[] var1, DBUSProgressListener var2) throws IOException, RtsOrSendTooBigException, DBUSException;

    public DeviceDirectory getDirectory() throws RtsOrSendTooBigException, IOException, DBUSException;

    public DeviceDirectory getDirectory(DBUSProgressListener var1) throws TimeoutException, IOException, RtsOrSendTooBigException, DBUSException;

    public void sendFlashApp(FlashFile var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public void sendFlashApp(FlashFile var1, DBUSProgressListener var2) throws TIFlash.TIFlashException, IOException, RtsOrSendTooBigException, DBUSException;

    public void deleteFlashApp(DeviceString var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public void deleteFlashApp(DeviceString var1, DBUSProgressListener var2) throws RtsOrSendTooBigException, IOException, DBUSException;

    public FlashFile getFlashApp(DeviceString var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public FlashFile getFlashApp(DeviceString var1, DBUSProgressListener var2) throws RtsOrSendTooBigException, IOException, DBUSException;

    public void sendBaseCode(FlashFile var1) throws TIFlash.TIFlashException, UnexpectedPacketException, RtsOrSendTooBigException, IOException, DBUSException;

    public void sendBaseCode(FlashFile var1, DBUSProgressListener var2) throws TIFlash.TIFlashException, UnexpectedPacketException, IOException, RtsOrSendTooBigException, DBUSException;

    public void executeProgram(DeviceString var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public void executeProgram(DeviceString var1, DBUSProgressListener var2) throws IOException, RtsOrSendTooBigException, DBUSException;

    public void sendKeys(int[] var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public void sendKeys(int[] var1, DBUSProgressListener var2) throws IOException, RtsOrSendTooBigException, DBUSException;

    public void deleteVariable(DBUSDataType var1, DeviceString var2) throws RtsOrSendTooBigException, DBUSException, IOException;

    public void deleteVariable(DBUSDataType var1, DeviceString var2, DBUSProgressListener var3) throws RtsOrSendTooBigException, DBUSException, IOException;

    public void sendDataObject(DeviceFile var1) throws RtsOrSendTooBigException, IOException, DBUSException;

    public void sendDataObject(DeviceFile var1, DBUSProgressListener var2) throws IOException, RtsOrSendTooBigException, DBUSException;

    public DeviceFile getDataObject(DBUSDataType var1, DeviceString var2) throws RtsOrSendTooBigException, IOException, DBUSException;

    public DeviceFile getDataObject(DBUSDataType var1, DeviceString var2, DBUSProgressListener var3) throws IOException, RtsOrSendTooBigException, DBUSException;
}

