/*
 * Decompiled with CFR 0.152.
 */
package com.ti.eps.calc.dbus;

import java.util.HashMap;
import java.util.Map;

public class DBUSCommand {
    public static final DBUSCommand ACK = new DBUSCommand(86, "ACK", "Acknowledge");
    public static final DBUSCommand CHK = new DBUSCommand(90, "CHK", "Checksum Error");
    public static final DBUSCommand DBL = new DBUSCommand(42, "DBL", "Disable Background Processing Link");
    public static final DBUSCommand DKE = new DBUSCommand(44, "DKE", "Disable Key Echo");
    public static final DBUSCommand DONE = new DBUSCommand(-110, "DONE", "Done");
    public static final DBUSCommand DVL = new DBUSCommand(-120, "DVL", "Delete Variable Link");
    public static final DBUSCommand EBL = new DBUSCommand(41, "EBL", "Enable Background Processing Link");
    public static final DBUSCommand EKE = new DBUSCommand(43, "EKE", "Enable Key Echo");
    public static final DBUSCommand EOR = new DBUSCommand(54, "EOR", "Error on Request");
    public static final DBUSCommand EPL = new DBUSCommand(-119, "EPL", "Execute Program Link");
    public static final DBUSCommand GET = new DBUSCommand(-94, "GET", "Get Data Object");
    public static final DBUSCommand GTE = new DBUSCommand(-73, "GTE", "Get Data Element");
    public static final DBUSCommand RDC = new DBUSCommand(104, "RDC", "Request Device Characteristics");
    public static final DBUSCommand RDI = new DBUSCommand(45, "RDI", "Request Device Information");
    public static final DBUSCommand REQ = new DBUSCommand(109, "REQ", "Request Screen Image");
    public static final DBUSCommand RDY = new DBUSCommand(9, "RDY", "Ready for Data");
    public static final DBUSCommand RIOA = new DBUSCommand(116, "RIOA", "Request I/O Address");
    public static final DBUSCommand RTC = new DBUSCommand(120, "RTC", "Request To Continue");
    public static final DBUSCommand RTS = new DBUSCommand(6, "RTS", "Request To Send");
    public static final DBUSCommand SETP = new DBUSCommand(-54, "SETP", "Send and Execute Temporary Program");
    public static final DBUSCommand SEND = new DBUSCommand(-55, "SEND", "Send Data Object");
    public static final DBUSCommand SKY = new DBUSCommand(-121, "SKY", "Send Keypress");
    public static final DBUSCommand SIOA = new DBUSCommand(71, "SIOA", "Set IO Address");
    public static final DBUSCommand XDP = new DBUSCommand(21, "XDP", "Transmit Data Packet");
    private byte value;
    private String abbr;
    private String desc;
    private static final Map<Byte, DBUSCommand> commands = new HashMap<Byte, DBUSCommand>();

    private DBUSCommand(byte by, String string, String string2) {
        this.value = by;
        this.abbr = string;
        this.desc = string2;
    }

    public byte getValue() {
        return this.value;
    }

    public String getAbbreviation() {
        return this.abbr;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        return this.abbr;
    }

    public int hashCode() {
        return this.abbr.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DBUSCommand) {
            return ((DBUSCommand)object).abbr.equals(this.abbr);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerCommand(DBUSCommand dBUSCommand) {
        Map<Byte, DBUSCommand> map = commands;
        synchronized (map) {
            commands.put(new Byte(dBUSCommand.value), dBUSCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBUSCommand find(byte by) {
        DBUSCommand dBUSCommand = null;
        Map<Byte, DBUSCommand> map = commands;
        synchronized (map) {
            dBUSCommand = commands.get(new Byte(by));
        }
        if (dBUSCommand == null) {
            return null;
        }
        if (!(dBUSCommand instanceof DBUSCommand)) {
            return null;
        }
        return dBUSCommand;
    }

    static {
        DBUSCommand.registerCommand(ACK);
        DBUSCommand.registerCommand(CHK);
        DBUSCommand.registerCommand(DBL);
        DBUSCommand.registerCommand(DKE);
        DBUSCommand.registerCommand(DONE);
        DBUSCommand.registerCommand(DVL);
        DBUSCommand.registerCommand(EBL);
        DBUSCommand.registerCommand(EKE);
        DBUSCommand.registerCommand(EOR);
        DBUSCommand.registerCommand(EPL);
        DBUSCommand.registerCommand(GET);
        DBUSCommand.registerCommand(GTE);
        DBUSCommand.registerCommand(RDC);
        DBUSCommand.registerCommand(RDI);
        DBUSCommand.registerCommand(REQ);
        DBUSCommand.registerCommand(RDY);
        DBUSCommand.registerCommand(RIOA);
        DBUSCommand.registerCommand(RTC);
        DBUSCommand.registerCommand(RTS);
        DBUSCommand.registerCommand(SETP);
        DBUSCommand.registerCommand(SEND);
        DBUSCommand.registerCommand(SKY);
        DBUSCommand.registerCommand(SIOA);
        DBUSCommand.registerCommand(XDP);
    }
}

